% Demo1D.m --- One-dimensional W-model, K-model, and hybrid model demo.
%
% This script demonstrates different 1D modeling schemes, desribed in the paper
% Digital Waveguides versus Finite Difference Structures: Equivalence and Mixed
% Modeling, Matti Karjalainen and Cumhur Erkut. EURASIP J. of Applied Signal
% Processing, Volume 2004, Number 7, pp. 978-989, 15 June 2004.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% -*- Mode: Matlab -*- %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Author          : Cumhur.Erkut@erase.hut.fi
%% Created On      : Thu Jul 01 12:55:22 2004
%% Last Modified By: Cumhur.Erkut@erase.hut.fi
%% Last Modified On: Thu Jul 01 15:12:17 2004
%% Update Count    : 118
%% Reference       : Digital Waveguides versus Finite Difference Structures: 
%%                   Equivalence and Mixed Modeling, Matti Karjalainen and
%%                   Cumhur Erkut. EURASIP J. of Applied Signal Processing,
%%                   Volume 2004, Number 7, pp. 978-989, 15 June 2004.
%%                   http://asp.hindawi.com/volume-2004/S1110865704401176.html
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clc;
help Demo1D
disp('Press any key...')
pause

clc;
sprintf(['First create an excitation signal to be fed in node N1 \n(see Figure ' ...
         '2 or Figure 3 of the paper). The length of the excitation \n' ...
         'determines the length of the animations that follow.\n'])
echo on
Uext = [1 zeros(1,399)]; % Impulse

echo off;
disp('Press any key...')
pause

sprintf(['Now set the model parameters.' ...
        '\nThe admittances should be positive-real.'...
        ])
echo on
Y1 = 0.05; % Left HS termination admittance.
Y2 = 1.00; % Characteristic admittance of the W-line or K-pipe.
YN = 0.10; % Right HS termination admittance.
 N = 50;   % Number of total nodes.
 
echo off;
disp('Press any key...')
pause

fIDX = 1;
help wmodel;
sprintf('\nPress any key to see the W-model animation in Figure(%d) ...',fIDX)
pause
echo on
PW = wmodel(Uext,Y1,Y2,N,YN,fIDX);
echo off
disp('Press any key...');pause

fIDX = 2;
help kmodel;
sprintf('\nPress any key to see the K-model animation in Figure(%d)...',fIDX)
pause
echo on
PK = kmodel(Uext,Y1,Y2,N,YN,fIDX);
echo off
disp('Press any key...');pause

fIDX = 3;
help hybridmodel;
sprintf(['\nPress any key to see the hybrid model animation in Figure(%d).\n', ...
        'After the animation, the positions of K-model, W-model, and \n',...
        'KW-Converter will be indicated ...'],fIDX)
pause
echo on
PH = hybridmodel(Uext,Y1,Y2,N,YN,fIDX);
echo off
disp('Press any key...');pause

sprintf(['The pressures PW,PK, and PH, calculated by W-,K-, and hybrid \n' ...
         'models, respectively, should be equal. This may be verified \n' ...
         'by plotting them. This basic demonstration serves as a guideline \n' ...
         'to experiment with the models. Happy experimentation!'])