function cp = gbd_cdf(x,beta)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GBD_CDF - Calculates the values of the cumulative distribution 
% function (CDF) of a distribution from the Generalized Beta Distribution.
% Statistics Toolbox is needed for this function. 
%
% Input:
%   x    = the realization matrix (sample values)
%   beta = the distribution parameters vector [beta(1) beta(2) beta(3) beta(4)]
%
% Output:
%   cp   = the CDF matrix corresponding to x
%
% Copyright (c) Helsinki University of Technology,
% Signal Processing Laboratory,
% Jan Eriksson, Juha Karvanen, and Visa Koivunen.
%
% For details see the files readme.txt
% and gpl.txt provided within the same package.
%
% Last modified: 5.9.2000
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
if nargin<2, disp('Usege: gbd_cdf(x,beta)');
             error('Not enough input arguments.');  
end
	 
cp=betacdf((x-beta(1))/beta(2),beta(3)+1,beta(4)+1);

% The end of the function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




  
  
  
