function x = gbd_inv(cp,beta)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GBD_INV - Calculates the values of the inverse function of the 
% cumulative distribution function (CDF) of a distribution from
% the Generalized Beta Distribution.
% Statistics Toolbox is needed for this function.
%
% Input:
%   cp   = the CDF value matrix  
%   beta = the distribution parameters vector [beta(1) beta(2) beta(3) beta(4)]
%
% Output:
%   x    = the realization matrix (sample values) corresponding to cp
%
% Copyright (c) Helsinki University of Technology,
% Signal Processing Laboratory,
% Jan Eriksson, Juha Karvanen, and Visa Koivunen.
%
% For details see the files readme.txt
% and gpl.txt provided within the same package.
%
% Last modified: 5.9.2000
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if nargin<2, disp('Usege: gbd_inv(cp,beta)');
             error('Not enough input arguments.');  
end

x=beta(2)*betainv(cp,beta(3)+1,beta(4)+1)+beta(1);

% The end of the function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


