function density=gbd_pdf(x,beta);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GBD_PDF - Calculates the values of the probability density
% function (PDF) of a distribution from the Generalized Beta Distribution.
%
% Input:
%   x    = the realization matrix (sample values)
%   beta = the distribution parameters vector [beta(1) beta(2) beta(3) beta(4)]
%
% Output:
%   cp   = the PDF matrix corresponding to x
%
% Copyright (c) Helsinki University of Technology,
% Signal Processing Laboratory,
% Jan Eriksson, Juha Karvanen, and Visa Koivunen.
%
% For details see the files readme.txt
% and gpl.txt provided within the same package.
%
% Last modified: 5.9.2000
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
if nargin<2, disp('Usege: gbd_pdf(x,beta)');
             error('Not enough input arguments.');  
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The PDF is given by the equation (20) in
%   Eriksson, J., Karvanen, J., and Koivunen, V.:
%   "Source Distribution Adaptive Maximum Likelihood Estimation of ICA Model", 
%   Proceedings of Second International Workshop on
%   Independent Component Analysis and Blind Signal Separation,
%   Helsinki 2000, pp. 227--232
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C=gamma(beta(3)+beta(4)+2)/(gamma(beta(3)+1)*gamma(beta(4)+1));
density=C*beta(2)^(-(beta(3)+beta(4)+1))*(x-beta(1)).^beta(3).*...
	(beta(1)+beta(2)-x).^beta(4);

% The end of the function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
