function cp = gld_cdf(x,lambda)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GLD_CDF - Calculates the values of the cumulative distribution 
% function (CDF) of a distribution from the Generalized Lambda Distribution. 
%  
% Input:
%   x      = the realization matrix (sample values)
%   lambda = the distribution parameters vector 
%            [lambda(1),lambda(2),lambda(3),lambda(4)] 
%
% Output:
%   cp     = the CDF matrix corresponding to x
%
% Copyright (c) Helsinki University of Technology,
% Signal Processing Laboratory,
% Jan Eriksson, Juha Karvanen, and Visa Koivunen.
%
% For details see the files readme.txt
% and gpl.txt provided within the same package.
%
% Last modified: 5.9.2000
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  
if nargin<2, disp('Usege: gld_cdf(x,lambda)');
             error('Not enough input arguments.');  
end
	 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% A naive binary search is employed. Error <= 2^(-epsilon).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
epsilon=50;  % max 52

cp=0.5*ones(size(x));
for j=-2:-1:-epsilon,
  cp=cp+2^j*sign(x-gld_inv(cp,lambda));
end

% The end of the function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




  
  
  
