function x = gld_inv(cp,lambda)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GLD_INV - Calculates the values of the inverse function of the cumulative 
% distribution function (CDF) of a distribution from 
% the Generalized Lambda Distribution.
%
% Input:
%   cp     = the CDF value matrix
%   lambda = the distribution parameters vector 
%            [lambda(1),lambda(2),lambda(3),lambda(4)] 
%
% Output:
%   x      = the realization matrix (sample values) corresponding to cp
%  
% Copyright (c) Helsinki University of Technology,
% Signal Processing Laboratory,
% Jan Eriksson, Juha Karvanen, and Visa Koivunen.
%
% For details see the files readme.txt
% and gpl.txt provided within the same package.
%
% Last modified: 5.9.2000
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
if nargin<2, disp('Usege: gld_inv(cp,lambda)');
             error('Not enough input arguments.');  
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The GLD family is defined through its inverse functions. For more
% information about the family, see e.g.
%   Karian, Z.A., Dudewicz, E.J., and McDonald, P.:  
%   "The Extended Generalized Lambda
%   Distribution System for Fitting Distributions to Data: 
%   History, Completion of Theory, Tables, Applications, the
%   `Final Word' on Moment Fits",
%   Communications in Statistics: Simulation and Computation,
%   1996, Vol. 25, No. 3, pp. 611--642  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x=lambda(1)+(cp.^lambda(3)-(1-cp).^lambda(4))./lambda(2);

% The end of the function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


