function density=gld_pdf(x,lambda);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GLD_PDF - Calculates the values of the probability density function (PDF)
% of a distribution from the Generalized Lambda Distribution.
%
% Input:
%   x      = the realization matrix (sample values)
%   lambda = the distribution parameters vector 
%            [lambda(1),lambda(2),lambda(3),lambda(4)]
%
% Output:
%   cp     = the PDF matrix corresponding to x
%  
% Copyright (c) Helsinki University of Technology,
% Signal Processing Laboratory,
% Jan Eriksson, Juha Karvanen, and Visa Koivunen.
%
% For details see the files readme.txt
% and gpl.txt provided within the same package.
%
% Last modified: 5.9.2000
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if nargin<2, disp('Usege: gld_pdf(x,lambda)');
             error('Not enough input arguments.');  
end

cp=gld_cdf(x,lambda);
A=cp.^(lambda(3)-1);
B=(1-cp).^(lambda(4)-1);
denominator=lambda(3).*A+lambda(4).*B;
density=lambda(2)./denominator;

% The end of the function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%