% EGLD-ICA for Matlab 5.x
% Version 1.1 September 25 2000
% Copyright (c) Helsinki University of Technology,
% Signal Processing Laboratory,
% Jan Eriksson, Juha Karvanen, and Visa Koivunen.
%
% Type egld_ica_demo for a demonstration.
% For further instructions, see readme.txt.
%
% EGLD-ICA programs:
%   egld_ica.m           - main file for the EGLD-ICA algorithm
%   fasticaegld.m        - core of EGLD-ICA algorithm
%
% Separate EGLD functions used by EGLD-ICA:
%   egld_use.m           - provides all the initialization needed
%   gbd_momentfit.m      - estimates the parameters of a GBD using the moments
%   gbd_score.m          - calculates the score and its derivative of a GBD
%   gld_cdf.m            - calculates the CDF of a GLD 
%   gld_inv.m            - calculates the inverse of the CDF of a GLD 
%   gld_momentfit.m      - estimates the parameters of a GLD using the moments 
%   gld_score.m          - calculates the score and its derivative of a GLD
%
% Additional EGLD functions (not used by EGLD-ICA):
%   gbd_cdf.m            - calculates the CDF of a GBD  
%                          Statistics Toolbox needed
%   gbd_inv.m            - calculates the inverse of the CDF of a GBD
%                          Statistics Toolbox needed
%   gbd_pdf.m            - calculates the PDF of a GBD
%   gbd_rnd.m            - random numbers from a GBD
%                          Statistics Toolbox needed 
%   gld_pdf.m            - calculates the PDF of a GLD
%   gld_rnd.m            - random numbers from a GLD 
%
% Misc:
%   contents.m           - this file
%   egld_ica_demo        - demonstration of the EGLD-ICA 
%   GLD_moment_table.mat - tables for GLD distributions  
%   gpl.txt              - The GNU General Public License
%   readme.txt           - description and instructions for functions
%
% The end of contents.m %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%






 






