function x=gbd_rnd(beta,N);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% GBD_RND - generates observations from a distribution from 
% the Generalized Beta Distribution. 
% Statistics Toolbox is needed for this function.
%
% Input:
%   beta = the distribution parameters vector [beta(1) beta(2) beta(3) beta(4)]
%   N    = the size of the sample matrix (optional)
%
% Output:
%   x    = the random sample matrix  
%
% Copyright (c) Helsinki University of Technology,
% Signal Processing Laboratory,
% Jan Eriksson, Juha Karvanen, and Visa Koivunen.
%
% For details see the files readme.txt
% and gpl.txt provided within the same package.
%
% Last modified: 5.9.2000
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if nargin==0, disp('Usege: gbd_rnd(beta,[N])');
              error('Not enough input arguments.');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% If N is not given, the default matrix size 1x1 (a single value).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin==1, N=1; end

if size(N(:),1)<2, N(2)=N(1); end;
x=beta(1)+beta(2)*betarnd(beta(3)+1,beta(4)+1,N(1),N(2));

% The end of the function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


