function pearsonb=pearson_momentfit(alpha3,alpha4);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PEARSON_MOMENTFIT - Estimates the parameters of the zero mean and unit
% variance distribution from the Pearson system using the third and
% forth central moments (the method of moments).
%
% Input
%   alpha3    = sample 3rd moment
%   alpha4    = sample 4th moment
%  
% Output
%   pearsonb = the distribution parameters vector [b0 b1 b2]
%
% Copyright (c) Helsinki University of Technology,
% Signal Processing Laboratory,
% Juha Karvanen, Jan Eriksson, and Visa Koivunen.
%
% For details see the files readme.txt
% and gpl.txt provided within the same package.
%
% Last modified: 11.9.2000
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The estimates are given by the equations (13)--(15) in
%   Karvanen, J.,Eriksson, J., and Koivunen, V.:
%   "Pearson System Based Method for Blind Separation", 
%   Proceedings of Second International Workshop on
%   Independent Component Analysis and Blind Signal Separation,
%   Helsinki 2000, pp. 585--590
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
denominator=10*alpha4-12*alpha3^2-18;
b0=-(4*alpha4-3*alpha3^2)/denominator;
b1=-alpha3*(alpha4+3)/denominator;
b2=-(2*alpha4-3*alpha3^2-6)/denominator;
pearsonb=[b0 b1 b2];

% The end of the function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%