function [phi, phi2]=pearson_score(x,b);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% PEARSON_SCORE - Calculates the score function and its derivative
% for a distribution from the Pearson system.
%
% Input:
%   x     = the realization matrix (sample values)
%   b     = the distribution parameters vector [b0 b1 b2]
%
% Output:
%   phi   = the score function matrix corresponding to x  
%   phi2  = the derivative of the score function matrix corresponding to x  
%
% Copyright (c) Helsinki University of Technology,
% Signal Processing Laboratory,
% Juha Karvanen, Jan Eriksson, and Visa Koivunen.
%
% For details see the files readme.txt
% and gpl.txt provided within the same package.
%
% Last modified: 11.9.2000
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The estimates are given by the equations (4) and (5) in
%   Karvanen, J.,Eriksson, J., and Koivunen, V.:
%   "Pearson System Based Method for Blind Separation", 
%   Proceedings of Second International Workshop on
%   Independent Component Analysis and Blind Signal Separation,
%   Helsinki 2000, pp. 585--590
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
denominator=b(1)+b(2)*x+b(3)*x.^2;
phi=-(x-b(2))./denominator;
phi2=-(b(1)+b(2)^2+2*b(2)*b(3)*x-b(3)*x.^2)./(denominator.^2);

% The end of the function %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
