
(in-package :BC)


;;; Bridge params for order 26

(defparameter Bm26
  '((0.001780186309392  0  -0.001780186309392)
    (0.011352137592333  0  -0.011352137592333)
    (0.005631830463951  0  -0.005631830463951)
    (0.001782969651195  0  -0.001782969651195)
    (0.002525706622508  0  -0.002525706622508)
    (0.002641899080629  0  -0.002641899080629)
    (0.004076284896751  0  -0.004076284896751)
    (0.001381639299206  0  -0.001381639299206)
    (0.001259594963841  0  -0.001259594963841)
    (0.001945519456769  0  -0.001945519456769)
    (0.001096965919160  0  -0.001096965919160)
    (0.007899983624018  0  -0.007899983624018)
    (0.000414024778807  0  -0.000414024778807)))

(defparameter Bm40
  '((0.001963028592833  0  -0.001963028592833)
    (0.007610744139983  0  -0.007610744139983)
    (0.011685249391444  0  -0.011685249391444)
    (0.000492406082084  0  -0.000492406082084)
    (0.002072878581736  0  -0.002072878581736)
    (0.000439842632399  0  -0.000439842632399)
    (0.002492255767683  0  -0.002492255767683)
    (0.001826166523649  0  -0.001826166523649)
    (0.002171725012662  0  -0.002171725012662)
    (0.000718074459938  0  -0.000718074459938)
    (0.000021336226785  0  -0.000021336226785)
    (0.001119637483961  0  -0.001119637483961)
    (0.002085393472166  0  -0.002085393472166)
    (0.000125717955635  0  -0.000125717955635)
    (0.001095013130589  0  -0.001095013130589)
    (0.000216350945750  0  -0.000216350945750)
    (0.000055985166051  0  -0.000055985166051)
    (0.007519787780180  0  -0.007519787780180)
    (0.000028768594761  0  -0.000028768594761)
    (0.000442227276324  0  -0.000442227276324)))


(defparameter Am26
  '((1.000000000000000  -0.903307254813667   0.662598134239459)
    (1.000000000000000  -1.506106230415777   0.866123505047188)
    (1.000000000000000  -1.740094975519848   0.942297622875900)
    (1.000000000000000  -1.858209192977483   0.914437197381377)
    (1.000000000000000  -1.863361819173696   0.984880251371864)
    (1.000000000000000  -1.903066522820922   0.977600180821678)
    (1.000000000000000  -1.935879266639808   0.966119353727240)
    (1.000000000000000  -1.950615919424975   0.992549033489475)
    (1.000000000000000  -1.976701855568473   0.983048428939803)
    (1.000000000000000  -1.987740758508910   0.997684424001141)
    (1.000000000000000  -1.988950805821866   0.994637562486569)
    (1.000000000000000  -1.996665652369405   0.997830827898270)
    (1.000000000000000  -1.999265596147660   0.999560406040493)))

(defparameter Am40
  '((1.000000000000000  -0.854293170304978   0.834113363557875)
    (1.000000000000000  -1.584038298966834   0.924666769584735)
    (1.000000000000000  -1.653299094095148   0.832155923674416)
    (1.000000000000000  -1.740387213850991   0.858490472708578)
    (1.000000000000000  -1.863832376300776   0.987870389102513)
    (1.000000000000000  -1.902148461381671   0.986571917439717)
    (1.000000000000000  -1.906413136873490   0.969593296593620)
    (1.000000000000000  -1.949271800838202   0.991268116300797)
    (1.000000000000000  -1.955371580653652   0.988192481643688)
    (1.000000000000000  -1.957347217853078   0.983969266786504)
    (1.000000000000000  -1.973021262822184   0.993836193849310)
    (1.000000000000000  -1.986183045309521   0.993472278212335)
    (1.000000000000000  -1.987419119641830   0.997392980366081)
    (1.000000000000000  -1.989808581117502   0.994775697438767)
    (1.000000000000000  -1.990933035434671   0.996601732337383)
    (1.000000000000000  -1.995877846747751   0.998267477877428)
    (1.000000000000000  -1.996458793957499   0.998076199761343)
    (1.000000000000000  -1.996868894843101   0.998036189764835)
    (1.000000000000000  -1.997761424702670   0.997779351028180)
    (1.000000000000000  -1.999196279926850   0.999493428182445)))


(defparameter fir26 0.147639332449325)

(defparameter fir40 0.147245485891271)


(defparameter Bm112
  '((0.012482956044353                   0  -0.012482956044353)
    (0.029770473756409                   0  -0.029770473756409)
    (0.007240829332939                   0  -0.007240829332939)
    (0.008271223397956                   0  -0.008271223397956)
    (0.007389435085298                   0  -0.007389435085298)
    (0.018231516362495                   0  -0.018231516362495)
    (0.002696077696310                   0  -0.002696077696310)
    (0.000708336719643                   0  -0.000708336719643)
    (0.002273485982910                   0  -0.002273485982910)
    (0.004013860213163                   0  -0.004013860213163)
    (0.017741415875566                   0  -0.017741415875566)
    (0.001072451714069                   0  -0.001072451714069)
    (0.001892958090247                   0  -0.001892958090247)
    (0.003494627545380                   0  -0.003494627545380)
    (0.010177631747331                   0  -0.010177631747331)
    (0.000442722325466                   0  -0.000442722325466)
    (0.003304352287369                   0  -0.003304352287369)
    (0.000699891687330                   0  -0.000699891687330)
    (0.001066806965416                   0  -0.001066806965416)
    (0.001558559160293                   0  -0.001558559160293)
    (0.000208806593280                   0  -0.000208806593280)
    (0.001066518578792                   0  -0.001066518578792)
    (0.000537519902955                   0  -0.000537519902955)
    (0.000942050567192                   0  -0.000942050567192)
    (0.000804956027721                   0  -0.000804956027721)
    (0.000960790215587                   0  -0.000960790215587)
    (0.000526989878527                   0  -0.000526989878527)
    (0.000272263459870                   0  -0.000272263459870)
    (0.000466749580790                   0  -0.000466749580790)
    (0.000129335354543                   0  -0.000129335354543)
    (0.000213578570335                   0  -0.000213578570335)
    (0.000228311346738                   0  -0.000228311346738)
    (0.000100226410734                   0  -0.000100226410734)
    (0.000700675720640                   0  -0.000700675720640)
    (0.000121325408470                   0  -0.000121325408470)
    (0.000198508436119                   0  -0.000198508436119)
    (0.002416155870548                   0  -0.002416155870548)
    (0.000203578733290                   0  -0.000203578733290)
    (0.000710222568735                   0  -0.000710222568735)
    (0.000305090476309                   0  -0.000305090476309)
    (0.000062382932564                   0  -0.000062382932564)
    (0.000993832303633                   0  -0.000993832303633)
    (0.000092817182069                   0  -0.000092817182069)
    (0.000382081861712                   0  -0.000382081861712)
    (0.000706977888285                   0  -0.000706977888285)
    (0.000060328747390                   0  -0.000060328747390)
    (0.000158505470127                   0  -0.000158505470127)
    (0.000354896383518                   0  -0.000354896383518)
    (0.000175258124741                   0  -0.000175258124741)
    (0.000259261617693                   0  -0.000259261617693)
    (0.007575190685975                   0  -0.007575190685975)
    (0.000054421164853                   0  -0.000054421164853)
    (0.000098252492846                   0  -0.000098252492846)
    (0.000201841605701                   0  -0.000201841605701)
    (0.000057715402014                   0  -0.000057715402014)
    (0.000512562926160                   0  -0.000512562926160)))


(defparameter Am112
  '((1.000000000000000   1.839621226613415   0.941340405805295)
    (1.000000000000000   1.131916464451955   0.603770024933927)
    (1.000000000000000   0.563478502344527   0.921985009154081)
    (1.000000000000000  -0.039519209761629   0.883054105969050)
    (1.000000000000000  -0.598326727310177   0.815574707402215)
    (1.000000000000000  -0.935987374032059   0.756778314161494)
    (1.000000000000000  -1.178525716941820   0.891026757463853)
    (1.000000000000000  -1.375798952292488   0.932145894161008)
    (1.000000000000000  -1.520013963851431   0.981385412360254)
    (1.000000000000000  -1.585002451388119   0.968996940002493)
    (1.000000000000000  -1.617919002043052   0.863930893785079)
    (1.000000000000000  -1.667029142323595   0.982669405425843)
    (1.000000000000000  -1.755266914890860   0.971850883045832)
    (1.000000000000000  -1.778472612952917   0.942343322644544)
    (1.000000000000000  -1.843522362980017   0.895103328425639)
    (1.000000000000000  -1.843750944952324   0.990865513834926)
    (1.000000000000000  -1.857914043171184   0.985083551849935)
    (1.000000000000000  -1.884571702549344   0.987474430766460)
    (1.000000000000000  -1.896016565419128   0.988282015084160)
    (1.000000000000000  -1.916373888095957   0.982764026344213)
    (1.000000000000000  -1.924888894667358   0.997560615626403)
    (1.000000000000000  -1.942702664837159   0.963351933003587)
    (1.000000000000000  -1.951709387926009   0.995761054908649)
    (1.000000000000000  -1.953178606317407   0.995349448257748)
    (1.000000000000000  -1.955175385707397   0.991720276583032)
    (1.000000000000000  -1.961751151484843   0.995131626285840)
    (1.000000000000000  -1.966093290752617   0.997164390744570)
    (1.000000000000000  -1.968377719159133   0.994467357092412)
    (1.000000000000000  -1.969265488285272   0.997525719245822)
    (1.000000000000000  -1.975888738861436   0.997978900633876)
    (1.000000000000000  -1.976165515248931   0.996496168461650)
    (1.000000000000000  -1.977697976946588   0.993916812833007)
    (1.000000000000000  -1.979767576228704   0.997649875267180)
    (1.000000000000000  -1.983338602760922   0.989427816153059)
    (1.000000000000000  -1.985583227967072   0.997512521992806)
    (1.000000000000000  -1.985803211198104   0.998575125259372)
    (1.000000000000000  -1.987169265372768   0.997143812228955)
    (1.000000000000000  -1.988856542458056   0.997943769804256)
    (1.000000000000000  -1.990023940797042   0.997244403039078)
    (1.000000000000000  -1.990423139095493   0.998125435900274)
    (1.000000000000000  -1.990733930684281   0.995197362184954)
    (1.000000000000000  -1.991912659524883   0.997695660253024)
    (1.000000000000000  -1.993128710037667   0.996166566564586)
    (1.000000000000000  -1.993658286438107   0.998659246059184)
    (1.000000000000000  -1.993980286853049   0.995070158211699)
    (1.000000000000000  -1.994225653410565   0.996237268907960)
    (1.000000000000000  -1.996097371408353   0.996881497934749)
    (1.000000000000000  -1.996109704325250   0.998526710368433)
    (1.000000000000000  -1.996287572819662   0.996382702185403)
    (1.000000000000000  -1.996676948950343   0.998089031002677)
    (1.000000000000000  -1.996704309942157   0.997881417579467)
    (1.000000000000000  -1.996730251088393   0.997222239254618)
    (1.000000000000000  -1.997990075162579   0.999762589510094)
    (1.000000000000000  -1.998732601729373   0.998753186365595)
    (1.000000000000000  -1.998779720278275   0.998781456508744)
    (1.000000000000000  -1.999168682616983   0.999464299314400)))




(defun y2*26 ()
  (.Y2* :b0 (mapcar #'(lambda (x) (/ x 100.0)) (mapcar #'first Bm26))
        :b2 (mapcar #'(lambda (x) (/ x 100.0)) (mapcar #'third Bm26))
        :a1 (mapcar #'second Am26)
        :a2 (mapcar #'third Am26)
        :fir (/ fir26 100.0)))

(defun y2*40 ()
  (.Y2* :b0 (mapcar #'(lambda (x) (/ x 100.0)) (mapcar #'first Bm40))
        :b2 (mapcar #'(lambda (x) (/ x 100.0)) (mapcar #'third Bm40))
        :a1 (mapcar #'second Am40)
        :a2 (mapcar #'third Am40)
        :fir (/ fir40 100.0)))

(defun y2*112 ()
  (.Y2* :b0 (mapcar #'(lambda (x) (/ x 100.0)) (mapcar #'first Bm112))
        :b2 (mapcar #'(lambda (x) (/ x 100.0)) (mapcar #'third Bm112))
        :a1 (mapcar #'second Am112)
        :a2 (mapcar #'third Am112)
        :fir 0.0))

; (mapcar #'second AM26)
; (defparameter y2*26 (y2*26))
; (length Bm26)


;;; Radiation response (0.2 sec)
;;; ----------------------------

(defparameter *radresp* 
  '(9.0332031e-03  -1.0971069e-01  -1.5176392e-01  -1.2619019e-01  -5.2917480e-02   8.2519531e-02  -6.0028076e-02  -9.7442627e-02   6.2561035e-03   3.5095215e-03  -3.9550781e-02   1.0787964e-01   6.1157227e-02  -5.1513672e-02  -7.2143555e-02  -4.5227051e-02  -2.7465820e-02  -8.9721680e-03   1.1019897e-01   9.1552734e-03  -3.2287598e-02  -2.2155762e-02   4.3029785e-02   1.3217163e-01   7.4768066e-02  -5.1147461e-02  -4.1229248e-02   9.1918945e-02   8.6425781e-02   1.4617920e-02  -6.4910889e-02   1.8585205e-02   4.7668457e-02  -1.0174561e-01   6.1340332e-02   1.0659790e-01   1.4038086e-03   1.7028809e-01   1.1511230e-01  -4.1839600e-02   4.0191650e-02  -2.2399902e-02  -6.4056396e-02  -2.5878906e-02  -3.3233643e-02   3.3752441e-02  -3.6224365e-02  -3.9031982e-02   4.6722412e-02   7.7880859e-02   5.4321289e-02   3.5552979e-02   5.9539795e-02   3.1433105e-02   4.0405273e-02   1.9165039e-02   9.7747803e-02   1.6937256e-01   5.5999756e-02   7.7819824e-03  -2.9846191e-02  -3.5156250e-02  -5.8288574e-03   5.4016113e-02   5.7098389e-02  -4.8522949e-03   7.5225830e-02   6.7291260e-02  -4.0740967e-02   3.0609131e-02  -1.3977051e-02  -1.1523438e-01  -1.1459351e-01  -7.6904297e-02  -5.5694580e-02   3.6926270e-02   5.8532715e-02   3.0487061e-02   2.5054932e-02  -2.1972656e-03   3.4057617e-02  -7.9345703e-03  -2.2521973e-02  -3.5919189e-02  -1.0250854e-01  -7.7667236e-02  -7.3577881e-02  -1.2847900e-02   6.3720703e-02   5.0811768e-02   4.6997070e-03   7.2326660e-03  -4.5776367e-04  -1.5869141e-03   5.7708740e-02   3.0822754e-02  -3.3996582e-02  -8.3007812e-02  -7.7819824e-03  -2.7648926e-02  -1.3018799e-01  -2.2033691e-02   4.5501709e-02  -1.9531250e-03  -8.5144043e-02  -4.8980713e-02  -1.0772705e-02   1.1749268e-02   4.5043945e-02   1.3153076e-02  -8.7585449e-03   4.1412354e-02   1.1901855e-03  -6.2835693e-02  -7.1075439e-02  -6.2377930e-02  -6.2500000e-02  -7.6202393e-02  -4.2663574e-02  -4.5684814e-02  -7.3852539e-03   1.5411377e-02  -1.0681152e-02  -3.9367676e-03   2.8930664e-02   2.1057129e-02  -2.1362305e-02  -3.8757324e-03   1.4434814e-02   2.1148682e-02  -4.9255371e-02  -4.1381836e-02  -3.2531738e-02  -6.9152832e-02  -4.7180176e-02  -2.1240234e-02  -7.0526123e-02  -7.3059082e-02  -8.7890625e-02  -9.5184326e-02  -3.3508301e-02  -2.7221680e-02  -1.7944336e-02   6.5002441e-03  -9.6435547e-03  -2.0751953e-03  -2.1545410e-02  -1.8310547e-03  -1.8310547e-03  -4.4555664e-03  -5.2764893e-02  -6.2835693e-02  -1.2084961e-02  -1.1413574e-02  -4.1137695e-02   4.5837402e-02   4.6813965e-02   3.8421631e-02   6.2591553e-02   3.6743164e-02   2.8320312e-02  -1.2573242e-02  -2.7496338e-02  -1.2268066e-02  -3.7231445e-03  -3.5003662e-02  -9.4604492e-04   3.9978027e-02   2.6947021e-02   2.3376465e-02   6.4453125e-02   9.3048096e-02   3.5491943e-02   6.6101074e-02   5.2612305e-02   2.1148682e-02   3.4057617e-02   1.1505127e-02   1.2695312e-02  -8.8195801e-03  -3.7597656e-02  -5.1513672e-02  -1.5777588e-02  -1.8890381e-02  -5.4718018e-02  -3.8452148e-02  -2.6855469e-03   2.9541016e-02   2.7221680e-02   6.3293457e-02   2.6062012e-02  -3.3935547e-02   3.6468506e-02   6.6650391e-02   3.6926270e-02   3.8665771e-02   3.4667969e-02  -1.0192871e-02  -9.0332031e-03   2.2155762e-02   5.7159424e-02   4.9468994e-02   2.2033691e-02   1.6632080e-02  -5.3009033e-02  -4.9621582e-02   4.4952393e-02   2.6733398e-02  -4.2053223e-02  -5.3649902e-02   1.3305664e-02   3.0456543e-02  -2.7862549e-02  -1.1169434e-02   4.1198730e-02   6.7047119e-02   3.1250000e-02   2.0172119e-02   1.0675049e-01   8.5357666e-02   1.7913818e-02  -2.5817871e-02  -9.3688965e-03   4.8797607e-02   6.1492920e-02  -2.3590088e-02  -6.0424805e-02   5.0323486e-02   4.8217773e-02  -1.3458252e-02   1.4343262e-03   1.3824463e-02   2.4414062e-03   1.3763428e-02   3.8482666e-02   4.0649414e-02  -2.1179199e-02  -7.4157715e-03   1.0449219e-01   1.0891724e-01   6.7291260e-02   4.7760010e-02   1.5991211e-02   1.1993408e-02   2.2491455e-02   5.2612305e-02   1.1352539e-02  -6.3446045e-02  -1.1322021e-02   6.8908691e-02  -1.3671875e-02  -8.9599609e-02  -2.5817871e-02   5.1116943e-02   2.9266357e-02  -2.5939941e-02  -6.5612793e-02  -4.8614502e-02  -3.8604736e-02  -4.9407959e-02  -8.9111328e-03   6.1065674e-02   7.7301025e-02   2.8808594e-02   2.2369385e-02   3.2287598e-02  -7.6293945e-04  -3.5675049e-02  -3.8024902e-02  -5.0323486e-02  -3.5766602e-02   1.5258789e-02   4.4372559e-02   2.9754639e-02  -6.5307617e-03  -2.6367188e-02  -4.1656494e-02  -5.5145264e-02  -4.9896240e-02  -3.6712646e-02  -1.1383057e-02   3.8513184e-02   2.0904541e-02  -3.7322998e-02  -8.2092285e-03  -2.6855469e-03  -1.8218994e-02  -1.3916016e-02  -2.0050049e-02   1.5563965e-02   3.8299561e-02   3.0364990e-02   1.1260986e-02  -3.6682129e-02  -5.5725098e-02  -3.2318115e-02   8.9721680e-03  -2.5939941e-02  -8.2214355e-02  -6.8359375e-02  -2.0629883e-02  -1.3916016e-02  -3.1768799e-02  -2.3406982e-02  -2.2674561e-02  -1.2420654e-02   1.6113281e-02   3.0364990e-02   1.8646240e-02  -6.6528320e-03  -3.1738281e-03  -1.7028809e-02  -2.4627686e-02  -2.6855469e-02  -5.2185059e-02  -5.0903320e-02  -5.9814453e-03   2.3803711e-03  -1.1749268e-02  -1.8920898e-02  -3.3996582e-02  -5.5694580e-02  -7.3059082e-02  -2.3742676e-02   5.2551270e-02   5.1422119e-02  -3.4179688e-03  -2.7984619e-02   3.3264160e-03   1.0772705e-02  -7.0800781e-03   1.2145996e-02   2.2644043e-02   2.2216797e-02   1.5686035e-02  -6.1340332e-03  -1.7547607e-02  -8.2702637e-03  -6.5917969e-03  -1.5258789e-02  -3.0273438e-02  -4.4403076e-02  -2.0416260e-02   1.9653320e-02   5.1879883e-03  -1.4190674e-02   2.1331787e-02   5.7708740e-02   2.1362305e-02  -2.7801514e-02  -2.4047852e-02  -6.2255859e-03  -1.3275146e-02  -2.3590088e-02  -7.1411133e-03   3.9672852e-04  -2.4932861e-02  -3.5827637e-02  -2.2583008e-03   3.3020020e-02   2.3284912e-02   1.5045166e-02   3.8574219e-02   4.4525146e-02   1.9653320e-02  -8.3007812e-03   3.1738281e-03   1.3183594e-02   1.4953613e-03   3.9978027e-03   1.0955811e-02   8.3618164e-03   1.6204834e-02   3.1005859e-02   5.9082031e-02   6.6558838e-02   3.0395508e-02   2.2338867e-02   3.6499023e-02   1.2634277e-02  -2.0629883e-02  -9.4909668e-03   2.2735596e-02   1.8737793e-02  -6.7138672e-04  -2.5329590e-03   1.3732910e-03  -1.5869141e-03  -5.4016113e-03   1.0375977e-03  -1.1749268e-02  -1.8127441e-02   1.8310547e-03   2.2583008e-03   1.0589600e-02   1.8157959e-02   0.0000000e+00  -1.0070801e-03   1.1535645e-02   6.2866211e-03  -8.3923340e-03   9.1857910e-03   1.8371582e-02   6.7138672e-03   7.1105957e-03   1.5991211e-02   2.2003174e-02   2.3376465e-02   3.5797119e-02   2.0935059e-02   1.8981934e-02   1.4373779e-02  -6.0729980e-03  -7.3547363e-03  -1.3092041e-02  -4.5471191e-03   2.1392822e-02   2.0843506e-02   1.7852783e-02   4.5776367e-03  -2.2766113e-02  -3.1311035e-02  -1.0589600e-02  -2.2583008e-03  -2.7130127e-02  -2.1606445e-02   6.2866211e-03   2.8106689e-02   1.5960693e-02   6.6528320e-03   1.1260986e-02  -5.7983398e-03  -1.8493652e-02  -1.6082764e-02  -1.6998291e-02  -2.0507812e-02  -1.1138916e-02   1.2237549e-02   2.4414062e-03  -1.1749268e-02   1.2634277e-02   2.1575928e-02   1.6021729e-02   7.9956055e-03   7.9650879e-03   7.6293945e-04  -6.3171387e-03  -2.9602051e-03  -1.3122559e-03   9.9792480e-03   1.9165039e-02  -1.4343262e-03  -1.4312744e-02   2.6550293e-03   1.8096924e-02  -2.8076172e-03  -3.2226562e-02  -2.7526855e-02  -1.1413574e-02  -7.3547363e-03  -8.2397461e-04   9.4604492e-04  -2.1270752e-02  -4.5715332e-02  -4.4403076e-02  -1.9165039e-02  -9.1247559e-03  -4.3975830e-02  -6.0943604e-02  -4.1046143e-02  -3.8330078e-02  -1.7364502e-02   1.8707275e-02   1.4587402e-02   7.0190430e-04  -1.3000488e-02  -2.9296875e-02  -3.1982422e-02  -2.1881104e-02  -6.7749023e-03  -9.4299316e-03  -1.3763428e-02  -6.5917969e-03  -1.1322021e-02  -2.2766113e-02  -3.1280518e-02  -3.0639648e-02  -1.1169434e-02  -1.0803223e-02  -1.1566162e-02  -7.8430176e-03  -1.2359619e-02  -3.5400391e-03  -7.3242188e-04  -2.9296875e-03  -2.5939941e-03  -5.0659180e-03  -4.9133301e-03   7.4768066e-03   9.7351074e-03  -2.3498535e-03   2.1667480e-03   3.9978027e-03  -2.2583008e-03  -4.4860840e-03   1.0131836e-02   1.8707275e-02   3.5095215e-03  -1.6815186e-02  -2.2430420e-02  -3.5095215e-03   1.3488770e-02  -6.7138672e-03  -2.2766113e-02  -2.5482178e-02  -3.1158447e-02  -3.4851074e-02  -2.4414062e-02  -2.5329590e-03   2.5939941e-03  -4.3029785e-03  -8.4533691e-03  -4.4555664e-03   3.6010742e-03   1.1749268e-02   1.2603760e-02   2.1057129e-03  -1.5747070e-02  -1.4953613e-02  -8.8806152e-03  -1.2359619e-02  -1.4129639e-02  -1.1169434e-02  -6.5307617e-03  -4.3334961e-03   5.1879883e-04   2.7770996e-03   1.3458252e-02   2.2613525e-02   2.8625488e-02   2.6397705e-02   1.3549805e-02   1.5167236e-02   2.3010254e-02   1.6265869e-02   8.3618164e-03   9.0637207e-03   1.3824463e-02   2.4810791e-02   3.9245605e-02   5.7464600e-02   4.7943115e-02   1.2420654e-02  -9.6740723e-03  -9.5825195e-03   7.1716309e-03   2.3834229e-02   3.0487061e-02   2.9205322e-02   2.6000977e-02   1.9592285e-02   1.2207031e-02   1.0894775e-02   1.4648438e-02   1.5319824e-02   1.4038086e-02   1.9561768e-02   2.9418945e-02   3.2806396e-02   3.7536621e-02   3.9855957e-02   2.0385742e-02   1.3427734e-03  -7.3547363e-03  -5.0964355e-03   1.4648438e-03   4.1809082e-03   1.3214111e-02   2.7191162e-02   3.3111572e-02   2.2094727e-02  -1.3732910e-03  -1.0681152e-02  -1.0589600e-02  -9.8876953e-03  -7.5683594e-03  -1.0375977e-03   4.7302246e-03   8.3312988e-03   1.5808105e-02   2.1179199e-02   2.2613525e-02   2.0416260e-02   1.2542725e-02   5.8898926e-03  -9.7656250e-04  -7.1716309e-03  -7.7209473e-03  -9.2468262e-03  -1.2054443e-02  -1.0833740e-02  -3.0212402e-03   4.6081543e-03   5.4321289e-03   2.2583008e-03  -3.3569336e-04  -1.0375977e-03   1.8310547e-04   4.9133301e-03   7.7514648e-03   3.5095215e-03  -1.1596680e-03  -1.8310547e-04   4.7302246e-03   1.1352539e-02   1.3916016e-02   1.1291504e-02   7.2326660e-03   8.6669922e-03   1.2207031e-02   7.4768066e-03   9.7961426e-03   1.2603760e-02   8.3618164e-03   2.3193359e-03   5.1879883e-03   1.2512207e-02   6.4697266e-03  -7.3242188e-04  -3.0517578e-04   4.5776367e-04   2.1972656e-03   7.2937012e-03   9.0026855e-03   6.7749023e-03   9.7656250e-04  -3.6926270e-03  -7.4768066e-03  -5.0354004e-03  -6.8664551e-03  -1.6296387e-02  -2.5573730e-02  -3.0639648e-02  -2.9754639e-02  -2.7801514e-02  -2.9510498e-02  -3.6163330e-02  -3.5217285e-02  -2.4322510e-02  -1.6876221e-02  -1.3732910e-02  -1.8432617e-02  -2.3437500e-02  -1.5472412e-02  -3.4179688e-03   5.9814453e-03   8.2397461e-03   1.7395020e-03  -4.3945312e-03  -5.3100586e-03   3.9672852e-04   2.4719238e-03  -6.3171387e-03  -1.3183594e-02  -1.3061523e-02  -9.5520020e-03  -1.7120361e-02  -2.3040771e-02  -1.3488770e-02   2.5329590e-03   8.5449219e-03  -4.2724609e-04  -1.0192871e-02  -1.5502930e-02  -1.6540527e-02  -2.0141602e-02  -2.2552490e-02  -1.7517090e-02  -1.2481689e-02  -6.4392090e-03  -2.5634766e-03   1.3732910e-03   2.9907227e-03   3.5095215e-03   8.6059570e-03   1.1291504e-02   4.8828125e-03  -4.2724609e-04  -9.0332031e-03  -2.0385742e-02  -2.3559570e-02  -1.8646240e-02  -1.2512207e-02  -1.2145996e-02  -1.4129639e-02  -1.3580322e-02  -8.3312988e-03  -6.2255859e-03  -4.5471191e-03   1.4648438e-03   7.3242188e-03   9.0332031e-03   8.4533691e-03   3.9672852e-03  -6.4392090e-03  -1.6204834e-02  -1.4404297e-02  -7.1716309e-03  -6.1645508e-03  -1.3275146e-02  -1.8463135e-02  -9.8876953e-03   4.2724609e-04   4.7607422e-03   7.8735352e-03   5.8288574e-03  -1.0681152e-03  -3.6926270e-03  -1.1596680e-03   8.0566406e-03   1.8463135e-02   2.2247314e-02   1.8920898e-02   1.1291504e-02   4.4555664e-03   3.7536621e-03   1.3214111e-02   2.4139404e-02   2.3681641e-02   1.5777588e-02   1.1413574e-02   1.4648438e-02   1.7730713e-02   1.6540527e-02   1.3763428e-02   1.3458252e-02   1.3763428e-02   1.2969971e-02   1.0009766e-02   9.3078613e-03   8.7280273e-03   9.6740723e-03   1.6174316e-02   2.4932861e-02   2.6733398e-02   2.3986816e-02   2.1423340e-02   1.6845703e-02   1.4892578e-02   1.6906738e-02   1.7700195e-02   1.6052246e-02   1.2908936e-02   1.0284424e-02   1.2725830e-02   1.3183594e-02   4.8217773e-03  -7.4462891e-03  -1.3153076e-02  -1.3671875e-02  -1.0253906e-02  -6.1035156e-03   1.2207031e-04   6.3476562e-03   9.6435547e-03   9.1552734e-03   1.0070801e-03  -1.0986328e-02  -2.0446777e-02  -2.3437500e-02  -1.6052246e-02  -4.1503906e-03   2.8076172e-03   4.2724609e-03  -1.8005371e-03  -1.2298584e-02  -1.8127441e-02  -1.5502930e-02  -8.8195801e-03  -5.0354004e-03  -6.5307617e-03  -9.5825195e-03  -1.1596680e-02  -9.2163086e-03  -1.0070801e-03   2.9296875e-03  -5.7983398e-04  -5.2490234e-03  -1.8615723e-03   7.7514648e-03   1.2207031e-02   1.2603760e-02   9.1247559e-03   2.4719238e-03  -3.6315918e-03  -6.7443848e-03  -3.9672852e-03   2.8991699e-03   7.3242188e-03   9.6130371e-03   7.7819824e-03  -8.2397461e-04  -7.7819824e-03  -1.3153076e-02  -1.5686035e-02  -1.3366699e-02  -9.0026855e-03  -6.8359375e-03  -7.4462891e-03  -8.6669922e-03  -7.3852539e-03  -3.1433105e-03   4.9743652e-03   9.4299316e-03   8.5144043e-03   5.5847168e-03  -1.8615723e-03  -8.5754395e-03  -1.3824463e-02  -1.3641357e-02  -1.3153076e-02  -1.2603760e-02  -1.3122559e-02  -1.3793945e-02  -1.4312744e-02  -1.6235352e-02  -1.7242432e-02  -1.5350342e-02  -1.2634277e-02  -1.1199951e-02  -1.0131836e-02  -1.0528564e-02  -1.4343262e-02  -1.2329102e-02  -7.6904297e-03  -2.1667480e-03   2.0446777e-03   4.1809082e-03   1.9531250e-03  -3.2958984e-03  -7.8125000e-03  -8.2702637e-03  -2.7465820e-03  -1.8615723e-03  -6.3781738e-03  -1.4038086e-02  -2.0233154e-02  -2.2247314e-02  -1.6540527e-02  -1.1505127e-02  -8.9111328e-03  -6.6833496e-03  -5.0354004e-03  -5.2795410e-03  -6.0424805e-03  -5.4626465e-03  -1.5563965e-03   2.1972656e-03   3.0517578e-03   1.0681152e-03  -1.5258789e-04  -2.4414062e-04  -6.4086914e-04  -1.4038086e-03  -4.6691895e-03  -6.6833496e-03  -7.0190430e-03  -6.0424805e-03  -5.0659180e-03  -5.2490234e-03  -6.3476562e-03  -2.8686523e-03   3.4179688e-03   6.6223145e-03   7.5073242e-03   9.4604492e-03   9.3078613e-03   3.6010742e-03  -4.7302246e-03  -1.0742188e-02  -1.2969971e-02  -1.0925293e-02  -4.7302246e-03   2.3498535e-03   7.4157715e-03   9.5214844e-03   9.5825195e-03   6.7749023e-03   3.4484863e-03   2.2277832e-03   2.4108887e-03   1.9836426e-03  -7.9345703e-04  -6.0424805e-03  -5.0048828e-03   1.1291504e-03   5.7678223e-03   5.6457520e-03   6.1340332e-03   1.0559082e-02   1.5014648e-02   1.3946533e-02   1.4404297e-02   1.3610840e-02   5.7678223e-03   5.1879883e-03   6.9274902e-03   1.1016846e-02   1.0833740e-02   7.0800781e-03   9.1247559e-03   6.0424805e-03   9.1552734e-04   4.3029785e-03   1.0955811e-02   9.7656250e-03   7.2937012e-03   1.3793945e-02   2.1209717e-02   2.1484375e-02   1.9470215e-02   1.7730713e-02   1.4587402e-02   9.1247559e-03   6.1035156e-03   9.9792480e-03   1.3824463e-02   1.4373779e-02   1.3153076e-02   1.2237549e-02   1.2359619e-02   1.3854980e-02   1.5045166e-02   1.5655518e-02   1.5106201e-02   9.7656250e-03   7.2631836e-03   6.1950684e-03   3.8452148e-03   6.4086914e-04   2.7465820e-03   5.2490234e-03  -2.7465820e-04  -3.4790039e-03  -4.0283203e-03  -2.1972656e-03  -7.3242188e-04   3.1433105e-03   5.9509277e-03   5.4321289e-03   4.4555664e-03   3.2958984e-03   6.4697266e-03   7.9345703e-03   6.5917969e-03   6.4086914e-03   5.1269531e-03   6.7138672e-04  -1.4038086e-03   1.4648438e-03   2.1667480e-03   2.1667480e-03   3.3264160e-03   5.2795410e-03   8.3007812e-03   1.0528564e-02   8.5754395e-03   4.7607422e-03   3.0517578e-03   3.0822754e-03   5.9509277e-03   9.5520020e-03   7.7819824e-03   3.1127930e-03  -2.6855469e-03  -4.6997070e-03  -4.5471191e-03  -5.5236816e-03  -3.9978027e-03  -2.9296875e-03  -3.6315918e-03  -3.5400391e-03  -8.5449219e-04  -1.2207031e-03  -2.1362305e-03  -1.5869141e-03  -8.8500977e-04  -4.5471191e-03  -8.2702637e-03  -9.2773438e-03  -1.0223389e-02  -9.6740723e-03  -7.2631836e-03  -5.9509277e-03  -5.4931641e-03  -4.2419434e-03  -1.8005371e-03   1.0681152e-03   2.9602051e-03   3.6926270e-03   4.6691895e-03   4.3029785e-03   2.6550293e-03  -3.9672852e-04  -2.7160645e-03  -5.3405762e-03  -6.6223145e-03  -8.4838867e-03  -8.8806152e-03  -7.2937012e-03  -4.7912598e-03  -3.5705566e-03  -5.3405762e-03  -8.5144043e-03  -1.0498047e-02  -1.1047363e-02  -8.9416504e-03  -6.8969727e-03  -5.5236816e-03  -5.5541992e-03  -6.2255859e-03  -5.8288574e-03  -4.9743652e-03  -6.1035156e-03  -8.9721680e-03  -1.2969971e-02  -1.7456055e-02  -2.0446777e-02  -1.8127441e-02  -1.3031006e-02  -7.5988770e-03  -3.5400391e-03  -3.6010742e-03  -5.0354004e-03  -6.6833496e-03  -9.0332031e-03  -9.3688965e-03  -7.6904297e-03  -4.5471191e-03  -3.6926270e-03  -3.3874512e-03  -3.6010742e-03  -3.3874512e-03  -3.3264160e-03  -2.8381348e-03  -1.2207031e-03   3.0517578e-05   6.7138672e-04   3.2348633e-03   4.2724609e-03   1.7700195e-03   4.5776367e-04  -1.2817383e-03  -4.1503906e-03  -9.0332031e-03  -8.4533691e-03  -4.6691895e-03  -2.9296875e-03   7.3242188e-04   6.1645508e-03   1.0986328e-02   8.8806152e-03   3.0212402e-03   6.4086914e-04  -5.1879883e-04  -2.1667480e-03  -1.6479492e-03   3.5400391e-03   7.5073242e-03   8.1176758e-03   7.5683594e-03   4.9133301e-03   8.5449219e-04  -3.5095215e-03  -4.6691895e-03  -1.5869141e-03   7.3242188e-04   1.7089844e-03   2.2888184e-03   4.2724609e-03   6.1950684e-03   5.8593750e-03   4.5166016e-03   4.4555664e-03   2.6550293e-03   1.0681152e-03   3.4179688e-03   6.5612793e-03   7.2326660e-03   8.8500977e-03   1.1657715e-02   1.1108398e-02   5.7067871e-03   1.3427734e-03  -1.5563965e-03  -3.4484863e-03  -5.8288574e-03  -5.7373047e-03  -4.3334961e-03  -1.8920898e-03  -1.8310547e-04   2.6245117e-03   3.5705566e-03   1.6784668e-03  -2.4414062e-04  -3.3569336e-04  -1.4038086e-03  -1.9226074e-03  -2.6245117e-03  -2.5024414e-03  -9.1552734e-04   0.0000000e+00   1.8310547e-04   3.0822754e-03   4.2724609e-03   4.4555664e-03   5.9204102e-03   7.1105957e-03   7.5988770e-03   7.8430176e-03   8.3007812e-03   1.0345459e-02   1.1840820e-02   1.1199951e-02   1.0192871e-02   8.6364746e-03   6.4392090e-03   5.6152344e-03   7.8125000e-03   8.6669922e-03   7.1716309e-03   5.4321289e-03   4.7912598e-03   3.6315918e-03   2.5634766e-03   2.2583008e-03   1.4953613e-03   2.2888184e-03   3.0212402e-03   1.5869141e-03   7.3242188e-04  -6.7138672e-04  -1.1291504e-03  -4.2724609e-04   9.1552734e-05  -4.2724609e-04  -1.4648438e-03  -3.6315918e-03  -3.9367676e-03  -6.0119629e-03  -6.3781738e-03  -6.3476562e-03  -5.3405762e-03  -5.9814453e-03  -7.3852539e-03  -8.2092285e-03  -7.9956055e-03  -5.9814453e-03  -3.6010742e-03  -1.9836426e-03  -2.2583008e-03  -3.3569336e-03  -5.1574707e-03  -9.0637207e-03  -1.1596680e-02  -1.3000488e-02  -1.2207031e-02  -1.0406494e-02  -8.9111328e-03  -7.9650879e-03  -7.4768066e-03  -7.2937012e-03  -6.8664551e-03  -6.4086914e-03  -6.5612793e-03  -5.9204102e-03  -4.9743652e-03  -4.9743652e-03  -4.2419434e-03  -1.0986328e-03   2.5939941e-03   2.9296875e-03   7.9345703e-04  -1.4953613e-03  -2.3498535e-03  -3.4179688e-03  -4.0893555e-03  -5.0659180e-03  -4.6997070e-03  -6.1950684e-03  -5.8898926e-03  -4.7302246e-03  -2.3803711e-03  -1.7700195e-03  -2.2888184e-03  -3.6010742e-03  -5.6457520e-03  -8.3007812e-03  -1.0925293e-02  -1.1779785e-02  -1.1566162e-02  -8.9416504e-03  -7.5988770e-03  -6.5307617e-03  -7.3852539e-03  -7.6904297e-03  -6.9274902e-03  -5.4321289e-03  -4.3945312e-03  -1.8310547e-03  -1.2512207e-03  -2.1667480e-03  -3.9062500e-03  -5.3100586e-03  -5.6457520e-03  -6.3171387e-03  -6.4697266e-03  -5.1574707e-03  -4.5471191e-03  -4.4250488e-03  -3.7231445e-03  -3.3264160e-03  -1.5563965e-03   1.0375977e-03   3.3569336e-03   5.7678223e-03   6.0119629e-03   4.3334961e-03   2.5634766e-03   1.5258789e-03   9.4604492e-04  -9.1552734e-05  -1.3122559e-03  -1.2207031e-03  -7.3242188e-04  -1.1291504e-03   6.7138672e-04   3.1738281e-03   4.7912598e-03   5.6457520e-03   5.4016113e-03   4.3640137e-03   3.9367676e-03   4.8217773e-03   6.5917969e-03   5.8898926e-03   4.9133301e-03   3.4179688e-03   2.4414062e-03   1.7089844e-03   3.2958984e-03   5.7678223e-03   8.3618164e-03   9.6130371e-03   8.9416504e-03   8.0871582e-03   6.6833496e-03   4.8217773e-03   4.1198730e-03   4.6081543e-03   4.7912598e-03   5.1269531e-03   5.8898926e-03   7.0190430e-03   7.4157715e-03   6.6223145e-03   5.4321289e-03   3.2348633e-03   9.7656250e-04   2.1362305e-04   2.7465820e-04   2.4414062e-03   4.2114258e-03   4.9133301e-03   4.5776367e-03   2.7770996e-03   6.7138672e-04  -3.0517578e-05   1.0070801e-03   2.3803711e-03   3.2958984e-03   3.2348633e-03   2.8686523e-03   3.0517578e-03   2.7160645e-03   1.9226074e-03   3.5705566e-03   5.4626465e-03   7.1716309e-03   8.3618164e-03   7.8430176e-03   6.6833496e-03   5.2490234e-03   6.1950684e-03   8.0871582e-03   1.0131836e-02   1.0498047e-02   1.0711670e-02   1.0742188e-02   1.0223389e-02   9.5825195e-03   1.0437012e-02   1.1138916e-02   1.1352539e-02   1.0406494e-02   8.5144043e-03   7.3242188e-03   7.2021484e-03   7.7209473e-03   7.9040527e-03   7.9345703e-03   7.5378418e-03   6.6528320e-03   4.5776367e-03   3.4790039e-03   2.7465820e-03   3.3264160e-03   3.2958984e-03   2.5329590e-03   5.1879883e-04   0.0000000e+00   1.2207031e-04   4.8828125e-04   7.0190430e-04   7.3242188e-04   8.8500977e-04   2.1362305e-04  -1.0681152e-03  -2.4108887e-03  -1.3732910e-03  -1.3732910e-03  -7.3242188e-04  -4.8828125e-04   3.3569336e-04  -3.3569336e-04  -1.0986328e-03  -1.2817383e-03  -1.1901855e-03  -1.9531250e-03  -2.7465820e-03  -3.6926270e-03  -4.0283203e-03  -4.3640137e-03  -4.5471191e-03  -4.9133301e-03  -4.6691895e-03  -4.3640137e-03  -3.6621094e-03  -2.5329590e-03  -2.5024414e-03  -2.6245117e-03  -3.8146973e-03  -4.7912598e-03  -5.9204102e-03  -6.4392090e-03  -6.6223145e-03  -6.1035156e-03  -4.9438477e-03  -5.4931641e-03  -4.8522949e-03  -4.1809082e-03  -3.2043457e-03  -1.7089844e-03  -1.9531250e-03  -1.5563965e-03  -1.4953613e-03  -2.3193359e-03  -3.0517578e-03  -4.6997070e-03  -5.9814453e-03  -7.4462891e-03  -6.6833496e-03  -5.9204102e-03  -4.4250488e-03  -3.2043457e-03  -2.4108887e-03  -3.2653809e-03  -3.3264160e-03  -3.6621094e-03  -3.0822754e-03  -1.8920898e-03  -1.3122559e-03  -5.4931641e-04  -3.0517578e-05   5.7983398e-04  -9.1552734e-04  -1.1901855e-03  -3.2958984e-03  -4.7912598e-03  -5.7373047e-03  -6.6528320e-03  -6.1035156e-03  -5.0354004e-03  -2.7160645e-03  -1.1596680e-03   1.8310547e-04   1.0681152e-03   1.4953613e-03   1.1901855e-03   1.4343262e-03  -2.1362305e-04  -1.8310547e-03  -4.1198730e-03  -6.8664551e-03  -8.4533691e-03  -8.6059570e-03  -7.0800781e-03  -4.9743652e-03  -3.8757324e-03  -2.4108887e-03  -2.1667480e-03  -1.2512207e-03  -6.4086914e-04   5.1879883e-04  -2.1362305e-04  -5.1879883e-04  -1.0070801e-03  -1.4038086e-03  -1.0986328e-03  -8.5449219e-04  -1.2207031e-03  -9.1552734e-04  -7.9345703e-04  -7.0190430e-04  -4.2724609e-04   6.4086914e-04   6.7138672e-04   1.6174316e-03   1.9226074e-03   2.9602051e-03   2.7465820e-03   2.4719238e-03   2.2277832e-03   8.2397461e-04   4.5776367e-04   3.0517578e-05   3.3569336e-04   7.3242188e-04   1.1901855e-03   5.1879883e-04   6.1035156e-04  -3.3569336e-04  -5.7983398e-04  -4.2724609e-04  -1.2207031e-04   8.2397461e-04   4.8828125e-04   7.0190430e-04   2.4414062e-04  -1.5258789e-04   3.9672852e-04   1.0681152e-03   2.1057129e-03   2.6855469e-03   2.8686523e-03   3.1738281e-03   3.4790039e-03   3.5095215e-03   3.9367676e-03   5.0354004e-03   4.8828125e-03   5.0354004e-03   4.3640137e-03   4.1503906e-03   4.1809082e-03   3.7231445e-03   2.5024414e-03   2.3193359e-03   1.6174316e-03   1.7395020e-03   1.6784668e-03   2.3498535e-03   2.8686523e-03   3.2043457e-03   4.0893555e-03   4.7302246e-03   4.3640137e-03   4.3640137e-03   3.5705566e-03   2.9602051e-03   2.6855469e-03   2.2888184e-03   2.6550293e-03   2.6245117e-03   2.1057129e-03   1.6174316e-03   1.3427734e-03   3.6621094e-04   3.9672852e-04  -1.5258789e-04   1.8310547e-04  -9.1552734e-05  -4.2724609e-04  -2.7465820e-04  -1.0070801e-03  -1.1596680e-03  -4.8828125e-04  -7.6293945e-04  -2.1362305e-04  -2.4414062e-04  -7.3242188e-04  -3.3569336e-04  -2.1362305e-04  -1.5258789e-04   3.0517578e-05   5.1879883e-04   4.5776367e-04  -9.1552734e-05   1.8310547e-04   3.0517578e-04   6.7138672e-04   7.0190430e-04  -6.1035156e-05  -5.7983398e-04  -2.5329590e-03  -3.9978027e-03  -4.5776367e-03  -5.1269531e-03  -4.7912598e-03  -4.3334961e-03  -3.4484863e-03  -3.1738281e-03  -3.1433105e-03  -3.8757324e-03  -5.1879883e-03  -5.6457520e-03  -7.0190430e-03  -7.2937012e-03  -7.1105957e-03  -7.1105957e-03  -7.3852539e-03  -7.6599121e-03  -7.3547363e-03  -7.2326660e-03  -8.4533691e-03  -7.6293945e-03  -8.2397461e-03  -7.9956055e-03  -7.4157715e-03  -6.6528320e-03  -5.4321289e-03  -4.4860840e-03  -3.2653809e-03  -3.4790039e-03  -3.2653809e-03  -3.7231445e-03  -3.6621094e-03  -3.6315918e-03  -2.4108887e-03  -2.0751953e-03  -1.5563965e-03  -1.6784668e-03  -1.8005371e-03  -2.0446777e-03  -1.6479492e-03  -1.6784668e-03  -3.6621094e-04   2.7465820e-04   1.3427734e-03   1.6479492e-03   1.1901855e-03   5.1879883e-04  -6.1035156e-04  -2.0446777e-03  -2.4719238e-03  -2.6245117e-03  -2.1667480e-03  -1.8615723e-03  -7.0190430e-04  -3.6621094e-04   3.6621094e-04   2.1362305e-04  -6.1035156e-05  -1.4343262e-03  -2.3193359e-03  -2.9602051e-03  -3.3264160e-03  -3.3874512e-03  -3.0212402e-03  -2.3498535e-03  -1.6784668e-03  -2.0141602e-03  -2.0141602e-03  -2.6245117e-03  -3.3874512e-03  -3.3874512e-03  -3.4484863e-03  -3.1127930e-03  -2.1667480e-03  -1.2207031e-03  -7.9345703e-04  -7.3242188e-04  -9.1552734e-05  -6.1035156e-05  -1.5258789e-04   2.4414062e-04   6.7138672e-04   1.1596680e-03   1.2817383e-03   1.8920898e-03   2.1057129e-03   2.3803711e-03   2.6245117e-03   2.2888184e-03   2.4414062e-03   2.1972656e-03   2.7770996e-03   2.6855469e-03   3.6926270e-03   4.3334961e-03   5.6457520e-03   6.8054199e-03   7.2326660e-03   7.5988770e-03   6.6528320e-03   6.0119629e-03   5.2490234e-03   5.0048828e-03   4.4555664e-03   4.6997070e-03   4.3334961e-03   5.1269531e-03   5.1574707e-03   5.3100586e-03   5.7678223e-03   6.1340332e-03   6.2866211e-03   7.2021484e-03   6.9885254e-03   7.2631836e-03   7.1105957e-03   6.5002441e-03   6.7138672e-03   6.9580078e-03   7.0800781e-03   6.9580078e-03   6.3476562e-03   6.3171387e-03   6.5612793e-03   6.6528320e-03   6.9885254e-03   7.3852539e-03   6.7138672e-03   6.7138672e-03   5.5541992e-03   5.0659180e-03   4.1503906e-03   3.6621094e-03   2.9602051e-03   2.2888184e-03   2.3498535e-03   1.2817383e-03   1.4038086e-03   6.1035156e-04   4.5776367e-04   5.4931641e-04   5.7983398e-04   7.6293945e-04   1.6174316e-03   2.0141602e-03   2.9602051e-03   3.5095215e-03   2.8686523e-03   2.6245117e-03   2.0446777e-03   1.9226074e-03   2.2277832e-03   2.6550293e-03   3.1738281e-03   3.0822754e-03   2.6550293e-03   2.0751953e-03   1.2512207e-03   8.2397461e-04   5.1879883e-04   9.4604492e-04   1.1291504e-03   2.1362305e-03   2.8381348e-03   3.4790039e-03   3.5705566e-03   4.1198730e-03   3.7841797e-03   3.3264160e-03   2.4108887e-03   1.1291504e-03  -2.1362305e-04  -1.4648438e-03  -2.2888184e-03  -2.4108887e-03  -2.3193359e-03  -1.6174316e-03  -1.1291504e-03  -1.0681152e-03  -1.3427734e-03  -1.4953613e-03  -2.1667480e-03  -2.2888184e-03  -2.4719238e-03  -2.3193359e-03  -2.6550293e-03  -2.9296875e-03  -3.1433105e-03  -3.0822754e-03  -3.0517578e-03  -3.2653809e-03  -3.6621094e-03  -3.9978027e-03  -4.7912598e-03  -4.6997070e-03  -4.8217773e-03  -4.8522949e-03  -4.8828125e-03  -3.9062500e-03  -3.5705566e-03  -3.3264160e-03  -2.6245117e-03  -2.3803711e-03  -2.1972656e-03  -1.9226074e-03  -2.3803711e-03  -2.3498535e-03  -2.8381348e-03  -3.1127930e-03  -2.6855469e-03  -2.2583008e-03  -1.8920898e-03  -1.3427734e-03  -1.2207031e-03  -1.0375977e-03  -4.5776367e-04  -2.4414062e-04   1.5258789e-04   3.3569336e-04   9.1552734e-05  -1.5258789e-04  -1.1596680e-03  -1.3732910e-03  -2.0751953e-03  -2.3803711e-03  -2.7160645e-03  -3.1433105e-03  -2.8076172e-03  -2.8381348e-03  -2.9907227e-03  -2.2583008e-03  -2.3803711e-03  -2.1972656e-03  -2.4108887e-03  -2.1972656e-03  -2.9296875e-03  -2.7465820e-03  -3.2653809e-03  -3.5705566e-03  -3.6926270e-03  -4.3334961e-03  -4.5166016e-03  -4.9743652e-03  -5.0659180e-03  -4.6386719e-03  -3.9367676e-03  -2.8991699e-03  -1.7089844e-03  -1.3427734e-03  -1.5258789e-03  -2.0446777e-03  -2.2583008e-03  -2.8381348e-03  -2.6550293e-03  -2.8076172e-03  -2.1667480e-03  -2.3498535e-03  -2.1667480e-03  -2.0141602e-03  -1.7700195e-03  -1.6479492e-03  -1.0986328e-03  -6.1035156e-04  -6.1035156e-05   2.7465820e-04   4.2724609e-04   1.0070801e-03   1.2512207e-03   1.4648438e-03   1.5258789e-03   1.3732910e-03   7.0190430e-04   8.2397461e-04   6.1035156e-04   9.4604492e-04   9.7656250e-04   1.3427734e-03   1.8005371e-03   2.1972656e-03   2.5939941e-03   2.7160645e-03   3.2043457e-03   3.6010742e-03   3.8757324e-03   3.8452148e-03   3.8146973e-03   3.8146973e-03   3.9062500e-03   3.7841797e-03   4.0893555e-03   3.8757324e-03   4.1809082e-03   3.9978027e-03   4.2114258e-03   4.2114258e-03   4.1503906e-03   3.8146973e-03   3.7231445e-03   3.0212402e-03   2.6855469e-03   2.3193359e-03   1.8615723e-03   1.4953613e-03   1.0375977e-03   7.6293945e-04   8.5449219e-04   9.7656250e-04   1.0681152e-03   1.0986328e-03   5.7983398e-04  -3.0517578e-05   1.8310547e-04  -4.2724609e-04  -1.8310547e-04  -8.2397461e-04  -2.7465820e-04  -7.9345703e-04  -4.2724609e-04  -1.0070801e-03  -7.6293945e-04  -8.2397461e-04  -1.0070801e-03  -1.0986328e-03  -5.4931641e-04  -3.3569336e-04  -3.6621094e-04   9.1552734e-05  -5.7983398e-04   6.1035156e-05  -8.2397461e-04  -6.1035156e-05  -6.1035156e-05  -2.4414062e-04  -5.7983398e-04  -4.2724609e-04  -1.0681152e-03  -1.4038086e-03  -1.7089844e-03  -1.8005371e-03  -1.8310547e-03  -1.6174316e-03  -1.8005371e-03  -1.7395020e-03  -1.8005371e-03  -2.0141602e-03  -1.8005371e-03  -2.5329590e-03  -1.9531250e-03  -2.6550293e-03  -2.6245117e-03  -2.6550293e-03  -2.6550293e-03  -2.6245117e-03  -2.7160645e-03  -2.6550293e-03  -2.1362305e-03  -2.3193359e-03  -1.2817383e-03  -1.7700195e-03  -1.4038086e-03  -1.3427734e-03  -1.7700195e-03  -1.9226074e-03  -2.3498535e-03  -2.3498535e-03  -2.5939941e-03  -2.0751953e-03  -2.0751953e-03  -1.8920898e-03  -1.6479492e-03  -1.6174316e-03  -1.5563965e-03  -1.3122559e-03  -1.3122559e-03  -1.1901855e-03  -1.0375977e-03  -8.8500977e-04  -1.3732910e-03  -1.1901855e-03  -1.4953613e-03  -1.2207031e-03  -1.6479492e-03  -1.4343262e-03  -1.8310547e-03  -1.3732910e-03  -2.0141602e-03  -1.7395020e-03  -2.0446777e-03  -1.6174316e-03  -1.9226074e-03  -1.8310547e-03  -1.8615723e-03  -1.9531250e-03  -2.1972656e-03  -2.3803711e-03  -2.8381348e-03  -2.9602051e-03  -3.4179688e-03  -3.1738281e-03  -3.6926270e-03  -3.5095215e-03  -3.3264160e-03  -2.8076172e-03  -2.2277832e-03  -1.8005371e-03  -1.5563965e-03  -1.6174316e-03  -1.4038086e-03  -2.2583008e-03  -1.9226074e-03  -2.2888184e-03  -2.4719238e-03  -2.5634766e-03  -2.5939941e-03  -2.5329590e-03  -2.8381348e-03  -2.2277832e-03  -1.8310547e-03  -1.6479492e-03  -8.8500977e-04  -5.4931641e-04  -9.1552734e-05   7.6293945e-04   6.7138672e-04   9.4604492e-04   1.4038086e-03   1.1291504e-03   1.5258789e-03   1.2207031e-03   1.1291504e-03   7.6293945e-04   7.0190430e-04   6.1035156e-04   1.0681152e-03   8.5449219e-04   1.2817383e-03   1.4038086e-03   1.9226074e-03   2.1972656e-03   2.1667480e-03   2.3498535e-03   2.5634766e-03   2.5329590e-03   3.0517578e-03   2.7160645e-03   2.8991699e-03   3.2043457e-03   3.0517578e-03   3.6010742e-03   3.3874512e-03   3.6010742e-03   3.7231445e-03   3.2653809e-03   3.0212402e-03   2.8381348e-03   2.8381348e-03   3.0822754e-03   2.8991699e-03   3.1127930e-03   3.3569336e-03   3.4484863e-03   3.6621094e-03   3.9978027e-03   4.1198730e-03   4.2114258e-03   4.5776367e-03   4.4555664e-03   5.1574707e-03   4.9133301e-03   4.9133301e-03   4.8522949e-03   4.4555664e-03   4.4860840e-03   3.7841797e-03   3.5400391e-03   3.3874512e-03   2.9296875e-03   2.6550293e-03   2.8686523e-03   2.6245117e-03   2.7465820e-03   3.1127930e-03   2.5634766e-03   3.1127930e-03   3.0822754e-03   3.0822754e-03   3.4179688e-03   3.2043457e-03   3.5705566e-03   3.2348633e-03   3.0212402e-03   2.9907227e-03   2.6245117e-03   2.5939941e-03   2.7160645e-03   3.1127930e-03   2.8686523e-03   2.8991699e-03   2.6550293e-03   2.6245117e-03   2.4719238e-03   1.8920898e-03   2.1972656e-03   2.1972656e-03   2.0751953e-03   2.1362305e-03   2.1667480e-03   2.1667480e-03   1.9836426e-03   1.8310547e-03   1.6784668e-03   1.3122559e-03   1.2512207e-03   9.1552734e-04   1.0681152e-03   6.1035156e-04   8.2397461e-04   6.4086914e-04   3.0517578e-04  -5.1879883e-04  -6.1035156e-04  -1.4953613e-03  -1.4343262e-03  -1.8310547e-03  -1.7700195e-03  -1.8005371e-03  -2.1667480e-03  -1.4343262e-03  -1.9531250e-03  -1.7089844e-03  -1.5869141e-03  -1.2207031e-03  -1.2207031e-03  -6.7138672e-04  -5.4931641e-04  -7.9345703e-04  -6.1035156e-05  -6.1035156e-04  -5.1879883e-04  -3.3569336e-04  -5.7983398e-04  -1.8310547e-04  -2.1362305e-04  -1.5258789e-04   1.8310547e-04   1.2207031e-04   4.2724609e-04  -1.5258789e-04   2.7465820e-04  -3.3569336e-04  -9.1552734e-05  -4.8828125e-04  -2.1362305e-04  -6.1035156e-04  -2.4414062e-04  -7.3242188e-04  -1.0375977e-03  -1.3122559e-03  -1.9226074e-03  -2.2277832e-03  -2.6550293e-03  -2.8381348e-03  -3.0212402e-03  -2.7160645e-03  -2.9296875e-03  -2.3803711e-03  -2.7465820e-03  -2.7770996e-03  -2.9602051e-03  -3.2348633e-03  -3.4179688e-03  -3.4179688e-03  -3.5705566e-03  -3.1738281e-03  -3.5705566e-03  -2.9602051e-03  -3.1433105e-03  -2.8381348e-03  -2.6855469e-03  -2.4414062e-03  -2.6245117e-03  -2.8076172e-03  -2.3498535e-03  -2.8076172e-03  -2.1057129e-03  -2.3803711e-03  -1.9836426e-03  -2.2888184e-03  -2.0751953e-03  -2.1057129e-03  -2.4414062e-03  -2.1972656e-03  -2.1667480e-03  -2.2277832e-03  -1.9531250e-03  -1.5563965e-03  -1.5869141e-03  -1.6174316e-03  -1.3732910e-03  -1.2512207e-03  -1.3122559e-03  -9.1552734e-04  -9.1552734e-04  -9.7656250e-04  -5.1879883e-04  -4.8828125e-04   6.1035156e-05   0.0000000e+00   4.2724609e-04   4.5776367e-04   4.8828125e-04   7.9345703e-04   7.6293945e-04   7.3242188e-04   9.4604492e-04   7.6293945e-04   9.1552734e-04   1.3122559e-03   1.1901855e-03   1.6479492e-03   1.3122559e-03   1.6784668e-03   1.5258789e-03   1.3732910e-03   1.3732910e-03   1.1596680e-03   1.2207031e-03   1.0986328e-03   1.1291504e-03   1.2207031e-03   6.1035156e-04   1.0681152e-03   6.4086914e-04   9.4604492e-04   5.1879883e-04   8.2397461e-04   1.0375977e-03   3.6621094e-04   5.1879883e-04   2.1362305e-04   2.4414062e-04  -9.1552734e-05   6.1035156e-05   4.2724609e-04  -3.3569336e-04   1.2207031e-04  -3.9672852e-04   1.2207031e-04  -8.8500977e-04   1.5258789e-04  -6.4086914e-04  -3.3569336e-04  -4.8828125e-04  -5.7983398e-04  -3.3569336e-04  -3.3569336e-04  -6.1035156e-04  -4.2724609e-04  -3.9672852e-04  -7.0190430e-04  -3.0517578e-04  -2.7465820e-04  -4.2724609e-04   6.1035156e-05   6.1035156e-04   5.1879883e-04   9.7656250e-04   9.7656250e-04   1.0375977e-03   1.1901855e-03   1.0375977e-03   1.1901855e-03   9.1552734e-04   8.5449219e-04   9.4604492e-04   6.7138672e-04   1.0681152e-03   7.9345703e-04   8.8500977e-04   8.5449219e-04   5.4931641e-04   4.5776367e-04   3.0517578e-04   5.1879883e-04   3.9672852e-04   6.7138672e-04   5.7983398e-04   6.7138672e-04   6.4086914e-04   3.0517578e-04   7.0190430e-04   2.7465820e-04  -3.0517578e-05  -4.5776367e-04  -5.4931641e-04  -8.5449219e-04  -1.1291504e-03  -1.4648438e-03  -1.6479492e-03  -1.6784668e-03  -1.3427734e-03  -1.6174316e-03  -1.7395020e-03  -1.8005371e-03  -1.6479492e-03  -1.6784668e-03  -1.4343262e-03  -1.8615723e-03  -1.1596680e-03  -1.6174316e-03  -1.5563965e-03  -1.5258789e-03  -1.6479492e-03  -1.6174316e-03  -1.5869141e-03  -1.8005371e-03  -1.5869141e-03  -1.7395020e-03  -1.8005371e-03  -1.4038086e-03  -1.7089844e-03  -1.1291504e-03  -1.5869141e-03  -1.2207031e-03  -1.4343262e-03  -1.4038086e-03  -1.2512207e-03  -1.3427734e-03  -1.3427734e-03  -1.3427734e-03  -1.8310547e-03  -1.6174316e-03  -2.1667480e-03  -1.8615723e-03  -2.3803711e-03  -2.2277832e-03  -2.0751953e-03  -2.3803711e-03  -2.3193359e-03  -2.3498535e-03  -2.2888184e-03  -2.8076172e-03  -2.1057129e-03  -2.7465820e-03  -2.0141602e-03  -2.6550293e-03  -2.1362305e-03  -2.3193359e-03  -2.2277832e-03  -2.4414062e-03  -2.2277832e-03  -1.8615723e-03  -2.1972656e-03  -1.3122559e-03  -1.3732910e-03  -1.0375977e-03  -8.5449219e-04  -5.7983398e-04  -2.4414062e-04  -5.1879883e-04  -3.0517578e-04  -3.0517578e-04  -3.0517578e-04  -5.7983398e-04  -3.0517578e-04  -2.7465820e-04   1.2207031e-04  -3.3569336e-04   2.1362305e-04   1.8310547e-04   5.4931641e-04   2.4414062e-04   3.3569336e-04   4.5776367e-04   3.0517578e-04   3.6621094e-04   6.4086914e-04   3.6621094e-04   5.1879883e-04   5.7983398e-04   9.7656250e-04   3.9672852e-04   1.1291504e-03   1.1291504e-03   1.3122559e-03   1.3122559e-03   1.6479492e-03   1.7089844e-03   2.2888184e-03   2.1362305e-03   2.2277832e-03   2.7465820e-03   2.4414062e-03   2.4108887e-03   2.5939941e-03   2.5024414e-03   2.6550293e-03   2.3803711e-03   2.5634766e-03   2.3193359e-03   2.3803711e-03   2.2888184e-03   2.1667480e-03   2.1972656e-03   2.1057129e-03   2.1667480e-03   1.8310547e-03   2.0141602e-03   1.5563965e-03   1.6174316e-03   1.4648438e-03   1.1291504e-03   1.3732910e-03   1.2512207e-03   1.1291504e-03   1.0986328e-03   9.7656250e-04   1.4343262e-03   8.2397461e-04   1.2512207e-03   1.0070801e-03   9.1552734e-04   7.9345703e-04   1.1291504e-03   1.0070801e-03   1.0986328e-03   1.1901855e-03   1.0681152e-03   1.6174316e-03   1.1291504e-03   1.7089844e-03   1.6784668e-03   2.1362305e-03   1.6174316e-03   2.5329590e-03   2.1057129e-03   2.1972656e-03   2.2888184e-03   2.7465820e-03   2.6550293e-03   2.5024414e-03   2.7160645e-03   2.9602051e-03   2.5024414e-03   2.9602051e-03   2.5024414e-03   2.7465820e-03   2.4414062e-03   2.9907227e-03   2.6550293e-03   2.7465820e-03   3.0822754e-03   2.6550293e-03   2.8381348e-03   2.6855469e-03   2.7770996e-03   2.5939941e-03   2.7160645e-03   2.7160645e-03   2.2277832e-03   2.6855469e-03   2.0446777e-03   2.2888184e-03   1.7395020e-03   2.2888184e-03   1.8310547e-03   1.9836426e-03   1.5258789e-03   1.6479492e-03   1.3427734e-03   1.0070801e-03   1.0070801e-03   7.9345703e-04   4.5776367e-04   5.7983398e-04   4.8828125e-04   5.1879883e-04   4.8828125e-04   3.9672852e-04   3.9672852e-04   4.2724609e-04   3.0517578e-05   3.0517578e-04  -3.0517578e-05  -2.1362305e-04  -3.9672852e-04  -5.7983398e-04  -4.8828125e-04  -5.4931641e-04  -9.1552734e-04  -1.0986328e-03  -7.0190430e-04  -1.1291504e-03  -8.5449219e-04  -1.2207031e-03  -1.0986328e-03  -1.2207031e-03  -1.4343262e-03  -1.3732910e-03  -1.5869141e-03  -1.4953613e-03  -1.4953613e-03  -1.9531250e-03  -1.0986328e-03  -1.8920898e-03  -1.5258789e-03  -1.8310547e-03  -1.7395020e-03  -1.9836426e-03  -1.9226074e-03  -1.9836426e-03  -2.2277832e-03  -1.8310547e-03  -2.1667480e-03  -1.6784668e-03  -2.1057129e-03  -1.9531250e-03  -1.9531250e-03  -2.1057129e-03  -2.1667480e-03  -1.9836426e-03  -2.5024414e-03  -2.0751953e-03  -2.4414062e-03  -2.0751953e-03  -2.0446777e-03  -1.9226074e-03  -1.8005371e-03  -1.5563965e-03  -1.7395020e-03  -1.3732910e-03  -1.4038086e-03  -1.3122559e-03  -1.3732910e-03  -1.6784668e-03  -1.3427734e-03  -1.3427734e-03  -1.5869141e-03  -1.2512207e-03  -1.3427734e-03  -9.4604492e-04  -8.2397461e-04  -8.8500977e-04  -9.4604492e-04  -6.4086914e-04  -4.5776367e-04  -2.7465820e-04  -3.6621094e-04  -1.8310547e-04   9.1552734e-05  -1.2207031e-04  -2.7465820e-04   3.0517578e-05  -1.8310547e-04   9.1552734e-05  -5.1879883e-04   1.5258789e-04  -3.9672852e-04   0.0000000e+00   1.5258789e-04   1.5258789e-04   1.2207031e-04   1.2207031e-04   1.8310547e-04   1.5258789e-04   3.3569336e-04   9.1552734e-05   2.7465820e-04   6.1035156e-05   1.8310547e-04   4.5776367e-04   4.5776367e-04  -1.5258789e-04   3.3569336e-04  -9.1552734e-05  -1.2207031e-04   3.0517578e-05  -1.5258789e-04  -1.8310547e-04  -4.2724609e-04  -4.5776367e-04  -3.3569336e-04  -1.0375977e-03  -4.5776367e-04  -1.0070801e-03  -5.7983398e-04  -1.0986328e-03  -6.7138672e-04  -1.0986328e-03  -7.3242188e-04  -1.2512207e-03  -1.2207031e-03  -8.5449219e-04  -9.1552734e-04  -1.1901855e-03  -7.6293945e-04  -8.2397461e-04  -7.6293945e-04  -7.0190430e-04  -5.7983398e-04  -2.1362305e-04  -5.1879883e-04   0.0000000e+00  -2.4414062e-04   3.3569336e-04  -9.1552734e-05   7.0190430e-04   2.4414062e-04   8.5449219e-04   6.1035156e-04   8.8500977e-04   7.9345703e-04   9.1552734e-04   7.6293945e-04   1.1596680e-03   9.7656250e-04   1.1291504e-03   1.1901855e-03   9.7656250e-04   7.3242188e-04   1.0375977e-03   8.5449219e-04   7.3242188e-04   7.6293945e-04   5.4931641e-04   7.6293945e-04   8.5449219e-04   6.4086914e-04   6.1035156e-04   5.1879883e-04   2.7465820e-04   5.1879883e-04   3.3569336e-04   2.4414062e-04   1.5258789e-04   3.9672852e-04   2.4414062e-04   5.1879883e-04   9.1552734e-05   3.9672852e-04   3.6621094e-04   3.0517578e-05   4.5776367e-04  -3.0517578e-05   3.9672852e-04   3.0517578e-05  -1.2207031e-04  -3.0517578e-05  -9.1552734e-05  -4.2724609e-04   6.1035156e-05  -6.7138672e-04  -6.1035156e-05  -4.2724609e-04  -9.1552734e-05  -5.7983398e-04  -3.3569336e-04  -6.7138672e-04  -6.1035156e-04  -1.1596680e-03  -7.6293945e-04  -1.0375977e-03  -9.7656250e-04  -1.2207031e-03  -1.2817383e-03  -1.2207031e-03  -1.4953613e-03  -1.1291504e-03  -1.7395020e-03  -1.6784668e-03  -1.6174316e-03  -1.8310547e-03  -1.9836426e-03  -1.6479492e-03  -1.9531250e-03  -1.6784668e-03  -2.2583008e-03  -1.8005371e-03  -2.1362305e-03  -1.8005371e-03  -1.9836426e-03  -2.0446777e-03  -1.9836426e-03  -2.1362305e-03  -1.8615723e-03  -2.0446777e-03  -1.7700195e-03  -1.8615723e-03  -1.5563965e-03  -1.9226074e-03  -1.3122559e-03  -1.7395020e-03  -1.3427734e-03  -1.9226074e-03  -1.0070801e-03  -1.6784668e-03  -1.2512207e-03  -1.5563965e-03  -8.5449219e-04  -1.3122559e-03  -1.0375977e-03  -9.4604492e-04  -8.8500977e-04  -1.1291504e-03  -6.1035156e-04  -6.7138672e-04  -6.4086914e-04  -4.8828125e-04  -3.9672852e-04  -3.3569336e-04  -4.8828125e-04  -4.2724609e-04  -6.1035156e-05  -1.8310547e-04  -1.8310547e-04  -2.1362305e-04  -3.6621094e-04   2.1362305e-04  -3.0517578e-05   1.5258789e-04   6.1035156e-05   4.5776367e-04   1.5258789e-04   3.9672852e-04   8.2397461e-04   4.2724609e-04   8.5449219e-04   7.6293945e-04   9.7656250e-04   1.0070801e-03   7.9345703e-04   1.1291504e-03   8.5449219e-04   8.5449219e-04   1.0681152e-03   1.1901855e-03   7.6293945e-04   9.1552734e-04   8.5449219e-04   9.1552734e-04   7.9345703e-04   9.7656250e-04   7.6293945e-04   1.1291504e-03   7.0190430e-04   8.2397461e-04   5.7983398e-04   5.4931641e-04   6.1035156e-04   6.7138672e-04   4.2724609e-04   8.2397461e-04   4.8828125e-04   4.2724609e-04   1.0681152e-03   6.7138672e-04   9.1552734e-04   9.4604492e-04   1.1291504e-03   6.4086914e-04   1.4953613e-03   6.7138672e-04   1.5258789e-03   8.8500977e-04   1.2512207e-03   1.2512207e-03   1.3122559e-03   1.1901855e-03   1.4343262e-03   1.6479492e-03   1.2512207e-03   1.6784668e-03   1.6174316e-03   1.7089844e-03   1.8920898e-03   2.1667480e-03   1.8920898e-03   2.2277832e-03   2.3803711e-03   2.3193359e-03   2.2888184e-03   2.4414062e-03   2.4108887e-03   2.8381348e-03   2.5024414e-03   2.7770996e-03   2.6245117e-03   2.6855469e-03   2.4719238e-03   2.5329590e-03   2.3193359e-03   2.4414062e-03   2.5024414e-03   1.8005371e-03   1.9531250e-03   2.0141602e-03   2.1057129e-03   1.8005371e-03   1.7089844e-03   1.6174316e-03   1.4648438e-03   1.4343262e-03   1.6784668e-03   1.4038086e-03   1.1901855e-03   1.2817383e-03   1.2817383e-03   1.0986328e-03   1.3427734e-03   9.7656250e-04   1.4343262e-03   1.3122559e-03   1.0986328e-03   9.1552734e-04   8.5449219e-04   1.0681152e-03   8.5449219e-04   7.0190430e-04   5.4931641e-04   6.4086914e-04   6.4086914e-04   6.1035156e-04   5.1879883e-04   8.8500977e-04   5.1879883e-04   6.4086914e-04   7.6293945e-04   7.0190430e-04   6.7138672e-04   5.4931641e-04   9.4604492e-04   0.0000000e+00   6.4086914e-04   2.7465820e-04   2.1362305e-04   3.3569336e-04   9.1552734e-05  -1.8310547e-04  -1.5258789e-04  -1.8310547e-04  -3.3569336e-04  -4.5776367e-04  -6.7138672e-04  -6.4086914e-04  -1.0375977e-03  -5.1879883e-04  -5.1879883e-04  -9.1552734e-04  -7.6293945e-04  -9.1552734e-04  -7.6293945e-04  -1.1596680e-03  -6.1035156e-04  -1.3732910e-03  -6.1035156e-04  -1.3427734e-03  -9.4604492e-04  -1.2207031e-03  -1.0070801e-03  -1.0986328e-03  -1.2207031e-03  -9.1552734e-04  -1.1596680e-03  -9.7656250e-04  -1.3427734e-03  -7.0190430e-04  -1.1291504e-03  -8.2397461e-04  -9.1552734e-04  -9.4604492e-04  -1.0375977e-03  -1.1596680e-03  -1.0375977e-03  -9.1552734e-04  -1.1901855e-03  -1.0070801e-03  -9.7656250e-04  -9.7656250e-04  -9.4604492e-04  -1.2817383e-03  -7.6293945e-04  -9.1552734e-04  -1.0070801e-03  -1.1291504e-03  -9.4604492e-04  -1.1596680e-03  -9.4604492e-04  -1.1596680e-03  -1.1596680e-03  -9.4604492e-04  -1.1901855e-03  -1.0070801e-03  -9.4604492e-04  -1.0681152e-03  -1.0681152e-03  -7.3242188e-04  -1.0375977e-03  -1.0681152e-03  -7.9345703e-04  -8.5449219e-04  -8.8500977e-04  -1.0375977e-03  -5.4931641e-04  -7.0190430e-04  -8.5449219e-04  -3.9672852e-04  -7.9345703e-04  -5.4931641e-04  -6.7138672e-04  -5.7983398e-04  -5.7983398e-04  -7.0190430e-04  -7.0190430e-04  -7.3242188e-04  -7.0190430e-04  -7.9345703e-04  -8.2397461e-04  -7.9345703e-04  -9.1552734e-04  -6.1035156e-04  -8.8500977e-04  -8.2397461e-04  -1.0681152e-03  -4.2724609e-04  -1.0375977e-03  -6.4086914e-04  -4.8828125e-04  -6.1035156e-04  -4.8828125e-04  -3.9672852e-04  -5.7983398e-04  -3.9672852e-04  -4.2724609e-04  -3.0517578e-05  -1.8310547e-04  -1.2207031e-04   9.1552734e-05   0.0000000e+00  -9.1552734e-05   4.5776367e-04   1.2207031e-04   2.1362305e-04   4.5776367e-04   3.9672852e-04   2.7465820e-04   5.7983398e-04   3.0517578e-04   6.4086914e-04   4.2724609e-04   7.6293945e-04   4.5776367e-04   7.9345703e-04   6.4086914e-04   8.8500977e-04   4.8828125e-04   9.7656250e-04   9.7656250e-04   7.6293945e-04   5.1879883e-04   9.7656250e-04   6.4086914e-04   8.2397461e-04   6.4086914e-04   7.0190430e-04   7.3242188e-04   2.7465820e-04   7.6293945e-04   3.3569336e-04   3.0517578e-04   4.8828125e-04   6.1035156e-05   4.8828125e-04   6.1035156e-05   1.2207031e-04   3.3569336e-04  -6.1035156e-05  -9.1552734e-05   2.7465820e-04  -1.5258789e-04   6.1035156e-05  -3.0517578e-05  -2.1362305e-04   3.0517578e-05  -2.7465820e-04  -3.3569336e-04  -3.0517578e-05  -2.1362305e-04  -4.2724609e-04  -3.9672852e-04  -3.0517578e-04  -3.9672852e-04  -6.1035156e-04  -3.9672852e-04  -7.6293945e-04  -7.6293945e-04  -7.3242188e-04  -8.5449219e-04  -7.0190430e-04  -9.4604492e-04  -8.5449219e-04  -1.2207031e-03  -8.2397461e-04  -9.4604492e-04  -1.0070801e-03  -9.7656250e-04  -8.8500977e-04  -8.5449219e-04  -1.1901855e-03  -6.1035156e-04  -1.0681152e-03  -8.5449219e-04  -1.0375977e-03  -9.4604492e-04  -1.0986328e-03  -9.4604492e-04  -1.2207031e-03  -9.1552734e-04  -1.1596680e-03  -7.6293945e-04  -1.2512207e-03  -9.1552734e-04  -1.2207031e-03  -7.6293945e-04  -1.0986328e-03  -7.0190430e-04  -8.8500977e-04  -7.0190430e-04  -8.2397461e-04  -4.2724609e-04  -6.7138672e-04  -5.1879883e-04  -3.0517578e-04  -5.1879883e-04  -3.0517578e-04  -4.2724609e-04  -2.4414062e-04  -3.3569336e-04  -3.0517578e-04  -2.1362305e-04  -3.3569336e-04  -6.1035156e-05  -1.8310547e-04  -1.5258789e-04  -2.4414062e-04  -3.3569336e-04  -1.8310547e-04  -4.2724609e-04  -9.1552734e-05  -3.3569336e-04  -2.1362305e-04  -4.8828125e-04  -1.5258789e-04  -4.5776367e-04  -3.9672852e-04  -5.4931641e-04  -7.3242188e-04  -4.5776367e-04  -7.0190430e-04  -4.2724609e-04  -6.7138672e-04  -9.7656250e-04  -5.1879883e-04  -7.3242188e-04  -1.0070801e-03  -7.6293945e-04  -9.7656250e-04  -9.4604492e-04  -9.1552734e-04  -6.1035156e-04  -8.8500977e-04  -1.0375977e-03  -8.2397461e-04  -7.0190430e-04  -6.1035156e-04  -8.2397461e-04  -5.4931641e-04  -7.3242188e-04  -2.7465820e-04  -7.3242188e-04  -1.2207031e-04  -6.7138672e-04   3.6621094e-04  -5.7983398e-04   2.1362305e-04  -2.7465820e-04   0.0000000e+00   1.8310547e-04   3.3569336e-04   2.4414062e-04   1.5258789e-04   5.7983398e-04   2.4414062e-04   5.4931641e-04   7.6293945e-04   5.7983398e-04   7.9345703e-04   6.4086914e-04   7.6293945e-04   1.1901855e-03   8.2397461e-04   1.1596680e-03   8.8500977e-04   1.4038086e-03   1.0681152e-03   1.4953613e-03   1.4953613e-03   1.0375977e-03   1.6479492e-03   1.4953613e-03   1.8005371e-03   1.5563965e-03   2.0751953e-03   1.6479492e-03   1.7395020e-03   2.0141602e-03   1.7395020e-03   2.2888184e-03   1.7700195e-03   1.9226074e-03   2.0141602e-03   1.9836426e-03   2.1057129e-03   1.7089844e-03   2.1972656e-03   1.8310547e-03   2.0141602e-03   2.0141602e-03   1.8310547e-03   1.9836426e-03   1.7395020e-03   1.8615723e-03   1.7395020e-03   1.8920898e-03   1.5258789e-03   1.8615723e-03   1.2817383e-03   1.8005371e-03   1.3732910e-03   1.5563965e-03   1.4038086e-03   1.3732910e-03   1.0986328e-03   1.4648438e-03   1.1901855e-03   1.1596680e-03   1.4038086e-03   9.7656250e-04   1.2512207e-03   1.4038086e-03   1.0375977e-03   1.2207031e-03   1.1901855e-03   1.0070801e-03   1.4343262e-03   9.7656250e-04   1.2207031e-03   1.0375977e-03   9.4604492e-04   9.4604492e-04   9.1552734e-04   6.7138672e-04   1.0681152e-03   4.2724609e-04   6.4086914e-04   5.1879883e-04   5.1879883e-04   4.5776367e-04   3.9672852e-04   5.4931641e-04   1.8310547e-04   2.4414062e-04   6.1035156e-05   9.1552734e-05   6.1035156e-05  -6.1035156e-05   1.2207031e-04   6.1035156e-05  -3.3569336e-04  -1.8310547e-04  -3.3569336e-04  -1.5258789e-04  -2.1362305e-04  -4.5776367e-04   1.2207031e-04  -4.5776367e-04  -3.3569336e-04  -9.1552734e-05  -2.1362305e-04  -1.8310547e-04  -1.8310547e-04   6.1035156e-05  -2.4414062e-04  -1.2207031e-04   3.0517578e-05  -2.4414062e-04   2.1362305e-04  -1.8310547e-04   9.1552734e-05   1.5258789e-04   3.0517578e-05  -2.7465820e-04   3.3569336e-04   1.5258789e-04   3.0517578e-05   1.8310547e-04  -1.2207031e-04   6.1035156e-05   6.1035156e-05   1.8310547e-04   6.1035156e-05   6.1035156e-05  -9.1552734e-05   1.8310547e-04  -1.8310547e-04   6.1035156e-05  -3.0517578e-04  -2.7465820e-04  -2.1362305e-04   3.0517578e-05  -5.4931641e-04  -3.3569336e-04  -5.4931641e-04  -3.6621094e-04  -7.6293945e-04  -5.4931641e-04  -6.1035156e-04  -6.4086914e-04  -8.2397461e-04  -7.3242188e-04  -9.4604492e-04  -8.8500977e-04  -9.4604492e-04  -1.2512207e-03  -9.7656250e-04  -1.0681152e-03  -1.3122559e-03  -1.0375977e-03  -1.3427734e-03  -1.0986328e-03  -1.5258789e-03  -1.1596680e-03  -1.4953613e-03  -1.2207031e-03  -1.2817383e-03  -1.6174316e-03  -1.2207031e-03  -1.3122559e-03  -1.1596680e-03  -1.4038086e-03  -1.1596680e-03  -1.4038086e-03  -1.0070801e-03  -1.3732910e-03  -9.1552734e-04  -1.1291504e-03  -7.3242188e-04  -1.4343262e-03  -7.6293945e-04  -9.7656250e-04  -6.7138672e-04  -8.8500977e-04  -7.3242188e-04  -7.9345703e-04  -5.7983398e-04  -3.9672852e-04  -6.7138672e-04  -5.4931641e-04  -3.6621094e-04  -6.1035156e-04   9.1552734e-05  -6.7138672e-04  -3.3569336e-04  -3.3569336e-04  -6.1035156e-05  -3.0517578e-04  -9.1552734e-05   6.1035156e-05  -6.1035156e-05  -1.5258789e-04   6.1035156e-05   1.5258789e-04   0.0000000e+00   1.8310547e-04  -9.1552734e-05   3.0517578e-05   1.5258789e-04   3.0517578e-04   1.2207031e-04   1.8310547e-04   3.0517578e-05   4.2724609e-04   9.1552734e-05   3.3569336e-04   4.5776367e-04   2.4414062e-04   3.9672852e-04   1.2207031e-04   6.7138672e-04   3.6621094e-04   3.0517578e-04   5.1879883e-04   2.1362305e-04   5.4931641e-04   2.4414062e-04   3.3569336e-04   2.4414062e-04   3.9672852e-04   3.0517578e-04   9.1552734e-05   5.4931641e-04   1.8310547e-04   2.7465820e-04   2.4414062e-04   3.0517578e-05   3.0517578e-04   0.0000000e+00   2.4414062e-04  -2.4414062e-04   1.2207031e-04  -2.7465820e-04   1.5258789e-04   0.0000000e+00  -1.5258789e-04  -1.2207031e-04  -1.2207031e-04   1.5258789e-04  -3.3569336e-04   1.8310547e-04  -4.8828125e-04   1.5258789e-04  -2.4414062e-04  -5.1879883e-04   0.0000000e+00  -2.4414062e-04  -6.7138672e-04  -4.2724609e-04  -3.6621094e-04  -6.1035156e-04  -6.1035156e-04  -7.0190430e-04  -6.1035156e-04  -8.2397461e-04  -5.4931641e-04  -1.0986328e-03  -5.4931641e-04  -7.6293945e-04  -1.1596680e-03  -4.8828125e-04  -1.2817383e-03  -7.0190430e-04  -8.8500977e-04  -9.4604492e-04  -8.8500977e-04  -7.0190430e-04  -8.5449219e-04  -8.5449219e-04  -6.7138672e-04  -8.5449219e-04  -5.4931641e-04  -7.6293945e-04  -6.7138672e-04  -5.4931641e-04  -3.6621094e-04  -6.7138672e-04  -2.4414062e-04  -2.7465820e-04  -2.7465820e-04  -1.5258789e-04  -3.6621094e-04   9.1552734e-05  -2.1362305e-04   3.0517578e-05  -1.2207031e-04   9.1552734e-05  -6.1035156e-05   9.1552734e-05   1.2207031e-04   0.0000000e+00   9.1552734e-05   6.1035156e-05   9.1552734e-05   1.2207031e-04  -6.1035156e-05  -1.8310547e-04  -9.1552734e-05  -3.6621094e-04   2.1362305e-04  -6.1035156e-04  -2.1362305e-04  -2.4414062e-04  -5.7983398e-04  -4.2724609e-04  -7.0190430e-04  -4.2724609e-04  -6.4086914e-04  -8.8500977e-04  -5.4931641e-04  -7.0190430e-04  -6.7138672e-04  -8.8500977e-04  -6.1035156e-04  -1.0375977e-03  -6.1035156e-04  -7.0190430e-04  -9.1552734e-04  -7.0190430e-04  -6.7138672e-04  -9.7656250e-04  -6.4086914e-04  -8.8500977e-04  -6.4086914e-04  -8.2397461e-04  -6.7138672e-04  -5.1879883e-04  -6.1035156e-04  -7.0190430e-04  -5.7983398e-04  -5.1879883e-04  -5.1879883e-04  -3.3569336e-04  -3.6621094e-04  -2.7465820e-04  -2.7465820e-04  -3.0517578e-05  -1.8310547e-04  -6.1035156e-05  -3.0517578e-05   1.5258789e-04  -1.2207031e-04   1.5258789e-04   4.2724609e-04   3.0517578e-05   3.9672852e-04   3.6621094e-04   3.9672852e-04   5.7983398e-04   4.8828125e-04   3.3569336e-04   7.0190430e-04   6.7138672e-04   8.2397461e-04   5.7983398e-04   6.7138672e-04   7.0190430e-04   6.1035156e-04   9.7656250e-04   6.1035156e-04   9.1552734e-04   7.3242188e-04   1.1596680e-03   7.0190430e-04   8.5449219e-04   1.2817383e-03   7.0190430e-04   1.1901855e-03   7.3242188e-04   1.0070801e-03   1.0986328e-03   6.1035156e-04   1.4953613e-03   3.9672852e-04   1.1901855e-03   7.0190430e-04   9.4604492e-04   8.5449219e-04   8.5449219e-04   9.7656250e-04   7.9345703e-04   9.4604492e-04   8.2397461e-04   1.0986328e-03   6.7138672e-04   1.0986328e-03   9.1552734e-04   1.0070801e-03   1.1901855e-03   1.1291504e-03   1.0375977e-03   9.7656250e-04   9.4604492e-04   1.1291504e-03   1.2207031e-03   1.2207031e-03   1.0375977e-03   1.0986328e-03   1.0986328e-03   1.3122559e-03   7.9345703e-04   1.5563965e-03   7.6293945e-04   1.3732910e-03   1.1291504e-03   1.0681152e-03   1.0986328e-03   9.7656250e-04   1.1291504e-03   9.7656250e-04   1.1291504e-03   8.5449219e-04   1.1291504e-03   1.0070801e-03   7.9345703e-04   8.5449219e-04   1.0070801e-03   7.0190430e-04   9.4604492e-04   6.1035156e-04   7.9345703e-04   7.0190430e-04   6.7138672e-04   5.4931641e-04   5.1879883e-04   5.4931641e-04   4.8828125e-04   4.5776367e-04   3.0517578e-04   4.5776367e-04   3.0517578e-04   3.6621094e-04   1.5258789e-04   2.1362305e-04   3.0517578e-04   3.3569336e-04   2.1362305e-04   3.3569336e-04   2.1362305e-04   4.2724609e-04   1.5258789e-04   2.1362305e-04   6.4086914e-04   6.1035156e-05   3.6621094e-04   3.9672852e-04   2.4414062e-04   1.5258789e-04   4.8828125e-04   2.1362305e-04   4.5776367e-04   4.2724609e-04   2.7465820e-04   5.1879883e-04   5.4931641e-04   2.1362305e-04   4.8828125e-04   5.1879883e-04   1.8310547e-04   4.8828125e-04   1.8310547e-04   6.1035156e-04   3.6621094e-04   2.1362305e-04   1.2207031e-04   1.2207031e-04   2.1362305e-04   9.1552734e-05   2.4414062e-04  -3.3569336e-04   2.1362305e-04  -2.1362305e-04  -2.1362305e-04  -3.9672852e-04  -3.0517578e-04  -3.9672852e-04  -4.5776367e-04  -5.7983398e-04  -8.5449219e-04  -5.1879883e-04  -7.9345703e-04  -1.0070801e-03  -7.9345703e-04  -1.1291504e-03  -9.7656250e-04  -9.7656250e-04  -1.0070801e-03  -1.2512207e-03  -8.8500977e-04  -1.2512207e-03  -7.0190430e-04  -1.3427734e-03  -7.9345703e-04  -8.5449219e-04  -1.0681152e-03  -9.7656250e-04  -9.1552734e-04  -7.0190430e-04  -9.4604492e-04  -7.6293945e-04  -1.0070801e-03  -7.9345703e-04  -6.1035156e-04  -6.1035156e-04  -7.6293945e-04  -7.6293945e-04  -4.5776367e-04  -6.1035156e-04  -6.4086914e-04  -3.3569336e-04  -5.1879883e-04  -3.6621094e-04  -5.1879883e-04  -3.0517578e-04  -4.2724609e-04  -2.1362305e-04  -3.9672852e-04  -3.3569336e-04  -1.8310547e-04  -5.4931641e-04   1.2207031e-04  -4.2724609e-04  -3.0517578e-05  -1.5258789e-04   0.0000000e+00  -3.3569336e-04  -6.1035156e-05  -3.0517578e-04   6.1035156e-05  -1.8310547e-04  -1.8310547e-04  -2.4414062e-04  -1.2207031e-04  -2.7465820e-04  -1.5258789e-04   0.0000000e+00  -5.4931641e-04  -1.2207031e-04  -1.2207031e-04  -4.2724609e-04  -2.1362305e-04  -3.0517578e-04  -1.5258789e-04  -3.9672852e-04  -3.3569336e-04  -1.8310547e-04  -4.5776367e-04  -2.7465820e-04  -3.6621094e-04  -3.0517578e-04  -6.1035156e-04  -3.6621094e-04  -5.7983398e-04  -4.8828125e-04  -5.7983398e-04  -5.4931641e-04  -1.8310547e-04  -9.4604492e-04   0.0000000e+00  -6.1035156e-04  -3.0517578e-04  -4.8828125e-04  -2.7465820e-04  -3.9672852e-04  -2.7465820e-04  -3.3569336e-04  -1.5258789e-04  -4.5776367e-04   0.0000000e+00  -1.8310547e-04  -2.7465820e-04  -1.2207031e-04  -1.2207031e-04   6.1035156e-05  -1.8310547e-04  -6.1035156e-05   3.0517578e-05   9.1552734e-05  -2.7465820e-04   1.5258789e-04  -3.0517578e-05   1.5258789e-04  -6.1035156e-05  -3.0517578e-05   3.0517578e-05   0.0000000e+00   6.1035156e-05  -1.5258789e-04  -1.2207031e-04  -6.1035156e-05  -3.0517578e-05  -1.2207031e-04  -2.1362305e-04  -1.5258789e-04  -1.5258789e-04  -1.2207031e-04  -2.7465820e-04  -1.5258789e-04  -3.3569336e-04  -2.4414062e-04  -2.7465820e-04  -1.2207031e-04  -3.3569336e-04  -5.7983398e-04  -3.0517578e-05  -5.4931641e-04  -3.0517578e-04  -2.1362305e-04  -3.3569336e-04  -3.0517578e-04  -3.9672852e-04  -1.2207031e-04  -1.5258789e-04  -2.7465820e-04   2.1362305e-04  -4.5776367e-04   3.0517578e-05  -3.0517578e-05  -9.1552734e-05  -3.0517578e-05  -9.1552734e-05   2.4414062e-04  -3.3569336e-04   6.1035156e-05   1.5258789e-04  -2.1362305e-04   3.0517578e-05  -2.1362305e-04   2.1362305e-04  -1.8310547e-04   6.1035156e-05   3.0517578e-05  -2.7465820e-04   6.1035156e-05  -3.9672852e-04  -6.1035156e-05   1.2207031e-04  -3.3569336e-04  -1.5258789e-04  -4.2724609e-04  -1.2207031e-04  -3.3569336e-04  -3.0517578e-04  -6.4086914e-04  -4.5776367e-04  -4.2724609e-04  -8.5449219e-04  -2.7465820e-04  -7.6293945e-04  -8.2397461e-04  -4.8828125e-04  -9.7656250e-04  -6.7138672e-04  -8.8500977e-04  -7.6293945e-04  -8.5449219e-04  -1.1596680e-03  -8.2397461e-04  -7.9345703e-04  -1.0070801e-03  -1.0681152e-03  -9.7656250e-04  -8.2397461e-04  -7.3242188e-04  -1.0375977e-03  -5.4931641e-04  -8.5449219e-04  -6.1035156e-04  -7.9345703e-04  -4.5776367e-04  -3.9672852e-04  -3.9672852e-04  -4.2724609e-04  -2.1362305e-04  -3.6621094e-04  -3.3569336e-04   0.0000000e+00  -2.7465820e-04   6.1035156e-05   1.5258789e-04   3.0517578e-05  -2.7465820e-04   5.4931641e-04   2.4414062e-04   1.8310547e-04   6.1035156e-04   2.4414062e-04   6.1035156e-04   2.4414062e-04   7.3242188e-04   3.6621094e-04   8.5449219e-04   3.9672852e-04   8.5449219e-04   5.4931641e-04   7.0190430e-04   7.0190430e-04   5.1879883e-04   8.5449219e-04   6.1035156e-04   5.1879883e-04   7.0190430e-04   3.6621094e-04   9.1552734e-04   3.6621094e-04   9.1552734e-04   4.8828125e-04   5.1879883e-04   6.4086914e-04   4.5776367e-04   5.7983398e-04   2.7465820e-04   6.4086914e-04   4.2724609e-04   4.8828125e-04   1.8310547e-04   5.7983398e-04   2.7465820e-04   3.9672852e-04   5.1879883e-04   1.2207031e-04   3.6621094e-04   3.6621094e-04   2.7465820e-04   3.6621094e-04   1.8310547e-04   4.8828125e-04   2.1362305e-04   3.9672852e-04   3.0517578e-04   2.1362305e-04   3.9672852e-04   3.3569336e-04   4.5776367e-04   2.1362305e-04   5.7983398e-04   4.5776367e-04   5.4931641e-04   5.7983398e-04   5.7983398e-04   6.4086914e-04   7.3242188e-04   5.4931641e-04   7.9345703e-04   7.6293945e-04   8.2397461e-04   9.1552734e-04   7.0190430e-04   1.0070801e-03   7.0190430e-04   9.4604492e-04   8.8500977e-04   1.0681152e-03   1.0375977e-03   7.6293945e-04   1.0070801e-03   7.6293945e-04   1.4038086e-03   7.0190430e-04   1.2207031e-03   1.0070801e-03   7.9345703e-04   7.3242188e-04   1.2817383e-03   7.9345703e-04   9.1552734e-04   8.8500977e-04   7.3242188e-04   9.7656250e-04   7.0190430e-04   8.2397461e-04   6.1035156e-04   9.4604492e-04   4.5776367e-04   9.4604492e-04   3.3569336e-04   1.1291504e-03   3.0517578e-05   1.3122559e-03   1.2207031e-04   9.1552734e-04   3.3569336e-04   6.4086914e-04   5.7983398e-04   6.1035156e-04   6.7138672e-04   4.8828125e-04   3.6621094e-04   6.4086914e-04   6.4086914e-04   6.7138672e-04   4.8828125e-04   4.8828125e-04   6.7138672e-04   5.1879883e-04   7.0190430e-04   2.1362305e-04   7.3242188e-04   1.5258789e-04   7.0190430e-04   1.2207031e-04   3.0517578e-04   3.9672852e-04   1.8310547e-04   3.0517578e-04   1.2207031e-04   3.0517578e-04  -3.3569336e-04   2.7465820e-04  -2.4414062e-04   1.2207031e-04   0.0000000e+00  -1.2207031e-04  -9.1552734e-05  -3.3569336e-04   0.0000000e+00  -5.1879883e-04  -3.0517578e-05  -6.4086914e-04  -3.6621094e-04  -5.7983398e-04  -5.4931641e-04  -6.1035156e-04  -5.7983398e-04  -7.6293945e-04  -5.4931641e-04  -8.2397461e-04  -6.4086914e-04  -5.7983398e-04  -6.7138672e-04  -7.6293945e-04  -9.4604492e-04  -5.4931641e-04  -8.8500977e-04  -6.7138672e-04  -7.6293945e-04  -3.9672852e-04  -1.2207031e-03  -3.6621094e-04  -6.4086914e-04  -7.3242188e-04  -6.4086914e-04  -5.1879883e-04  -4.2724609e-04  -6.1035156e-04  -3.9672852e-04  -4.2724609e-04  -5.1879883e-04  -4.8828125e-04   0.0000000e+00  -4.8828125e-04  -4.2724609e-04  -1.5258789e-04  -2.7465820e-04  -1.5258789e-04  -1.2207031e-04  -4.2724609e-04   3.9672852e-04  -3.6621094e-04  -9.1552734e-05   0.0000000e+00   3.0517578e-05  -6.1035156e-05   2.1362305e-04  -9.1552734e-05   9.1552734e-05  -9.1552734e-05   6.1035156e-05   0.0000000e+00  -1.5258789e-04  -1.5258789e-04  -6.1035156e-05  -1.8310547e-04  -2.7465820e-04  -1.2207031e-04  -2.1362305e-04  -3.0517578e-04  -3.6621094e-04  -3.0517578e-04  -4.8828125e-04  -4.5776367e-04  -5.7983398e-04  -1.8310547e-04  -7.0190430e-04  -5.1879883e-04  -8.5449219e-04  -1.2207031e-04  -7.0190430e-04  -6.4086914e-04  -7.3242188e-04  -3.3569336e-04  -7.9345703e-04  -3.6621094e-04  -9.4604492e-04  -4.8828125e-04  -5.7983398e-04  -7.6293945e-04  -4.8828125e-04  -8.2397461e-04  -2.1362305e-04  -8.2397461e-04  -4.2724609e-04  -6.4086914e-04  -2.1362305e-04  -7.6293945e-04  -2.4414062e-04  -5.7983398e-04  -9.1552734e-05  -4.5776367e-04  -3.0517578e-04  -2.1362305e-04  -3.3569336e-04  -1.5258789e-04  -2.4414062e-04   1.2207031e-04  -1.8310547e-04   1.2207031e-04  -2.7465820e-04   0.0000000e+00  -6.1035156e-05  -6.1035156e-05   3.0517578e-05   6.1035156e-05   3.0517578e-04  -3.3569336e-04   3.0517578e-05   9.1552734e-05   9.1552734e-05  -1.2207031e-04   6.1035156e-05   6.1035156e-05  -2.1362305e-04  -3.0517578e-05  -6.1035156e-05   0.0000000e+00   1.2207031e-04  -9.1552734e-05   6.1035156e-05  -1.2207031e-04  -1.5258789e-04   0.0000000e+00  -1.2207031e-04  -1.5258789e-04   6.1035156e-05  -3.6621094e-04   1.5258789e-04  -3.3569336e-04  -9.1552734e-05  -4.5776367e-04   3.0517578e-05  -2.4414062e-04  -6.1035156e-05  -6.1035156e-05  -4.2724609e-04   1.5258789e-04  -9.1552734e-05   0.0000000e+00  -9.1552734e-05  -2.4414062e-04   3.3569336e-04  -1.2207031e-04   0.0000000e+00  -3.0517578e-05   9.1552734e-05   1.8310547e-04  -3.9672852e-04   3.6621094e-04  -3.0517578e-05   2.4414062e-04  -1.8310547e-04   9.1552734e-05   1.2207031e-04  -1.8310547e-04   9.1552734e-05  -1.8310547e-04   6.1035156e-05  -9.1552734e-05  -3.0517578e-04  -9.1552734e-05  -3.6621094e-04  -2.1362305e-04  -3.3569336e-04  -3.0517578e-04  -3.3569336e-04  -4.5776367e-04  -4.5776367e-04  -5.1879883e-04  -4.8828125e-04  -4.8828125e-04  -5.4931641e-04  -5.1879883e-04  -7.0190430e-04  -7.6293945e-04  -4.8828125e-04  -5.7983398e-04  -8.8500977e-04  -8.5449219e-04  -7.3242188e-04  -5.7983398e-04  -9.1552734e-04  -7.9345703e-04  -6.7138672e-04  -7.0190430e-04  -8.2397461e-04  -5.4931641e-04  -6.1035156e-04  -6.7138672e-04  -6.1035156e-04  -4.5776367e-04  -7.6293945e-04  -9.1552734e-05  -4.8828125e-04  -1.8310547e-04  -3.9672852e-04  -3.0517578e-04  -1.5258789e-04  -3.3569336e-04  -3.0517578e-05  -3.0517578e-04   0.0000000e+00  -3.0517578e-05   6.1035156e-05   6.1035156e-05   3.0517578e-05   2.1362305e-04   3.3569336e-04  -1.8310547e-04   3.3569336e-04   4.8828125e-04   1.2207031e-04   2.7465820e-04   3.6621094e-04   1.8310547e-04   6.4086914e-04   9.1552734e-05   3.6621094e-04   4.2724609e-04   3.6621094e-04   2.7465820e-04   5.4931641e-04   2.4414062e-04   5.4931641e-04   3.9672852e-04   2.7465820e-04   1.8310547e-04   3.6621094e-04   3.6621094e-04   1.8310547e-04   2.1362305e-04   0.0000000e+00   2.1362305e-04   1.2207031e-04   1.2207031e-04  -2.1362305e-04   1.2207031e-04  -1.5258789e-04  -1.2207031e-04   9.1552734e-05  -2.1362305e-04   2.1362305e-04  -1.2207031e-04   3.0517578e-05   0.0000000e+00  -9.1552734e-05   2.4414062e-04  -3.6621094e-04   1.5258789e-04   0.0000000e+00   3.3569336e-04  -3.0517578e-05   1.2207031e-04   0.0000000e+00   2.4414062e-04   1.5258789e-04   3.6621094e-04   2.4414062e-04   2.4414062e-04   6.4086914e-04   3.6621094e-04   7.0190430e-04   3.6621094e-04   8.2397461e-04   6.4086914e-04   5.4931641e-04   8.5449219e-04   9.1552734e-04   7.9345703e-04   9.4604492e-04   7.6293945e-04   1.0681152e-03   7.0190430e-04   1.2512207e-03   7.0190430e-04   1.0681152e-03   8.2397461e-04   1.1596680e-03   8.2397461e-04   1.0070801e-03   1.0681152e-03   7.3242188e-04   1.1596680e-03   7.6293945e-04   7.6293945e-04   1.0986328e-03   3.3569336e-04   9.7656250e-04   5.4931641e-04   9.1552734e-04   6.7138672e-04   7.3242188e-04   4.5776367e-04   8.2397461e-04   7.6293945e-04   5.1879883e-04   5.1879883e-04   5.7983398e-04   6.1035156e-04   4.5776367e-04   8.2397461e-04   1.8310547e-04   4.8828125e-04   3.3569336e-04   3.3569336e-04   5.4931641e-04   5.4931641e-04   3.9672852e-04   4.2724609e-04   6.1035156e-05   7.0190430e-04   2.4414062e-04   5.7983398e-04   3.9672852e-04   3.3569336e-04   4.2724609e-04   5.7983398e-04   4.5776367e-04   3.6621094e-04   3.3569336e-04   5.1879883e-04   4.8828125e-04   6.7138672e-04   0.0000000e+00   6.7138672e-04   1.2207031e-04   6.7138672e-04   3.0517578e-05   5.1879883e-04   1.2207031e-04   3.3569336e-04   1.8310547e-04   2.1362305e-04   1.8310547e-04   1.2207031e-04   2.1362305e-04  -3.0517578e-05   0.0000000e+00   1.2207031e-04  -9.1552734e-05  -6.1035156e-05  -1.5258789e-04   3.0517578e-05  -5.1879883e-04  -6.1035156e-05  -2.4414062e-04  -2.4414062e-04  -3.0517578e-04  -3.0517578e-04  -1.2207031e-04  -4.5776367e-04  -4.2724609e-04  -3.3569336e-04  -4.8828125e-04  -3.3569336e-04  -1.5258789e-04  -7.3242188e-04  -4.2724609e-04  -5.1879883e-04  -3.0517578e-04  -3.0517578e-04  -4.8828125e-04  -3.0517578e-04  -5.1879883e-04  -3.3569336e-04  -2.4414062e-04  -3.6621094e-04   1.2207031e-04  -5.1879883e-04   1.5258789e-04  -6.7138672e-04   3.6621094e-04  -4.8828125e-04   6.1035156e-05  -2.1362305e-04  -1.2207031e-04   0.0000000e+00  -1.5258789e-04   0.0000000e+00  -3.0517578e-04   3.0517578e-05   0.0000000e+00  -1.8310547e-04  -1.8310547e-04   6.1035156e-05  -1.8310547e-04  -6.1035156e-05  -2.4414062e-04   6.1035156e-05  -2.1362305e-04   6.1035156e-05  -4.5776367e-04   3.0517578e-05  -3.9672852e-04   6.1035156e-05  -6.7138672e-04   6.1035156e-05  -4.8828125e-04  -1.2207031e-04  -4.8828125e-04  -3.9672852e-04  -2.1362305e-04  -5.4931641e-04  -3.6621094e-04  -5.4931641e-04  -4.5776367e-04  -6.1035156e-04  -6.4086914e-04  -4.8828125e-04  -7.0190430e-04  -5.1879883e-04  -6.1035156e-04  -5.4931641e-04  -5.7983398e-04  -9.7656250e-04  -4.2724609e-04  -5.4931641e-04  -5.1879883e-04  -6.7138672e-04  -6.7138672e-04  -4.5776367e-04  -3.0517578e-04  -6.1035156e-04  -3.6621094e-04  -5.7983398e-04  -6.1035156e-05  -6.1035156e-04  -3.0517578e-04  -3.9672852e-04  -3.0517578e-04  -1.8310547e-04  -3.0517578e-04  -1.5258789e-04  -2.1362305e-04  -6.1035156e-05  -1.5258789e-04  -3.0517578e-05  -9.1552734e-05   0.0000000e+00   9.1552734e-05   1.5258789e-04  -1.2207031e-04   2.1362305e-04   3.6621094e-04  -9.1552734e-05   3.0517578e-04   3.0517578e-05   1.8310547e-04   1.8310547e-04   1.2207031e-04  -3.0517578e-05   2.7465820e-04   1.8310547e-04  -1.5258789e-04   1.2207031e-04   0.0000000e+00  -9.1552734e-05   1.5258789e-04  -1.2207031e-04   9.1552734e-05  -3.3569336e-04   1.5258789e-04  -2.4414062e-04  -2.4414062e-04  -9.1552734e-05  -3.0517578e-04   3.0517578e-05  -4.8828125e-04  -9.1552734e-05  -2.1362305e-04  -3.6621094e-04  -2.4414062e-04  -3.6621094e-04  -1.5258789e-04  -6.1035156e-05  -4.2724609e-04  -3.0517578e-04  -1.8310547e-04  -2.4414062e-04  -3.0517578e-04  -4.2724609e-04  -1.5258789e-04  -2.7465820e-04  -1.8310547e-04  -3.6621094e-04  -2.1362305e-04  -4.5776367e-04   3.0517578e-05  -6.4086914e-04   9.1552734e-05  -2.4414062e-04  -1.2207031e-04  -3.0517578e-04  -1.8310547e-04  -1.2207031e-04  -1.2207031e-04  -3.3569336e-04  -3.0517578e-05   0.0000000e+00  -5.7983398e-04  -1.2207031e-04  -2.1362305e-04  -2.1362305e-04  -2.4414062e-04  -3.0517578e-04  -6.1035156e-05  -4.5776367e-04  -2.7465820e-04  -4.2724609e-04  -9.1552734e-05  -5.1879883e-04  -3.0517578e-05  -7.3242188e-04   9.1552734e-05  -4.8828125e-04  -3.9672852e-04  -3.3569336e-04  -3.9672852e-04  -3.9672852e-04  -2.4414062e-04  -4.2724609e-04  -3.3569336e-04  -3.3569336e-04  -3.9672852e-04  -3.0517578e-04  -4.5776367e-04  -2.4414062e-04  -2.7465820e-04  -3.9672852e-04  -2.7465820e-04  -9.1552734e-05  -3.9672852e-04  -2.7465820e-04  -3.0517578e-04  -9.1552734e-05  -1.8310547e-04  -3.3569336e-04  -1.2207031e-04  -1.5258789e-04  -1.5258789e-04   3.0517578e-05  -1.8310547e-04   1.2207031e-04   0.0000000e+00  -3.0517578e-05   3.0517578e-05   1.2207031e-04   1.5258789e-04  -6.1035156e-05   9.1552734e-05   0.0000000e+00   4.2724609e-04  -6.1035156e-05   6.1035156e-05   3.0517578e-05   1.8310547e-04   1.5258789e-04  -9.1552734e-05   1.8310547e-04   3.0517578e-05   0.0000000e+00   9.1552734e-05   1.2207031e-04   1.2207031e-04  -9.1552734e-05  -6.1035156e-05   3.0517578e-04  -2.1362305e-04   1.8310547e-04  -1.8310547e-04  -2.7465820e-04   6.1035156e-05  -1.2207031e-04  -1.5258789e-04   0.0000000e+00  -2.4414062e-04  -3.0517578e-05  -2.1362305e-04   3.0517578e-05  -6.1035156e-05  -3.0517578e-04  -9.1552734e-05  -2.1362305e-04  -6.1035156e-05  -1.8310547e-04   3.0517578e-05  -6.1035156e-05  -9.1552734e-05  -9.1552734e-05  -1.2207031e-04   1.8310547e-04   6.1035156e-05  -6.1035156e-05   2.4414062e-04   0.0000000e+00   3.9672852e-04   0.0000000e+00   6.4086914e-04   6.1035156e-05   7.3242188e-04   6.1035156e-05   6.1035156e-04   2.7465820e-04   8.2397461e-04   1.2207031e-04   7.9345703e-04   5.4931641e-04   3.9672852e-04   8.2397461e-04   3.6621094e-04   1.0070801e-03   4.2724609e-04   9.4604492e-04   6.4086914e-04   7.9345703e-04   7.9345703e-04   7.6293945e-04   5.7983398e-04   1.0681152e-03   7.3242188e-04   7.3242188e-04   7.9345703e-04   8.5449219e-04   6.4086914e-04   6.7138672e-04   8.5449219e-04   5.1879883e-04   7.0190430e-04   7.6293945e-04   3.0517578e-04   6.4086914e-04   4.5776367e-04   7.0190430e-04   6.4086914e-04   3.3569336e-04   5.4931641e-04   4.2724609e-04   3.0517578e-04   3.3569336e-04   6.1035156e-04   2.4414062e-04   2.4414062e-04   3.6621094e-04   4.5776367e-04   3.0517578e-04   2.7465820e-04   1.8310547e-04   5.7983398e-04   9.1552734e-05   3.3569336e-04   2.1362305e-04   3.0517578e-04   3.6621094e-04   2.1362305e-04   4.2724609e-04   3.0517578e-05   5.7983398e-04   2.4414062e-04   2.4414062e-04   2.4414062e-04   4.8828125e-04   3.0517578e-05   3.9672852e-04   2.7465820e-04   6.1035156e-05   4.2724609e-04   1.2207031e-04   5.1879883e-04   2.1362305e-04   4.2724609e-04   6.1035156e-05   5.7983398e-04   2.4414062e-04   1.5258789e-04   1.8310547e-04   4.2724609e-04   1.5258789e-04   4.2724609e-04   3.0517578e-05   1.2207031e-04   2.1362305e-04   1.2207031e-04   0.0000000e+00   2.1362305e-04   3.0517578e-04  -1.5258789e-04   1.8310547e-04   2.7465820e-04   1.8310547e-04  -3.3569336e-04   3.3569336e-04  -9.1552734e-05   2.1362305e-04  -9.1552734e-05   3.0517578e-05   2.1362305e-04  -2.1362305e-04   0.0000000e+00   1.2207031e-04  -6.1035156e-05   9.1552734e-05  -6.1035156e-05  -1.2207031e-04   9.1552734e-05  -1.8310547e-04   9.1552734e-05  -1.2207031e-04   1.5258789e-04  -4.8828125e-04   5.1879883e-04  -3.6621094e-04   9.1552734e-05  -1.2207031e-04   0.0000000e+00  -1.5258789e-04   0.0000000e+00  -3.0517578e-05  -1.2207031e-04  -6.1035156e-05   6.1035156e-05  -3.0517578e-04  -3.0517578e-05  -1.5258789e-04   3.0517578e-05   3.0517578e-05  -3.9672852e-04   1.5258789e-04  -2.7465820e-04  -3.3569336e-04  -3.0517578e-05  -3.0517578e-04  -1.5258789e-04  -3.3569336e-04  -1.2207031e-04  -3.6621094e-04  -4.5776367e-04  -9.1552734e-05  -4.8828125e-04   3.0517578e-05  -7.9345703e-04  -3.0517578e-05  -6.1035156e-04  -1.5258789e-04  -5.1879883e-04  -2.7465820e-04  -5.4931641e-04  -5.1879883e-04  -4.5776367e-04  -4.5776367e-04  -4.5776367e-04  -4.2724609e-04  -7.9345703e-04  -2.4414062e-04  -7.3242188e-04  -4.8828125e-04  -2.4414062e-04  -6.7138672e-04  -4.2724609e-04  -3.9672852e-04  -6.4086914e-04  -2.7465820e-04  -4.5776367e-04  -3.9672852e-04  -3.0517578e-04  -3.0517578e-04  -3.6621094e-04  -5.1879883e-04   0.0000000e+00  -3.0517578e-04  -1.5258789e-04  -1.8310547e-04  -3.3569336e-04  -3.0517578e-05  -6.1035156e-05  -6.1035156e-05   0.0000000e+00  -9.1552734e-05  -1.8310547e-04   2.4414062e-04  -2.1362305e-04   3.0517578e-05   6.1035156e-05   1.2207031e-04   0.0000000e+00   3.0517578e-05   0.0000000e+00  -3.0517578e-05   6.1035156e-05   9.1552734e-05   2.4414062e-04   3.0517578e-05   9.1552734e-05  -1.2207031e-04   9.1552734e-05   1.8310547e-04  -2.1362305e-04   3.0517578e-05   9.1552734e-05  -2.4414062e-04  -6.1035156e-05   3.0517578e-05  -6.1035156e-05  -2.1362305e-04  -2.1362305e-04  -3.3569336e-04  -9.1552734e-05  -4.8828125e-04  -3.0517578e-05  -4.5776367e-04  -1.2207031e-04  -3.3569336e-04  -3.3569336e-04  -1.2207031e-04  -4.2724609e-04  -2.4414062e-04  -3.9672852e-04  -3.3569336e-04  -1.2207031e-04  -3.6621094e-04  -5.7983398e-04  -3.0517578e-05  -4.5776367e-04  -3.3569336e-04  -3.0517578e-04  -4.5776367e-04  -3.0517578e-05  -5.4931641e-04  -3.0517578e-05  -5.4931641e-04  -1.2207031e-04  -2.7465820e-04  -3.0517578e-04  -2.4414062e-04  -1.5258789e-04  -3.9672852e-04  -2.1362305e-04  -3.0517578e-05  -2.7465820e-04  -2.1362305e-04  -3.9672852e-04   3.0517578e-05  -2.1362305e-04  -9.1552734e-05  -9.1552734e-05  -1.8310547e-04  -1.2207031e-04  -3.0517578e-05  -2.7465820e-04  -2.1362305e-04   6.1035156e-05  -2.1362305e-04  -9.1552734e-05  -3.6621094e-04   3.0517578e-05  -2.7465820e-04  -2.1362305e-04  -3.0517578e-05  -2.4414062e-04  -1.2207031e-04  -3.3569336e-04   6.1035156e-05  -3.0517578e-04  -3.0517578e-05  -3.0517578e-04   9.1552734e-05  -4.2724609e-04   1.2207031e-04  -3.6621094e-04  -1.5258789e-04   6.1035156e-05  -3.6621094e-04   3.0517578e-05  -1.5258789e-04   9.1552734e-05  -2.4414062e-04  -1.8310547e-04  -3.9672852e-04   2.7465820e-04  -1.8310547e-04  -3.0517578e-05  -3.3569336e-04   3.0517578e-05  -1.8310547e-04   1.5258789e-04  -3.0517578e-04   9.1552734e-05  -3.0517578e-05  -9.1552734e-05   0.0000000e+00   0.0000000e+00  -1.5258789e-04  -3.0517578e-05   0.0000000e+00  -9.1552734e-05   6.1035156e-05  -2.7465820e-04   0.0000000e+00  -1.2207031e-04   3.0517578e-04  -1.8310547e-04   6.1035156e-05  -2.4414062e-04   1.2207031e-04   3.0517578e-05  -3.6621094e-04  -3.0517578e-05   9.1552734e-05  -3.6621094e-04   1.8310547e-04  -2.4414062e-04  -1.8310547e-04  -1.8310547e-04   1.2207031e-04  -3.3569336e-04   1.2207031e-04  -2.7465820e-04  -6.1035156e-05   0.0000000e+00  -2.1362305e-04   1.5258789e-04  -3.0517578e-04   9.1552734e-05  -3.6621094e-04   2.4414062e-04  -4.5776367e-04   1.2207031e-04  -1.8310547e-04  -3.0517578e-05  -9.1552734e-05  -9.1552734e-05   2.4414062e-04  -9.1552734e-05  -9.1552734e-05  -3.0517578e-05   1.2207031e-04  -3.0517578e-05   4.2724609e-04  -1.8310547e-04   3.6621094e-04   1.5258789e-04   3.3569336e-04   2.1362305e-04   5.7983398e-04   0.0000000e+00   3.3569336e-04   4.2724609e-04   4.5776367e-04   3.0517578e-04   5.1879883e-04   5.1879883e-04   3.9672852e-04   5.4931641e-04   4.2724609e-04   5.1879883e-04   5.4931641e-04   6.1035156e-04   4.2724609e-04   7.3242188e-04   6.4086914e-04   3.9672852e-04   6.4086914e-04   6.4086914e-04   2.1362305e-04   6.4086914e-04   7.9345703e-04   3.9672852e-04   4.8828125e-04   6.4086914e-04   3.0517578e-04   6.7138672e-04   1.5258789e-04   5.4931641e-04   4.5776367e-04   3.3569336e-04   3.9672852e-04   3.6621094e-04   2.4414062e-04   4.2724609e-04   3.0517578e-05   3.9672852e-04   2.4414062e-04   2.7465820e-04   9.1552734e-05   3.0517578e-04   6.1035156e-05   3.6621094e-04   9.1552734e-05   2.4414062e-04   1.5258789e-04   3.3569336e-04   1.8310547e-04   2.1362305e-04   2.7465820e-04   1.8310547e-04   3.0517578e-05   3.9672852e-04   1.5258789e-04   3.6621094e-04   1.5258789e-04   3.3569336e-04   2.7465820e-04   9.1552734e-05   2.7465820e-04   5.4931641e-04  -1.2207031e-04   3.9672852e-04   3.3569336e-04   5.1879883e-04   1.2207031e-04   3.3569336e-04   3.0517578e-04   3.0517578e-04   3.0517578e-04   4.8828125e-04   5.1879883e-04   2.4414062e-04   4.2724609e-04   3.0517578e-04   3.9672852e-04   3.3569336e-04   3.9672852e-04   3.6621094e-04   3.9672852e-04   4.5776367e-04   1.5258789e-04   5.4931641e-04   2.1362305e-04   4.2724609e-04   2.7465820e-04   3.6621094e-04   1.2207031e-04   3.0517578e-04   1.8310547e-04   3.9672852e-04   6.1035156e-05   2.4414062e-04   2.7465820e-04   1.2207031e-04   2.1362305e-04   3.0517578e-05   2.1362305e-04   2.1362305e-04   0.0000000e+00   2.1362305e-04   0.0000000e+00   3.6621094e-04  -1.5258789e-04   2.4414062e-04  -1.5258789e-04   1.5258789e-04  -9.1552734e-05   9.1552734e-05  -1.5258789e-04   6.1035156e-05   1.5258789e-04  -2.4414062e-04  -6.1035156e-05  -9.1552734e-05  -6.1035156e-05   0.0000000e+00   0.0000000e+00  -1.2207031e-04  -3.0517578e-05  -6.1035156e-05   1.2207031e-04  -3.3569336e-04   3.0517578e-05  -3.0517578e-05  -3.0517578e-04  -1.5258789e-04  -9.1552734e-05  -1.5258789e-04  -3.0517578e-05  -2.4414062e-04  -2.1362305e-04  -6.1035156e-05  -2.4414062e-04  -1.8310547e-04  -3.9672852e-04   3.0517578e-05  -2.7465820e-04  -2.4414062e-04  -9.1552734e-05  -2.7465820e-04  -2.4414062e-04  -3.0517578e-04  -2.1362305e-04  -3.6621094e-04  -3.9672852e-04  -6.1035156e-05  -3.3569336e-04  -4.5776367e-04  -3.0517578e-05  -5.4931641e-04  -1.2207031e-04  -3.6621094e-04  -2.4414062e-04  -3.0517578e-04  -3.0517578e-04  -3.0517578e-04  -1.2207031e-04  -3.0517578e-04  -4.2724609e-04  -2.1362305e-04  -5.1879883e-04  -1.2207031e-04  -3.9672852e-04  -1.8310547e-04  -3.6621094e-04  -1.5258789e-04  -3.3569336e-04  -1.8310547e-04  -1.8310547e-04  -9.1552734e-05  -2.7465820e-04   3.0517578e-05  -2.1362305e-04  -3.6621094e-04   2.4414062e-04  -2.4414062e-04  -1.2207031e-04  -3.3569336e-04   3.9672852e-04  -5.4931641e-04   2.7465820e-04  -2.7465820e-04  -2.7465820e-04   1.5258789e-04  -2.4414062e-04   6.1035156e-05  -2.1362305e-04   9.1552734e-05  -3.0517578e-05  -2.7465820e-04   0.0000000e+00  -1.5258789e-04  -9.1552734e-05   1.2207031e-04  -4.8828125e-04   0.0000000e+00  -6.1035156e-05  -4.8828125e-04   3.0517578e-05  -1.5258789e-04  -3.6621094e-04  -3.0517578e-04  -3.0517578e-05  -3.9672852e-04  -6.1035156e-05  -3.9672852e-04  -1.8310547e-04  -1.8310547e-04  -4.2724609e-04  -3.3569336e-04  -4.8828125e-04  -6.1035156e-05  -3.9672852e-04  -3.3569336e-04  -2.1362305e-04  -4.2724609e-04  -1.5258789e-04  -4.2724609e-04  -4.2724609e-04  -2.4414062e-04  -2.7465820e-04  -2.1362305e-04  -1.8310547e-04  -3.6621094e-04   3.0517578e-05  -2.1362305e-04  -2.4414062e-04  -1.5258789e-04  -3.6621094e-04   1.2207031e-04  -3.0517578e-04  -9.1552734e-05  -6.1035156e-05  -2.1362305e-04  -1.8310547e-04   6.1035156e-05  -2.1362305e-04   2.1362305e-04  -3.3569336e-04   9.1552734e-05  -1.2207031e-04  -2.4414062e-04  -3.0517578e-05  -6.1035156e-05   3.3569336e-04  -3.3569336e-04   3.6621094e-04  -3.0517578e-04   1.2207031e-04   0.0000000e+00  -1.5258789e-04   2.1362305e-04  -2.1362305e-04   0.0000000e+00  -1.8310547e-04   6.1035156e-05  -6.1035156e-05  -6.1035156e-05   0.0000000e+00  -9.1552734e-05   3.0517578e-05  -9.1552734e-05  -9.1552734e-05  -1.8310547e-04  -2.4414062e-04   2.1362305e-04  -2.4414062e-04  -6.1035156e-05  -2.7465820e-04  -9.1552734e-05  -2.4414062e-04  -6.1035156e-05  -2.4414062e-04   6.1035156e-05  -3.9672852e-04  -9.1552734e-05  -3.6621094e-04   9.1552734e-05  -1.8310547e-04  -2.4414062e-04  -1.8310547e-04  -1.8310547e-04  -1.2207031e-04   0.0000000e+00  -5.7983398e-04  -3.0517578e-05  -4.5776367e-04   9.1552734e-05  -3.9672852e-04   1.5258789e-04  -3.9672852e-04  -2.4414062e-04  -9.1552734e-05  -6.1035156e-05   3.0517578e-05  -3.3569336e-04   0.0000000e+00  -1.5258789e-04  -2.7465820e-04   2.1362305e-04  -2.4414062e-04  -1.2207031e-04   2.1362305e-04  -4.2724609e-04   6.1035156e-05  -9.1552734e-05  -2.4414062e-04  -9.1552734e-05   9.1552734e-05  -1.2207031e-04  -3.3569336e-04   3.0517578e-04  -1.5258789e-04  -6.1035156e-05  -6.1035156e-05   6.1035156e-05  -2.4414062e-04   2.7465820e-04  -2.7465820e-04   1.2207031e-04  -3.0517578e-04   2.4414062e-04  -1.2207031e-04   6.1035156e-05  -3.0517578e-05   1.2207031e-04  -6.1035156e-05   6.1035156e-05   1.5258789e-04   0.0000000e+00  -9.1552734e-05   1.2207031e-04   1.2207031e-04   6.1035156e-05   2.1362305e-04   9.1552734e-05  -3.0517578e-05   3.0517578e-05   3.0517578e-04   1.5258789e-04   3.0517578e-04   0.0000000e+00   4.2724609e-04  -2.1362305e-04   8.8500977e-04  -4.5776367e-04   7.6293945e-04  -9.1552734e-05   7.3242188e-04   6.1035156e-05   4.2724609e-04   3.0517578e-04   3.0517578e-05   5.7983398e-04   3.9672852e-04   1.5258789e-04   2.7465820e-04   2.1362305e-04   4.2724609e-04   3.9672852e-04   3.3569336e-04   9.1552734e-05   5.1879883e-04   1.2207031e-04   3.9672852e-04   1.8310547e-04   2.4414062e-04   4.2724609e-04   1.2207031e-04   4.2724609e-04   6.1035156e-05   3.6621094e-04   2.7465820e-04   1.2207031e-04   2.7465820e-04   2.4414062e-04   6.1035156e-05   2.1362305e-04   3.0517578e-04   1.2207031e-04   1.5258789e-04   3.3569336e-04  -9.1552734e-05   5.1879883e-04   1.2207031e-04   1.2207031e-04   3.0517578e-04  -3.0517578e-05   2.4414062e-04   4.5776367e-04   1.2207031e-04   1.2207031e-04   3.0517578e-04   2.1362305e-04   2.4414062e-04   2.7465820e-04   2.1362305e-04   3.3569336e-04   4.8828125e-04   3.0517578e-04   2.7465820e-04   4.8828125e-04   1.2207031e-04   8.2397461e-04   2.1362305e-04   4.2724609e-04   3.3569336e-04   4.2724609e-04   6.1035156e-04   1.2207031e-04   3.9672852e-04   2.4414062e-04   6.1035156e-04   3.0517578e-04   4.2724609e-04   3.9672852e-04   4.5776367e-04   4.2724609e-04   3.6621094e-04   4.8828125e-04   3.6621094e-04   3.6621094e-04   5.1879883e-04   1.8310547e-04   4.2724609e-04   1.8310547e-04   5.1879883e-04   9.1552734e-05   4.2724609e-04   9.1552734e-05   4.8828125e-04   9.1552734e-05   3.0517578e-04   2.4414062e-04   1.5258789e-04   1.8310547e-04  -3.0517578e-05   3.0517578e-04   9.1552734e-05   1.8310547e-04  -9.1552734e-05   2.7465820e-04   0.0000000e+00   6.1035156e-05  -1.5258789e-04   6.1035156e-05  -9.1552734e-05  -9.1552734e-05   2.4414062e-04  -2.1362305e-04   9.1552734e-05  -2.4414062e-04   6.1035156e-05  -9.1552734e-05  -3.0517578e-04   3.0517578e-05   3.0517578e-05  -3.6621094e-04   9.1552734e-05  -1.2207031e-04  -1.5258789e-04  -6.1035156e-05  -2.7465820e-04  -1.2207031e-04   9.1552734e-05  -9.1552734e-05  -3.9672852e-04   3.0517578e-05  -1.2207031e-04  -9.1552734e-05  -9.1552734e-05  -1.2207031e-04   2.1362305e-04  -4.5776367e-04   1.5258789e-04  -2.1362305e-04   1.2207031e-04  -3.3569336e-04   3.0517578e-04  -4.5776367e-04   9.1552734e-05  -9.1552734e-05   1.5258789e-04  -3.6621094e-04  -1.5258789e-04  -3.0517578e-05  -1.8310547e-04  -1.5258789e-04   3.0517578e-05  -2.4414062e-04  -1.2207031e-04   1.2207031e-04  -3.9672852e-04   1.2207031e-04  -3.6621094e-04   9.1552734e-05  -2.7465820e-04  -1.2207031e-04  -9.1552734e-05  -2.7465820e-04  -3.0517578e-05  -2.4414062e-04  -1.5258789e-04  -3.0517578e-05  -2.1362305e-04  -1.5258789e-04  -3.0517578e-04  -1.2207031e-04  -1.5258789e-04  -2.7465820e-04  -6.1035156e-05  -2.1362305e-04  -9.1552734e-05  -3.0517578e-04   6.1035156e-05  -3.3569336e-04  -1.8310547e-04  -2.4414062e-04  -1.8310547e-04  -1.2207031e-04  -1.5258789e-04  -3.0517578e-05  -3.9672852e-04   1.2207031e-04  -4.2724609e-04  -3.0517578e-05   0.0000000e+00  -2.7465820e-04  -2.4414062e-04  -1.5258789e-04  -1.5258789e-04  -2.1362305e-04   1.2207031e-04  -3.0517578e-04  -3.0517578e-04  -9.1552734e-05  -3.3569336e-04  -4.2724609e-04   6.1035156e-05  -2.7465820e-04  -1.5258789e-04  -2.7465820e-04  -2.1362305e-04   9.1552734e-05  -4.8828125e-04  -3.3569336e-04   0.0000000e+00  -3.9672852e-04  -1.2207031e-04  -3.9672852e-04  -9.1552734e-05  -3.0517578e-04  -2.4414062e-04  -1.2207031e-04  -4.8828125e-04  -2.7465820e-04  -9.1552734e-05  -2.7465820e-04  -2.7465820e-04  -2.1362305e-04  -4.2724609e-04  -1.5258789e-04  -2.4414062e-04   0.0000000e+00  -1.8310547e-04  -9.1552734e-05  -2.4414062e-04  -9.1552734e-05  -2.7465820e-04   9.1552734e-05  -3.6621094e-04   1.2207031e-04  -2.1362305e-04  -3.0517578e-05  -9.1552734e-05   1.2207031e-04  -2.1362305e-04   1.2207031e-04  -2.4414062e-04   1.8310547e-04  -9.1552734e-05   0.0000000e+00   1.5258789e-04  -1.5258789e-04   1.2207031e-04   9.1552734e-05  -2.1362305e-04   1.8310547e-04  -1.2207031e-04   1.5258789e-04  -6.1035156e-05   6.1035156e-05  -3.0517578e-05   1.8310547e-04  -1.8310547e-04   1.5258789e-04  -1.5258789e-04   6.1035156e-05   9.1552734e-05  -1.5258789e-04  -3.0517578e-05   3.0517578e-05  -3.0517578e-05  -1.2207031e-04  -1.5258789e-04  -6.1035156e-05  -3.0517578e-05  -2.7465820e-04  -1.8310547e-04  -1.2207031e-04  -1.8310547e-04  -2.1362305e-04  -1.5258789e-04  -1.8310547e-04  -1.8310547e-04  -3.0517578e-04  -1.8310547e-04   0.0000000e+00  -3.0517578e-04  -2.4414062e-04  -9.1552734e-05  -5.4931641e-04   6.1035156e-05  -2.1362305e-04  -3.9672852e-04  -2.7465820e-04  -3.0517578e-05  -3.9672852e-04  -1.8310547e-04  -3.0517578e-04   6.1035156e-05  -3.6621094e-04  -3.0517578e-05  -3.6621094e-04   6.1035156e-05  -3.9672852e-04  -3.0517578e-05  -2.4414062e-04  -1.2207031e-04  -3.0517578e-05  -6.1035156e-05  -1.2207031e-04  -9.1552734e-05  -9.1552734e-05   3.0517578e-05  -3.3569336e-04   2.1362305e-04  -1.8310547e-04   1.2207031e-04   3.0517578e-05  -1.8310547e-04   3.0517578e-05   0.0000000e+00   3.0517578e-05   9.1552734e-05   0.0000000e+00   9.1552734e-05   1.5258789e-04  -3.9672852e-04   1.8310547e-04   9.1552734e-05   6.1035156e-05  -3.0517578e-05   3.0517578e-05   3.0517578e-05   1.8310547e-04   6.1035156e-05  -1.2207031e-04  -3.0517578e-05   1.2207031e-04   1.8310547e-04   1.8310547e-04  -9.1552734e-05   3.0517578e-05   2.4414062e-04  -9.1552734e-05   3.0517578e-05   2.7465820e-04  -2.1362305e-04   1.8310547e-04  -6.1035156e-05   1.2207031e-04   9.1552734e-05   3.0517578e-05   6.1035156e-05   1.2207031e-04   6.1035156e-05   0.0000000e+00   2.1362305e-04   1.5258789e-04  -6.1035156e-05   3.3569336e-04   1.2207031e-04   1.8310547e-04   3.0517578e-05   0.0000000e+00   4.2724609e-04   6.1035156e-05   1.2207031e-04   3.3569336e-04   1.5258789e-04   1.5258789e-04   9.1552734e-05   2.1362305e-04   2.4414062e-04   2.7465820e-04   3.0517578e-05   4.8828125e-04   3.0517578e-05   1.5258789e-04   1.8310547e-04  -3.0517578e-05   3.0517578e-04  -3.0517578e-05   4.8828125e-04  -6.1035156e-05   3.0517578e-04  -1.2207031e-04   5.1879883e-04   1.5258789e-04   9.1552734e-05   1.8310547e-04   4.2724609e-04   3.0517578e-05   2.1362305e-04   0.0000000e+00   6.7138672e-04  -1.8310547e-04   1.8310547e-04   2.4414062e-04   2.4414062e-04   2.1362305e-04   6.1035156e-05   2.7465820e-04   6.1035156e-05   2.4414062e-04  -1.2207031e-04   8.5449219e-04   0.0000000e+00   3.9672852e-04   3.0517578e-04   3.6621094e-04   2.4414062e-04   3.6621094e-04   4.2724609e-04   1.8310547e-04   0.0000000e+00   6.1035156e-04   2.1362305e-04   4.2724609e-04   2.1362305e-04   3.9672852e-04   5.1879883e-04   2.4414062e-04   3.3569336e-04   5.4931641e-04   1.2207031e-04   4.2724609e-04   4.5776367e-04   1.8310547e-04   5.1879883e-04   3.0517578e-04   2.4414062e-04   4.8828125e-04   4.8828125e-04   2.4414062e-04   5.4931641e-04  -3.0517578e-05   3.9672852e-04   2.4414062e-04   3.0517578e-04   2.7465820e-04   2.1362305e-04   5.7983398e-04  -1.5258789e-04   3.3569336e-04   2.7465820e-04   9.1552734e-05   1.5258789e-04   1.2207031e-04   3.0517578e-05   9.1552734e-05   1.8310547e-04  -9.1552734e-05   6.1035156e-05  -3.0517578e-05  -1.2207031e-04   2.1362305e-04  -2.1362305e-04   1.8310547e-04  -2.1362305e-04   1.2207031e-04  -6.1035156e-05  -3.0517578e-05  -3.0517578e-05  -3.0517578e-05  -6.1035156e-05  -6.1035156e-05  -2.1362305e-04   0.0000000e+00  -3.0517578e-05   9.1552734e-05  -1.5258789e-04  -1.2207031e-04   0.0000000e+00  -3.0517578e-05   1.2207031e-04   3.0517578e-05  -2.1362305e-04   2.4414062e-04  -9.1552734e-05  -9.1552734e-05   6.1035156e-05  -3.0517578e-05   1.5258789e-04  -1.8310547e-04   9.1552734e-05   3.0517578e-05   6.1035156e-05   1.5258789e-04  -6.1035156e-05  -9.1552734e-05   1.2207031e-04   3.0517578e-05   6.1035156e-05  -6.1035156e-05   3.0517578e-05  -1.2207031e-04   3.3569336e-04  -1.2207031e-04  -9.1552734e-05   9.1552734e-05  -3.0517578e-05  -6.1035156e-05  -1.8310547e-04   1.2207031e-04  -2.4414062e-04   1.5258789e-04  -9.1552734e-05  -9.1552734e-05  -1.2207031e-04  -1.8310547e-04  -9.1552734e-05  -1.8310547e-04  -1.5258789e-04  -6.1035156e-05  -3.6621094e-04   2.4414062e-04  -4.2724609e-04   1.8310547e-04  -3.9672852e-04  -6.1035156e-05  -1.5258789e-04  -2.1362305e-04  -1.5258789e-04  -2.1362305e-04  -4.2724609e-04   1.2207031e-04  -3.3569336e-04  -2.1362305e-04  -1.5258789e-04  -1.8310547e-04  -2.4414062e-04  -9.1552734e-05  -1.2207031e-04  -9.1552734e-05  -1.8310547e-04  -3.0517578e-04  -3.0517578e-04   1.2207031e-04  -2.1362305e-04   0.0000000e+00  -1.5258789e-04  -2.7465820e-04  -1.2207031e-04  -9.1552734e-05  -1.8310547e-04   0.0000000e+00  -2.7465820e-04  -2.4414062e-04   3.0517578e-05  -2.1362305e-04  -1.5258789e-04  -9.1552734e-05  -1.2207031e-04  -2.4414062e-04   2.1362305e-04  -6.4086914e-04   1.2207031e-04  -2.4414062e-04  -1.2207031e-04  -2.7465820e-04  -1.5258789e-04  -2.7465820e-04   3.0517578e-05  -3.0517578e-04  -1.5258789e-04  -1.8310547e-04   0.0000000e+00  -4.8828125e-04   2.4414062e-04  -2.1362305e-04  -3.0517578e-04   0.0000000e+00  -3.0517578e-04  -2.1362305e-04  -6.1035156e-05  -6.1035156e-05  -3.0517578e-04   9.1552734e-05  -3.6621094e-04   6.1035156e-05  -3.0517578e-04  -1.8310547e-04   1.8310547e-04  -3.0517578e-04  -6.1035156e-05   3.0517578e-05  -2.4414062e-04   0.0000000e+00   0.0000000e+00  -1.5258789e-04   6.1035156e-05  -3.3569336e-04   1.2207031e-04  -2.1362305e-04   9.1552734e-05  -3.9672852e-04   1.2207031e-04   6.1035156e-05  -3.0517578e-05  -9.1552734e-05   3.0517578e-05  -2.1362305e-04   0.0000000e+00   3.0517578e-05  -1.8310547e-04   3.3569336e-04  -4.5776367e-04   3.6621094e-04  -3.3569336e-04   6.1035156e-05  -4.8828125e-04   2.7465820e-04  -3.3569336e-04  -9.1552734e-05   0.0000000e+00  -1.8310547e-04  -1.2207031e-04  -3.3569336e-04  -3.0517578e-05  -2.7465820e-04  -9.1552734e-05  -1.5258789e-04  -2.4414062e-04  -1.5258789e-04  -1.8310547e-04  -4.2724609e-04  -3.0517578e-05  -3.6621094e-04  -2.7465820e-04   3.0517578e-05  -3.0517578e-04  -3.0517578e-05  -2.7465820e-04  -1.5258789e-04  -3.3569336e-04  -9.1552734e-05  -3.3569336e-04  -3.0517578e-05  -2.7465820e-04  -3.0517578e-05  -1.2207031e-04  -1.5258789e-04  -3.0517578e-05  -9.1552734e-05  -1.5258789e-04  -3.0517578e-05  -1.5258789e-04   3.0517578e-05  -2.1362305e-04   9.1552734e-05  -1.2207031e-04  -9.1552734e-05   6.1035156e-05  -3.0517578e-05  -1.5258789e-04   6.1035156e-05   1.5258789e-04   6.1035156e-05  -9.1552734e-05   6.1035156e-05   6.1035156e-05  -3.0517578e-05   2.1362305e-04   0.0000000e+00  -9.1552734e-05   1.5258789e-04   1.8310547e-04  -1.2207031e-04   9.1552734e-05   9.1552734e-05  -6.1035156e-05   2.4414062e-04  -2.4414062e-04  -1.5258789e-04   1.5258789e-04   6.1035156e-05   3.0517578e-05  -3.0517578e-05  -6.1035156e-05   2.7465820e-04  -3.6621094e-04   2.1362305e-04  -1.5258789e-04   6.1035156e-05  -2.4414062e-04   9.1552734e-05  -1.5258789e-04   1.2207031e-04   0.0000000e+00  -1.8310547e-04   0.0000000e+00  -3.0517578e-05   6.1035156e-05   6.1035156e-05  -9.1552734e-05   6.1035156e-05  -1.8310547e-04   3.9672852e-04  -1.8310547e-04  -2.7465820e-04   3.6621094e-04  -3.0517578e-05  -1.5258789e-04   9.1552734e-05   1.2207031e-04   9.1552734e-05   0.0000000e+00   1.5258789e-04   1.2207031e-04   9.1552734e-05   2.7465820e-04   2.1362305e-04   0.0000000e+00   3.6621094e-04   2.1362305e-04  -2.4414062e-04   2.7465820e-04   1.2207031e-04   1.2207031e-04   1.8310547e-04   3.0517578e-05   2.4414062e-04  -3.0517578e-05   2.1362305e-04   4.8828125e-04   1.2207031e-04  -9.1552734e-05   3.9672852e-04  -1.2207031e-04   7.0190430e-04  -3.0517578e-04   3.3569336e-04  -6.1035156e-05   3.3569336e-04   1.5258789e-04   3.6621094e-04  -1.5258789e-04   2.1362305e-04   2.1362305e-04   1.5258789e-04   2.7465820e-04   1.8310547e-04   9.1552734e-05   1.2207031e-04  -3.0517578e-05   1.8310547e-04   3.6621094e-04   1.5258789e-04   6.1035156e-05   2.4414062e-04   3.0517578e-04  -6.1035156e-05   4.8828125e-04   0.0000000e+00   4.2724609e-04  -6.1035156e-05   5.7983398e-04  -6.1035156e-05   5.1879883e-04   0.0000000e+00   3.9672852e-04   2.4414062e-04   2.4414062e-04   3.9672852e-04   1.8310547e-04   9.1552734e-05   3.9672852e-04   1.8310547e-04   4.5776367e-04  -3.0517578e-05   4.2724609e-04   0.0000000e+00   4.8828125e-04   1.5258789e-04   1.8310547e-04   1.8310547e-04   1.8310547e-04   3.9672852e-04  -6.1035156e-05   5.4931641e-04   0.0000000e+00   3.9672852e-04   3.0517578e-05   2.1362305e-04   9.1552734e-05   1.2207031e-04  -3.0517578e-05   2.7465820e-04  -6.1035156e-05   3.6621094e-04   6.1035156e-05   1.5258789e-04  -1.2207031e-04   1.8310547e-04  -3.0517578e-05   3.0517578e-05   9.1552734e-05   1.5258789e-04  -6.1035156e-05   6.1035156e-05   2.1362305e-04  -2.1362305e-04   2.7465820e-04  -1.5258789e-04   2.7465820e-04   3.0517578e-05  -1.2207031e-04   3.6621094e-04  -3.0517578e-04   5.4931641e-04  -3.9672852e-04   6.1035156e-05   2.1362305e-04   1.8310547e-04  -1.8310547e-04   2.1362305e-04   3.0517578e-05   1.2207031e-04   6.1035156e-05   2.7465820e-04   9.1552734e-05   1.8310547e-04   1.8310547e-04   1.2207031e-04   6.1035156e-05   1.8310547e-04  -3.0517578e-05   2.1362305e-04   0.0000000e+00   1.5258789e-04   6.1035156e-05   1.8310547e-04   2.4414062e-04   1.2207031e-04  -3.0517578e-05   2.7465820e-04   1.5258789e-04  -6.1035156e-05  -3.0517578e-05   3.9672852e-04  -1.8310547e-04   9.1552734e-05  -1.8310547e-04   1.2207031e-04  -1.2207031e-04   1.5258789e-04  -1.8310547e-04   1.2207031e-04  -2.7465820e-04   0.0000000e+00  -1.5258789e-04   9.1552734e-05  -3.0517578e-04  -1.8310547e-04  -2.7465820e-04   1.2207031e-04  -3.0517578e-04  -2.4414062e-04  -3.0517578e-05  -5.1879883e-04   1.8310547e-04  -4.2724609e-04  -9.1552734e-05  -2.4414062e-04  -2.4414062e-04  -6.1035156e-05  -1.8310547e-04  -1.5258789e-04  -2.1362305e-04   6.1035156e-05  -3.9672852e-04  -3.0517578e-05  -2.4414062e-04  -1.2207031e-04  -3.3569336e-04   2.4414062e-04  -3.6621094e-04  -1.5258789e-04   0.0000000e+00  -1.8310547e-04  -3.0517578e-05  -1.2207031e-04  -3.0517578e-05  -5.1879883e-04   3.9672852e-04  -3.3569336e-04  -3.0517578e-05  -2.4414062e-04   6.1035156e-05  -6.1035156e-05   1.2207031e-04  -3.0517578e-04  -1.8310547e-04   2.1362305e-04  -4.2724609e-04   1.2207031e-04  -1.5258789e-04  -2.1362305e-04  -6.1035156e-05  -6.1035156e-05   0.0000000e+00  -1.8310547e-04   1.2207031e-04  -4.8828125e-04   9.1552734e-05  -9.1552734e-05   9.1552734e-05  -2.1362305e-04  -2.1362305e-04   0.0000000e+00  -9.1552734e-05  -1.8310547e-04  -1.5258789e-04  -1.2207031e-04  -9.1552734e-05  -2.1362305e-04   6.1035156e-05  -2.1362305e-04  -1.5258789e-04  -9.1552734e-05  -6.1035156e-05  -1.2207031e-04   6.1035156e-05  -2.7465820e-04   0.0000000e+00  -1.5258789e-04   0.0000000e+00  -2.4414062e-04   0.0000000e+00  -1.8310547e-04  -1.5258789e-04   0.0000000e+00  -2.1362305e-04   3.0517578e-05  -1.5258789e-04  -2.7465820e-04   6.1035156e-05  -1.8310547e-04  -9.1552734e-05   3.0517578e-05   1.5258789e-04  -1.8310547e-04  -6.1035156e-05  -6.1035156e-05   6.1035156e-05  -1.8310547e-04  -6.1035156e-05   1.2207031e-04  -3.6621094e-04  -6.1035156e-05  -2.4414062e-04  -9.1552734e-05  -9.1552734e-05  -1.8310547e-04  -6.1035156e-05  -2.4414062e-04   1.5258789e-04  -2.7465820e-04   0.0000000e+00  -2.4414062e-04   0.0000000e+00  -1.2207031e-04  -9.1552734e-05  -1.2207031e-04  -9.1552734e-05  -2.4414062e-04  -3.0517578e-04   3.0517578e-05  -4.2724609e-04   0.0000000e+00  -1.8310547e-04  -2.4414062e-04  -1.2207031e-04  -2.4414062e-04   0.0000000e+00  -3.0517578e-04  -3.0517578e-05  -2.4414062e-04  -1.8310547e-04   3.0517578e-05   1.2207031e-04  -3.3569336e-04   1.5258789e-04   3.0517578e-05  -1.5258789e-04  -3.0517578e-05  -2.4414062e-04   3.0517578e-04  -9.1552734e-05  -9.1552734e-05   0.0000000e+00  -9.1552734e-05   1.8310547e-04  -1.5258789e-04  -9.1552734e-05   2.7465820e-04  -9.1552734e-05   0.0000000e+00  -9.1552734e-05   2.7465820e-04   9.1552734e-05   0.0000000e+00  -6.1035156e-05   3.0517578e-05   1.8310547e-04   2.4414062e-04  -2.7465820e-04   6.1035156e-05  -2.1362305e-04   4.2724609e-04  -2.1362305e-04   3.0517578e-05  -3.0517578e-05  -9.1552734e-05   6.1035156e-05  -3.0517578e-05   6.1035156e-05  -1.5258789e-04  -6.1035156e-05  -9.1552734e-05   6.1035156e-05  -1.2207031e-04  -9.1552734e-05  -1.2207031e-04  -6.1035156e-05   0.0000000e+00  -9.1552734e-05   0.0000000e+00  -1.8310547e-04   9.1552734e-05  -9.1552734e-05  -1.2207031e-04   3.0517578e-05  -1.2207031e-04  -1.2207031e-04  -1.8310547e-04  -9.1552734e-05  -6.1035156e-05  -3.0517578e-05  -3.0517578e-05   0.0000000e+00   6.1035156e-05  -2.4414062e-04   1.5258789e-04  -9.1552734e-05   9.1552734e-05  -1.2207031e-04   3.0517578e-04  -2.1362305e-04   2.7465820e-04   9.1552734e-05   1.2207031e-04  -6.1035156e-05   3.0517578e-05   1.2207031e-04   3.0517578e-05  -9.1552734e-05   1.2207031e-04   2.1362305e-04   1.5258789e-04   6.1035156e-05  -6.1035156e-05   1.8310547e-04   9.1552734e-05   2.4414062e-04   0.0000000e+00   2.4414062e-04   9.1552734e-05   3.0517578e-04   1.8310547e-04   1.2207031e-04   3.6621094e-04   0.0000000e+00   1.5258789e-04   3.0517578e-05   2.7465820e-04   3.0517578e-05  -1.2207031e-04   2.7465820e-04  -9.1552734e-05   2.1362305e-04   2.4414062e-04   9.1552734e-05   9.1552734e-05   1.2207031e-04   2.7465820e-04   2.4414062e-04   0.0000000e+00   2.4414062e-04   2.1362305e-04  -1.2207031e-04   3.3569336e-04  -6.1035156e-05   3.9672852e-04  -1.5258789e-04   2.4414062e-04   2.4414062e-04   1.2207031e-04   6.1035156e-05   2.1362305e-04  -1.2207031e-04   3.9672852e-04   1.5258789e-04   1.8310547e-04   6.1035156e-05   2.7465820e-04   1.8310547e-04   2.1362305e-04   2.1362305e-04   9.1552734e-05   1.2207031e-04   3.3569336e-04   2.4414062e-04   2.7465820e-04   2.1362305e-04   6.1035156e-05   2.1362305e-04   3.9672852e-04   9.1552734e-05   9.1552734e-05   1.5258789e-04   2.4414062e-04   9.1552734e-05   2.1362305e-04   9.1552734e-05   1.8310547e-04   3.0517578e-05   1.8310547e-04   1.8310547e-04   9.1552734e-05   0.0000000e+00   1.8310547e-04   1.8310547e-04   2.1362305e-04   1.5258789e-04  -6.1035156e-05   3.0517578e-04  -1.5258789e-04   2.1362305e-04   3.0517578e-05   9.1552734e-05   2.7465820e-04  -9.1552734e-05   0.0000000e+00   6.1035156e-05  -3.0517578e-05   6.1035156e-05   3.3569336e-04   6.1035156e-05   1.2207031e-04   9.1552734e-05   1.2207031e-04   9.1552734e-05   0.0000000e+00   9.1552734e-05   1.2207031e-04   4.2724609e-04  -3.0517578e-05   2.1362305e-04   2.4414062e-04   9.1552734e-05   2.1362305e-04   1.8310547e-04   2.1362305e-04   0.0000000e+00   4.2724609e-04   3.0517578e-05   3.0517578e-05   2.7465820e-04   1.8310547e-04  -9.1552734e-05   1.2207031e-04   2.1362305e-04   1.2207031e-04   3.3569336e-04  -1.5258789e-04   3.9672852e-04  -1.5258789e-04  -3.0517578e-05   3.3569336e-04  -3.0517578e-05   3.0517578e-05  -2.1362305e-04   1.8310547e-04   0.0000000e+00  -6.1035156e-05   3.0517578e-05   0.0000000e+00  -6.1035156e-05  -6.1035156e-05  -3.0517578e-05  -9.1552734e-05  -3.0517578e-05  -2.1362305e-04   3.0517578e-05  -3.3569336e-04  -9.1552734e-05   6.1035156e-05  -3.3569336e-04   2.1362305e-04  -3.0517578e-04  -9.1552734e-05  -9.1552734e-05  -3.0517578e-04   1.8310547e-04  -2.7465820e-04  -1.2207031e-04  -1.5258789e-04  -2.4414062e-04  -6.1035156e-05  -1.2207031e-04  -9.1552734e-05  -3.0517578e-05  -3.3569336e-04   6.1035156e-05  -3.6621094e-04  -3.0517578e-05  -1.8310547e-04   9.1552734e-05   3.0517578e-05  -1.2207031e-04  -1.8310547e-04   2.4414062e-04  -2.4414062e-04  -1.2207031e-04  -3.0517578e-05   3.0517578e-05  -6.1035156e-05   0.0000000e+00  -3.0517578e-05  -1.2207031e-04  -6.1035156e-05  -9.1552734e-05   1.8310547e-04  -3.9672852e-04   1.8310547e-04  -3.0517578e-04   6.1035156e-05  -1.2207031e-04  -3.0517578e-05  -6.1035156e-05   9.1552734e-05  -1.2207031e-04  -1.5258789e-04   1.5258789e-04  -1.8310547e-04  -9.1552734e-05  -6.1035156e-05  -3.9672852e-04   6.1035156e-05  -2.1362305e-04  -3.0517578e-05   0.0000000e+00  -4.2724609e-04   1.2207031e-04  -3.9672852e-04  -3.0517578e-05  -6.1035156e-05  -2.4414062e-04  -2.1362305e-04   0.0000000e+00  -1.8310547e-04  -1.5258789e-04  -6.1035156e-05   9.1552734e-05  -1.8310547e-04  -2.7465820e-04  -1.8310547e-04  -3.0517578e-05   3.0517578e-05  -1.5258789e-04  -1.8310547e-04   1.2207031e-04  -9.1552734e-05  -1.5258789e-04  -3.3569336e-04  -1.2207031e-04   9.1552734e-05  -9.1552734e-05  -2.7465820e-04  -6.1035156e-05   0.0000000e+00  -3.0517578e-05  -6.1035156e-05  -3.0517578e-05   0.0000000e+00  -2.4414062e-04   1.2207031e-04  -3.9672852e-04   1.2207031e-04  -2.7465820e-04   0.0000000e+00  -9.1552734e-05   1.2207031e-04  -1.5258789e-04  -2.4414062e-04   3.0517578e-05  -2.1362305e-04   0.0000000e+00  -1.5258789e-04   6.1035156e-05  -1.2207031e-04  -6.1035156e-05  -2.1362305e-04  -6.1035156e-05  -3.3569336e-04   1.2207031e-04  -2.7465820e-04   1.8310547e-04  -3.3569336e-04   3.3569336e-04  -3.6621094e-04   3.0517578e-05  -3.3569336e-04   3.0517578e-05  -3.0517578e-05  -3.0517578e-04   0.0000000e+00  -9.1552734e-05  -9.1552734e-05  -1.5258789e-04  -1.2207031e-04   9.1552734e-05  -9.1552734e-05   3.0517578e-05  -3.0517578e-05   0.0000000e+00  -2.7465820e-04  -9.1552734e-05   6.1035156e-05  -6.1035156e-05   6.1035156e-05   1.2207031e-04  -2.7465820e-04   1.5258789e-04   1.5258789e-04  -1.2207031e-04  -1.2207031e-04  -6.1035156e-05   3.0517578e-05  -3.0517578e-05   2.7465820e-04  -4.2724609e-04   4.5776367e-04  -3.0517578e-04   1.2207031e-04   3.0517578e-05   1.5258789e-04  -1.2207031e-04  -9.1552734e-05  -6.1035156e-05  -1.2207031e-04  -6.1035156e-05   2.4414062e-04  -2.1362305e-04   0.0000000e+00  -2.4414062e-04   1.2207031e-04  -1.5258789e-04  -3.0517578e-05  -9.1552734e-05  -6.1035156e-05  -6.1035156e-05  -1.8310547e-04  -9.1552734e-05  -9.1552734e-05  -1.2207031e-04  -3.0517578e-05  -6.1035156e-05  -1.2207031e-04   1.8310547e-04  -4.5776367e-04  -3.0517578e-05  -3.3569336e-04   2.4414062e-04  -2.1362305e-04  -3.0517578e-05   0.0000000e+00   0.0000000e+00  -6.1035156e-05  -9.1552734e-05   0.0000000e+00  -9.1552734e-05   9.1552734e-05  -1.5258789e-04   3.3569336e-04  -2.7465820e-04   2.4414062e-04  -1.5258789e-04  -3.0517578e-05   1.8310547e-04   1.8310547e-04  -4.5776367e-04   5.7983398e-04  -4.5776367e-04   4.8828125e-04  -6.1035156e-05   3.0517578e-05  -3.0517578e-05   2.7465820e-04  -3.0517578e-05   2.7465820e-04   9.1552734e-05   2.1362305e-04   1.2207031e-04   6.1035156e-05   6.1035156e-05   3.9672852e-04   0.0000000e+00   0.0000000e+00   3.0517578e-05   9.1552734e-05   0.0000000e+00   3.0517578e-04  -1.2207031e-04   3.0517578e-04  -1.2207031e-04   1.2207031e-04   6.1035156e-05   2.1362305e-04   3.0517578e-05   9.1552734e-05   9.1552734e-05   0.0000000e+00   2.7465820e-04  -6.1035156e-05   9.1552734e-05   3.6621094e-04  -2.4414062e-04   6.1035156e-05   0.0000000e+00   1.2207031e-04   3.0517578e-05  -1.5258789e-04   1.5258789e-04   1.5258789e-04   1.2207031e-04   3.0517578e-05   6.1035156e-05   2.7465820e-04   0.0000000e+00   2.1362305e-04   1.2207031e-04   9.1552734e-05   2.4414062e-04   3.0517578e-05   2.4414062e-04   1.5258789e-04   9.1552734e-05   2.7465820e-04   6.1035156e-05   3.0517578e-04   0.0000000e+00   3.0517578e-05   2.4414062e-04   1.5258789e-04   2.1362305e-04   1.5258789e-04   1.2207031e-04   3.3569336e-04  -3.0517578e-05   4.8828125e-04  -1.2207031e-04   6.4086914e-04  -2.7465820e-04   5.1879883e-04   0.0000000e+00  -3.0517578e-05   2.1362305e-04   2.7465820e-04  -3.0517578e-05   1.5258789e-04   1.2207031e-04   1.2207031e-04   0.0000000e+00  -3.0517578e-05   3.3569336e-04   0.0000000e+00  -6.1035156e-05   2.4414062e-04   1.2207031e-04   1.8310547e-04   9.1552734e-05   1.2207031e-04   0.0000000e+00   2.4414062e-04   1.5258789e-04   9.1552734e-05   3.0517578e-05   1.2207031e-04   1.8310547e-04  -6.1035156e-05   2.1362305e-04   2.1362305e-04   2.4414062e-04   3.0517578e-05   1.8310547e-04  -1.2207031e-04   1.8310547e-04   2.4414062e-04   0.0000000e+00   2.7465820e-04  -1.2207031e-04   2.1362305e-04   1.2207031e-04   1.8310547e-04   2.1362305e-04  -3.0517578e-05   2.4414062e-04   6.1035156e-05   2.1362305e-04   9.1552734e-05   3.0517578e-05   9.1552734e-05   9.1552734e-05   2.1362305e-04   1.5258789e-04  -2.1362305e-04   3.3569336e-04  -1.8310547e-04   1.2207031e-04  -1.2207031e-04   0.0000000e+00   3.0517578e-05   6.1035156e-05   0.0000000e+00  -3.0517578e-05  -3.3569336e-04   2.1362305e-04   0.0000000e+00   0.0000000e+00  -9.1552734e-05   6.1035156e-05  -1.8310547e-04   1.5258789e-04  -9.1552734e-05  -1.8310547e-04   3.0517578e-05  -1.2207031e-04  -2.1362305e-04  -6.1035156e-05  -2.4414062e-04   0.0000000e+00  -1.2207031e-04  -3.0517578e-05  -3.3569336e-04   3.0517578e-05   9.1552734e-05  -9.1552734e-05  -2.7465820e-04   9.1552734e-05  -1.5258789e-04   6.1035156e-05  -2.1362305e-04   3.3569336e-04  -3.3569336e-04   2.7465820e-04  -2.1362305e-04   1.5258789e-04  -4.2724609e-04  -6.1035156e-05   1.2207031e-04  -1.8310547e-04   9.1552734e-05   0.0000000e+00   6.1035156e-05  -2.7465820e-04   6.1035156e-05   3.0517578e-05   3.0517578e-05   9.1552734e-05  -1.5258789e-04   1.8310547e-04  -2.4414062e-04   1.2207031e-04  -1.5258789e-04   2.1362305e-04   6.1035156e-05  -2.7465820e-04   1.2207031e-04  -1.5258789e-04   9.1552734e-05  -1.2207031e-04  -3.0517578e-04  -3.0517578e-05  -1.5258789e-04  -3.0517578e-05   6.1035156e-05  -2.4414062e-04  -2.1362305e-04   9.1552734e-05  -1.2207031e-04  -3.6621094e-04   2.1362305e-04  -4.2724609e-04   3.0517578e-05  -3.6621094e-04  -9.1552734e-05   3.0517578e-05  -3.0517578e-04   1.2207031e-04  -5.1879883e-04   1.2207031e-04  -2.4414062e-04  -1.2207031e-04  -2.4414062e-04  -1.2207031e-04   3.0517578e-05  -2.4414062e-04  -1.2207031e-04  -2.1362305e-04   1.5258789e-04  -3.3569336e-04   3.0517578e-05  -3.0517578e-05  -3.0517578e-04   1.5258789e-04  -3.9672852e-04   2.7465820e-04  -1.5258789e-04  -6.1035156e-05  -3.0517578e-04   1.2207031e-04  -2.4414062e-04  -1.5258789e-04  -6.1035156e-05  -1.5258789e-04   6.1035156e-05  -2.1362305e-04   0.0000000e+00  -9.1552734e-05  -6.1035156e-05  -1.2207031e-04  -2.1362305e-04  -3.0517578e-05   6.1035156e-05   2.1362305e-04  -1.8310547e-04   2.1362305e-04  -3.3569336e-04   9.1552734e-05  -1.2207031e-04  -9.1552734e-05  -6.1035156e-05  -2.7465820e-04   9.1552734e-05  -2.1362305e-04  -1.5258789e-04   1.2207031e-04  -1.8310547e-04  -2.1362305e-04  -1.5258789e-04  -6.1035156e-05   3.0517578e-05   1.5258789e-04  -3.9672852e-04   1.8310547e-04  -3.6621094e-04  -3.0517578e-05  -1.8310547e-04   3.0517578e-05  -2.1362305e-04   9.1552734e-05  -1.8310547e-04   9.1552734e-05   3.0517578e-05  -3.9672852e-04   3.0517578e-05  -6.1035156e-05  -3.0517578e-05  -1.5258789e-04   3.0517578e-05  -3.0517578e-05   0.0000000e+00  -3.0517578e-05  -9.1552734e-05   1.8310547e-04  -1.2207031e-04  -6.1035156e-05   3.0517578e-05  -1.2207031e-04   6.1035156e-05   3.0517578e-05  -6.1035156e-05  -1.5258789e-04   1.8310547e-04  -2.4414062e-04   2.1362305e-04  -1.5258789e-04  -1.2207031e-04   9.1552734e-05  -9.1552734e-05  -1.8310547e-04   9.1552734e-05  -3.0517578e-04  -9.1552734e-05  -1.2207031e-04   3.0517578e-05  -1.5258789e-04  -9.1552734e-05   3.0517578e-05  -2.7465820e-04   9.1552734e-05  -2.1362305e-04   0.0000000e+00  -6.1035156e-05  -1.2207031e-04   0.0000000e+00  -1.8310547e-04  -2.7465820e-04  -6.1035156e-05   0.0000000e+00  -1.5258789e-04  -1.5258789e-04  -6.1035156e-05   6.1035156e-05  -1.8310547e-04   2.7465820e-04  -4.5776367e-04   1.2207031e-04   0.0000000e+00   0.0000000e+00   0.0000000e+00   0.0000000e+00   1.2207031e-04   1.5258789e-04  -2.1362305e-04   6.1035156e-05   3.0517578e-05   9.1552734e-05   3.0517578e-05   9.1552734e-05   9.1552734e-05   1.2207031e-04  -3.0517578e-05  -1.5258789e-04   2.7465820e-04  -1.5258789e-04   3.6621094e-04  -3.3569336e-04   1.8310547e-04   1.5258789e-04   1.5258789e-04  -9.1552734e-05   3.0517578e-05   1.5258789e-04  -3.0517578e-05   1.2207031e-04   1.8310547e-04   2.4414062e-04  -2.1362305e-04   1.5258789e-04   0.0000000e+00   9.1552734e-05  -1.2207031e-04   6.1035156e-05   6.1035156e-05  -2.1362305e-04   2.1362305e-04   1.5258789e-04  -6.1035156e-05   1.2207031e-04  -9.1552734e-05   1.2207031e-04   1.8310547e-04  -9.1552734e-05   9.1552734e-05  -1.2207031e-04   3.0517578e-05   0.0000000e+00   3.0517578e-05   2.4414062e-04  -1.8310547e-04   1.2207031e-04   6.1035156e-05   1.2207031e-04   0.0000000e+00   6.1035156e-05   1.2207031e-04   0.0000000e+00   1.2207031e-04   2.1362305e-04  -1.5258789e-04   9.1552734e-05   6.1035156e-05  -3.0517578e-05   1.5258789e-04   6.1035156e-05   6.1035156e-05  -3.0517578e-05   3.6621094e-04  -2.1362305e-04   2.7465820e-04   2.1362305e-04   1.5258789e-04  -1.5258789e-04   1.5258789e-04   3.0517578e-04   9.1552734e-05   1.2207031e-04   6.1035156e-05   1.5258789e-04   9.1552734e-05   1.8310547e-04   9.1552734e-05   2.4414062e-04   9.1552734e-05   2.7465820e-04  -9.1552734e-05   1.2207031e-04   1.5258789e-04   3.0517578e-04   0.0000000e+00   0.0000000e+00   2.7465820e-04   1.8310547e-04   9.1552734e-05   1.2207031e-04   3.0517578e-05   1.2207031e-04   3.0517578e-05   2.1362305e-04   1.2207031e-04   1.2207031e-04  -6.1035156e-05   1.5258789e-04   9.1552734e-05   9.1552734e-05   1.2207031e-04   0.0000000e+00   2.1362305e-04  -6.1035156e-05   1.5258789e-04   3.0517578e-05   1.8310547e-04   6.1035156e-05   1.5258789e-04  -1.5258789e-04   5.1879883e-04  -9.1552734e-05   3.0517578e-05   3.3569336e-04  -2.4414062e-04   3.9672852e-04  -1.2207031e-04   1.5258789e-04   6.1035156e-05   0.0000000e+00   1.5258789e-04   3.3569336e-04  -2.1362305e-04   2.4414062e-04   6.1035156e-05   1.5258789e-04   9.1552734e-05   2.4414062e-04  -9.1552734e-05   1.8310547e-04  -9.1552734e-05   1.8310547e-04   9.1552734e-05  -6.1035156e-05  -6.1035156e-05   6.1035156e-05   1.5258789e-04   1.8310547e-04  -3.0517578e-05  -1.5258789e-04   0.0000000e+00   6.1035156e-05  -1.2207031e-04   1.8310547e-04  -1.5258789e-04   1.8310547e-04  -2.4414062e-04   1.2207031e-04  -2.4414062e-04   2.4414062e-04  -3.9672852e-04   1.8310547e-04  -3.0517578e-05  -2.7465820e-04   1.8310547e-04  -3.0517578e-05  -1.2207031e-04   1.5258789e-04  -1.8310547e-04   1.8310547e-04  -2.1362305e-04  -3.0517578e-05   9.1552734e-05  -1.8310547e-04   1.2207031e-04   9.1552734e-05  -1.5258789e-04   1.8310547e-04   9.1552734e-05  -1.2207031e-04  -3.0517578e-05   1.2207031e-04   0.0000000e+00   6.1035156e-05   0.0000000e+00   6.1035156e-05   1.8310547e-04  -6.1035156e-05   0.0000000e+00   0.0000000e+00  -2.1362305e-04   3.3569336e-04  -2.4414062e-04  -6.1035156e-05  -6.1035156e-05   2.1362305e-04  -1.8310547e-04   1.8310547e-04  -1.2207031e-04   1.2207031e-04  -3.0517578e-05   1.2207031e-04  -1.5258789e-04  -9.1552734e-05  -3.0517578e-05  -6.1035156e-05   1.5258789e-04  -3.0517578e-05  -3.0517578e-05  -3.6621094e-04   0.0000000e+00  -1.5258789e-04  -3.0517578e-05  -2.4414062e-04   0.0000000e+00  -1.8310547e-04  -9.1552734e-05  -9.1552734e-05  -1.2207031e-04  -1.2207031e-04   3.0517578e-05  -9.1552734e-05  -2.7465820e-04  -1.5258789e-04   1.5258789e-04  -9.1552734e-05  -1.5258789e-04  -3.3569336e-04   3.0517578e-05   0.0000000e+00  -1.5258789e-04   0.0000000e+00  -2.7465820e-04  -6.1035156e-05  -3.0517578e-04   1.5258789e-04  -1.2207031e-04   0.0000000e+00  -9.1552734e-05   3.0517578e-05  -1.8310547e-04  -9.1552734e-05  -1.5258789e-04   6.1035156e-05  -6.1035156e-05  -1.2207031e-04   9.1552734e-05  -3.0517578e-05  -3.3569336e-04   2.1362305e-04  -2.4414062e-04   6.1035156e-05  -3.0517578e-05  -1.8310547e-04  -6.1035156e-05   9.1552734e-05  -1.8310547e-04  -3.0517578e-05   9.1552734e-05  -1.2207031e-04  -1.8310547e-04   1.2207031e-04   0.0000000e+00  -9.1552734e-05   6.1035156e-05  -1.5258789e-04  -9.1552734e-05   3.0517578e-05  -1.8310547e-04  -3.0517578e-05  -1.2207031e-04   1.2207031e-04   0.0000000e+00  -2.7465820e-04   0.0000000e+00  -1.5258789e-04  -6.1035156e-05  -2.1362305e-04   1.2207031e-04  -1.2207031e-04  -1.5258789e-04  -9.1552734e-05  -2.1362305e-04   1.2207031e-04  -9.1552734e-05  -1.2207031e-04   2.4414062e-04  -2.4414062e-04  -3.0517578e-05  -1.8310547e-04   0.0000000e+00  -3.0517578e-05   6.1035156e-05  -9.1552734e-05  -2.7465820e-04  -6.1035156e-05  -3.0517578e-05  -1.2207031e-04  -1.2207031e-04   3.0517578e-05   0.0000000e+00  -2.4414062e-04   3.6621094e-04  -5.4931641e-04   3.6621094e-04  -2.1362305e-04  -1.5258789e-04   3.0517578e-05  -9.1552734e-05   1.5258789e-04  -9.1552734e-05  -1.8310547e-04  -3.0517578e-05   1.2207031e-04  -1.5258789e-04   1.5258789e-04  -4.2724609e-04   3.0517578e-05  -1.2207031e-04   1.2207031e-04  -1.5258789e-04   2.1362305e-04  -3.6621094e-04   2.1362305e-04  -1.5258789e-04  -1.5258789e-04  -3.0517578e-04   2.4414062e-04  -2.1362305e-04   6.1035156e-05   1.5258789e-04  -3.0517578e-04  -2.1362305e-04   1.2207031e-04  -2.1362305e-04  -9.1552734e-05  -1.2207031e-04  -9.1552734e-05  -6.1035156e-05  -1.5258789e-04   0.0000000e+00   6.1035156e-05  -6.1035156e-05  -9.1552734e-05   3.0517578e-05  -2.4414062e-04   1.2207031e-04  -6.1035156e-05   1.8310547e-04   9.1552734e-05   6.1035156e-05  -1.2207031e-04   9.1552734e-05  -3.0517578e-05   6.1035156e-05  -1.2207031e-04   1.2207031e-04   6.1035156e-05   3.6621094e-04  -2.4414062e-04   2.1362305e-04  -3.0517578e-05   3.0517578e-04   0.0000000e+00  -1.2207031e-04   1.5258789e-04   1.5258789e-04   6.1035156e-05  -1.8310547e-04  -3.0517578e-05   1.2207031e-04  -6.1035156e-05   1.5258789e-04  -3.0517578e-05  -6.1035156e-05   1.5258789e-04   3.0517578e-05  -1.5258789e-04   1.5258789e-04  -6.1035156e-05   2.1362305e-04  -3.0517578e-04   2.1362305e-04   3.0517578e-05  -2.4414062e-04   1.5258789e-04   1.2207031e-04  -3.0517578e-05  -6.1035156e-05   6.1035156e-05   3.0517578e-05  -9.1552734e-05   2.1362305e-04  -3.3569336e-04   1.2207031e-04  -1.8310547e-04   1.2207031e-04  -1.2207031e-04   9.1552734e-05   0.0000000e+00   2.7465820e-04  -9.1552734e-05   1.2207031e-04   6.1035156e-05   0.0000000e+00   3.0517578e-04  -9.1552734e-05   1.2207031e-04   6.1035156e-05   1.2207031e-04  -2.4414062e-04   3.3569336e-04  -1.8310547e-04   2.4414062e-04  -6.1035156e-05   2.4414062e-04   3.0517578e-05  -9.1552734e-05   6.1035156e-05   1.8310547e-04   2.7465820e-04   2.4414062e-04   3.0517578e-05   0.0000000e+00   3.0517578e-04   1.5258789e-04   3.0517578e-05   9.1552734e-05   1.5258789e-04   1.5258789e-04  -3.0517578e-05   2.1362305e-04  -1.2207031e-04   1.2207031e-04   3.3569336e-04  -2.7465820e-04   2.4414062e-04   9.1552734e-05  -1.8310547e-04   2.7465820e-04   1.2207031e-04   3.0517578e-05   3.0517578e-04  -1.2207031e-04   2.7465820e-04   1.5258789e-04  -1.2207031e-04   3.0517578e-04   1.2207031e-04   6.1035156e-05  -1.5258789e-04   3.6621094e-04  -2.4414062e-04   6.1035156e-05   1.8310547e-04  -2.1362305e-04   4.2724609e-04  -2.1362305e-04   9.1552734e-05   9.1552734e-05   1.8310547e-04   9.1552734e-05   3.0517578e-05   1.2207031e-04  -3.0517578e-05   2.7465820e-04   9.1552734e-05   0.0000000e+00   5.1879883e-04  -3.9672852e-04   3.0517578e-04   3.0517578e-05   3.3569336e-04  -6.1035156e-05   1.5258789e-04   9.1552734e-05  -3.0517578e-05   1.5258789e-04  -3.0517578e-05  -6.1035156e-05   3.6621094e-04  -1.5258789e-04   9.1552734e-05   2.4414062e-04  -3.0517578e-05   1.2207031e-04   2.1362305e-04   2.1362305e-04  -1.5258789e-04   3.3569336e-04  -2.7465820e-04   2.4414062e-04   1.2207031e-04  -3.0517578e-05  -1.2207031e-04   0.0000000e+00   9.1552734e-05  -3.0517578e-05  -6.1035156e-05  -1.2207031e-04   2.4414062e-04  -1.2207031e-04   9.1552734e-05   6.1035156e-05  -6.1035156e-05  -3.0517578e-05   3.6621094e-04  -1.5258789e-04   9.1552734e-05   3.0517578e-05   1.2207031e-04  -1.2207031e-04  -6.1035156e-05   1.5258789e-04  -1.2207031e-04   1.5258789e-04  -9.1552734e-05  -6.1035156e-05   1.5258789e-04  -1.2207031e-04   2.1362305e-04  -1.5258789e-04   0.0000000e+00   0.0000000e+00   2.7465820e-04   6.1035156e-05   3.0517578e-05   0.0000000e+00  -6.1035156e-05   6.1035156e-05   2.7465820e-04   3.3569336e-04  -2.7465820e-04   9.1552734e-05  -1.2207031e-04   3.0517578e-05   0.0000000e+00  -6.1035156e-05  -1.5258789e-04  -9.1552734e-05   9.1552734e-05   9.1552734e-05  -3.0517578e-04  -3.0517578e-05  -1.2207031e-04   2.1362305e-04  -3.0517578e-05   0.0000000e+00  -1.5258789e-04   9.1552734e-05  -1.2207031e-04  -1.8310547e-04   6.1035156e-05   1.8310547e-04  -1.5258789e-04   1.2207031e-04  -1.8310547e-04  -6.1035156e-05  -3.0517578e-05  -1.8310547e-04  -2.7465820e-04  -1.2207031e-04  -2.1362305e-04   1.2207031e-04  -2.1362305e-04  -3.0517578e-05  -1.2207031e-04  -1.2207031e-04   0.0000000e+00  -1.5258789e-04   6.1035156e-05  -3.6621094e-04   1.8310547e-04  -2.7465820e-04   1.8310547e-04  -2.4414062e-04   9.1552734e-05  -6.1035156e-05   3.0517578e-05  -3.0517578e-05  -2.1362305e-04  -3.0517578e-05  -1.2207031e-04  -2.1362305e-04   1.2207031e-04  -1.5258789e-04  -3.0517578e-05   1.2207031e-04  -1.2207031e-04   3.0517578e-05  -6.1035156e-05   1.5258789e-04  -6.1035156e-05  -9.1552734e-05  -1.5258789e-04   1.5258789e-04   6.1035156e-05  -1.2207031e-04   6.1035156e-05  -1.8310547e-04   2.1362305e-04  -1.8310547e-04  -2.4414062e-04   0.0000000e+00   0.0000000e+00  -9.1552734e-05  -1.2207031e-04  -3.6621094e-04   2.7465820e-04  -9.1552734e-05  -1.5258789e-04  -2.7465820e-04   3.3569336e-04  -4.2724609e-04   1.2207031e-04   1.8310547e-04  -9.1552734e-05  -1.2207031e-04   0.0000000e+00  -9.1552734e-05  -3.0517578e-05  -3.6621094e-04   1.2207031e-04  -2.4414062e-04   0.0000000e+00  -9.1552734e-05  -2.1362305e-04  -9.1552734e-05  -3.0517578e-04   1.5258789e-04  -2.7465820e-04   9.1552734e-05  -1.2207031e-04   6.1035156e-05  -1.5258789e-04   0.0000000e+00   9.1552734e-05  -2.7465820e-04   9.1552734e-05  -2.1362305e-04   1.5258789e-04  -2.1362305e-04  -1.2207031e-04   0.0000000e+00   9.1552734e-05  -1.5258789e-04   1.2207031e-04  -2.1362305e-04   6.1035156e-05  -2.1362305e-04  -1.2207031e-04   3.0517578e-05   1.8310547e-04  -2.7465820e-04   1.5258789e-04  -3.0517578e-05   0.0000000e+00  -1.5258789e-04  -3.0517578e-05  -9.1552734e-05   2.1362305e-04  -6.1035156e-05  -1.2207031e-04   0.0000000e+00   6.1035156e-05  -2.7465820e-04  -6.1035156e-05  -6.1035156e-05   1.8310547e-04  -3.3569336e-04   2.4414062e-04  -3.0517578e-04   9.1552734e-05  -9.1552734e-05  -3.0517578e-05  -1.2207031e-04   6.1035156e-05  -3.6621094e-04   3.0517578e-05   1.8310547e-04  -1.5258789e-04   0.0000000e+00  -9.1552734e-05  -6.1035156e-05  -9.1552734e-05  -2.7465820e-04   1.2207031e-04   1.2207031e-04  -2.4414062e-04   3.9672852e-04  -1.8310547e-04   0.0000000e+00  -1.2207031e-04   6.1035156e-05  -2.4414062e-04   3.0517578e-04  -6.1035156e-05  -1.2207031e-04   2.7465820e-04  -3.6621094e-04   2.1362305e-04  -3.0517578e-05   0.0000000e+00   0.0000000e+00   1.5258789e-04  -6.1035156e-05   9.1552734e-05  -9.1552734e-05  -3.0517578e-05   0.0000000e+00   9.1552734e-05   0.0000000e+00  -1.2207031e-04   9.1552734e-05   3.0517578e-05   0.0000000e+00  -3.0517578e-05   3.0517578e-05  -1.5258789e-04  -9.1552734e-05   1.8310547e-04  -2.1362305e-04  -1.2207031e-04   0.0000000e+00  -3.0517578e-05  -9.1552734e-05   1.2207031e-04  -6.1035156e-05  -9.1552734e-05  -9.1552734e-05   2.4414062e-04  -2.1362305e-04   3.0517578e-05  -9.1552734e-05   3.0517578e-05  -1.2207031e-04   2.7465820e-04  -2.1362305e-04   3.0517578e-05   3.0517578e-05  -1.2207031e-04   1.5258789e-04  -1.5258789e-04   3.0517578e-05  -6.1035156e-05   4.2724609e-04  -5.4931641e-04   4.2724609e-04  -2.1362305e-04   1.8310547e-04   1.2207031e-04   0.0000000e+00  -6.1035156e-05   5.7983398e-04  -1.8310547e-04   6.1035156e-05   2.4414062e-04  -9.1552734e-05   0.0000000e+00   2.4414062e-04  -3.0517578e-05   1.2207031e-04   1.2207031e-04   3.0517578e-05   0.0000000e+00   3.9672852e-04  -1.5258789e-04  -6.1035156e-05   1.2207031e-04   1.2207031e-04   1.5258789e-04   0.0000000e+00   3.3569336e-04  -3.0517578e-05   9.1552734e-05   1.5258789e-04   3.0517578e-05  -6.1035156e-05   3.0517578e-05   3.6621094e-04  -1.8310547e-04   6.1035156e-05  -3.0517578e-05   1.2207031e-04   1.8310547e-04  -6.1035156e-05   0.0000000e+00   1.8310547e-04  -2.7465820e-04   5.1879883e-04  -2.7465820e-04   1.8310547e-04  -3.0517578e-05   6.1035156e-05  -6.1035156e-05   2.1362305e-04  -2.4414062e-04   1.8310547e-04   1.2207031e-04  -9.1552734e-05   1.5258789e-04   3.0517578e-05  -6.1035156e-05  -3.0517578e-05   9.1552734e-05   1.5258789e-04  -3.0517578e-05  -1.2207031e-04   2.7465820e-04  -3.0517578e-05   4.5776367e-04  -4.5776367e-04   4.8828125e-04  -2.1362305e-04   1.2207031e-04   2.1362305e-04  -1.2207031e-04   3.0517578e-04  -2.1362305e-04   3.0517578e-04   0.0000000e+00   3.0517578e-05  -6.1035156e-05   2.1362305e-04   2.4414062e-04  -1.8310547e-04   3.6621094e-04  -2.7465820e-04   4.5776367e-04  -1.5258789e-04   2.1362305e-04  -9.1552734e-05   2.1362305e-04   3.0517578e-05   6.1035156e-05  -9.1552734e-05   1.8310547e-04   9.1552734e-05  -1.2207031e-04   2.7465820e-04  -3.0517578e-05   2.7465820e-04  -1.2207031e-04   2.4414062e-04  -1.2207031e-04   2.1362305e-04  -3.0517578e-05   9.1552734e-05  -3.0517578e-04   3.0517578e-05   3.0517578e-05   2.4414062e-04  -1.5258789e-04   1.8310547e-04  -2.1362305e-04   3.0517578e-05  -3.0517578e-05   0.0000000e+00   9.1552734e-05  -3.0517578e-05   3.0517578e-05  -9.1552734e-05   2.1362305e-04   6.1035156e-05   1.2207031e-04   1.2207031e-04  -9.1552734e-05   9.1552734e-05  -9.1552734e-05   1.8310547e-04  -1.2207031e-04   1.5258789e-04  -2.1362305e-04   3.0517578e-04  -2.1362305e-04   1.5258789e-04   0.0000000e+00   3.0517578e-05   6.1035156e-05  -9.1552734e-05   3.0517578e-05  -1.2207031e-04   6.1035156e-05  -1.5258789e-04   1.2207031e-04   3.0517578e-05   0.0000000e+00  -1.8310547e-04   9.1552734e-05  -2.4414062e-04   1.5258789e-04  -2.4414062e-04   0.0000000e+00   6.1035156e-05  -6.1035156e-05  -6.1035156e-05  -1.8310547e-04   9.1552734e-05  -2.1362305e-04  -1.8310547e-04  -1.8310547e-04   1.5258789e-04  -2.1362305e-04  -1.2207031e-04   9.1552734e-05  -3.9672852e-04   9.1552734e-05   9.1552734e-05  -3.0517578e-05   3.0517578e-05   0.0000000e+00  -3.0517578e-04   1.5258789e-04   3.0517578e-05  -3.6621094e-04   2.7465820e-04  -3.9672852e-04   6.1035156e-05  -1.2207031e-04  -1.8310547e-04   3.0517578e-05   0.0000000e+00  -3.0517578e-05  -6.1035156e-05  -3.6621094e-04   4.2724609e-04  -3.0517578e-05   1.5258789e-04  -9.1552734e-05   6.1035156e-05  -6.1035156e-05  -1.2207031e-04   6.1035156e-05   0.0000000e+00   0.0000000e+00   3.0517578e-05  -1.2207031e-04   6.1035156e-05  -2.1362305e-04  -1.5258789e-04  -6.1035156e-05   0.0000000e+00  -9.1552734e-05   0.0000000e+00  -2.1362305e-04   1.2207031e-04  -3.0517578e-05  -3.0517578e-05  -1.2207031e-04   1.8310547e-04  -9.1552734e-05  -1.8310547e-04  -3.0517578e-05   1.5258789e-04  -9.1552734e-05  -1.2207031e-04  -3.0517578e-04   2.1362305e-04  -3.9672852e-04   1.5258789e-04  -2.7465820e-04  -1.8310547e-04  -1.2207031e-04  -1.5258789e-04   6.1035156e-05  -1.2207031e-04  -3.0517578e-05  -1.2207031e-04   1.5258789e-04  -4.2724609e-04   3.0517578e-05  -9.1552734e-05   0.0000000e+00   6.1035156e-05  -1.8310547e-04  -1.5258789e-04  -1.2207031e-04   1.2207031e-04   6.1035156e-05  -3.0517578e-04   2.1362305e-04  -4.5776367e-04   3.0517578e-05   1.2207031e-04  -1.8310547e-04  -6.1035156e-05   1.8310547e-04  -2.1362305e-04   1.2207031e-04  -3.6621094e-04   2.7465820e-04  -9.1552734e-05   9.1552734e-05   3.0517578e-05  -1.2207031e-04  -9.1552734e-05   1.5258789e-04  -1.8310547e-04  -3.0517578e-05   6.1035156e-05  -1.5258789e-04   6.1035156e-05   6.1035156e-05  -2.7465820e-04  -3.0517578e-05   1.2207031e-04  -3.0517578e-04   3.0517578e-04  -1.5258789e-04   3.0517578e-05  -3.6621094e-04  -6.1035156e-05   3.0517578e-05   9.1552734e-05  -2.1362305e-04   1.5258789e-04  -2.7465820e-04   9.1552734e-05   3.0517578e-05  -9.1552734e-05  -1.8310547e-04   1.2207031e-04  -2.1362305e-04  -3.0517578e-05   1.2207031e-04  -3.3569336e-04   2.7465820e-04  -3.3569336e-04   6.1035156e-05  -3.0517578e-05  -3.9672852e-04   4.2724609e-04  -3.0517578e-04   9.1552734e-05  -1.8310547e-04   1.8310547e-04   3.0517578e-05  -3.0517578e-04   2.4414062e-04   1.5258789e-04  -1.2207031e-04  -3.0517578e-05   3.0517578e-05  -2.4414062e-04   1.5258789e-04  -2.7465820e-04   9.1552734e-05   0.0000000e+00  -3.0517578e-05  -3.0517578e-04   2.4414062e-04  -2.4414062e-04   3.6621094e-04  -4.5776367e-04   2.4414062e-04  -1.5258789e-04   1.8310547e-04   3.0517578e-05   9.1552734e-05  -9.1552734e-05   6.1035156e-05   0.0000000e+00  -6.1035156e-05   3.3569336e-04  -1.8310547e-04  -2.7465820e-04   1.8310547e-04  -1.5258789e-04   9.1552734e-05  -1.2207031e-04  -1.2207031e-04   9.1552734e-05  -2.1362305e-04   3.0517578e-05  -1.2207031e-04   3.0517578e-04  -3.3569336e-04   1.2207031e-04  -1.5258789e-04   9.1552734e-05  -3.0517578e-05  -6.1035156e-05   1.2207031e-04   1.2207031e-04  -1.5258789e-04   1.5258789e-04  -1.8310547e-04   0.0000000e+00   1.2207031e-04   9.1552734e-05   9.1552734e-05   9.1552734e-05  -1.8310547e-04   5.1879883e-04  -2.4414062e-04   2.7465820e-04  -2.7465820e-04   3.6621094e-04  -1.5258789e-04   2.4414062e-04   6.1035156e-05  -6.1035156e-05   3.0517578e-05  -1.2207031e-04   3.6621094e-04  -1.2207031e-04   3.9672852e-04  -6.1035156e-05   3.0517578e-04  -2.1362305e-04   3.0517578e-05  -6.1035156e-05  -9.1552734e-05   1.2207031e-04   1.5258789e-04   3.0517578e-05  -9.1552734e-05   0.0000000e+00   1.5258789e-04   1.2207031e-04   2.4414062e-04  -6.1035156e-05  -3.0517578e-05   2.4414062e-04  -1.2207031e-04   2.4414062e-04  -1.5258789e-04   3.3569336e-04   3.0517578e-05   6.1035156e-05   3.0517578e-05  -1.2207031e-04   1.8310547e-04  -1.8310547e-04  -9.1552734e-05   1.8310547e-04  -1.5258789e-04  -1.2207031e-04   1.8310547e-04   9.1552734e-05  -2.1362305e-04   1.5258789e-04   1.5258789e-04   0.0000000e+00  -3.0517578e-05  -1.2207031e-04   6.1035156e-05   3.6621094e-04  -2.1362305e-04   4.5776367e-04   3.0517578e-05   9.1552734e-05  -1.2207031e-04   1.2207031e-04   9.1552734e-05   1.5258789e-04  -2.1362305e-04   3.6621094e-04  -1.8310547e-04   2.7465820e-04   6.1035156e-05   6.1035156e-05   1.2207031e-04   9.1552734e-05   1.2207031e-04   9.1552734e-05   6.1035156e-05   6.1035156e-05   3.0517578e-04  -9.1552734e-05   4.2724609e-04  -1.5258789e-04   3.0517578e-05   0.0000000e+00  -1.5258789e-04   0.0000000e+00   9.1552734e-05   2.1362305e-04  -3.0517578e-05   9.1552734e-05  -6.1035156e-05   1.8310547e-04  -1.2207031e-04   2.1362305e-04   3.0517578e-05   0.0000000e+00   1.2207031e-04   3.0517578e-05   2.1362305e-04   0.0000000e+00   0.0000000e+00  -3.0517578e-05   9.1552734e-05   1.5258789e-04  -2.4414062e-04   2.1362305e-04  -2.4414062e-04   0.0000000e+00   1.8310547e-04  -2.1362305e-04   1.8310547e-04  -2.4414062e-04   2.7465820e-04  -1.5258789e-04   6.1035156e-05  -3.0517578e-05   9.1552734e-05  -2.4414062e-04   4.2724609e-04  -3.0517578e-04   0.0000000e+00   0.0000000e+00   1.8310547e-04  -1.5258789e-04   3.3569336e-04  -3.0517578e-04   2.4414062e-04  -1.5258789e-04  -3.0517578e-05   3.0517578e-05   1.5258789e-04  -9.1552734e-05  -6.1035156e-05   3.0517578e-05   0.0000000e+00  -1.2207031e-04  -1.2207031e-04   9.1552734e-05  -9.1552734e-05   1.8310547e-04  -1.2207031e-04   2.4414062e-04  -1.2207031e-04  -1.5258789e-04   3.0517578e-05   0.0000000e+00   6.1035156e-05  -9.1552734e-05   6.1035156e-05  -2.1362305e-04   3.0517578e-05  -3.0517578e-05  -2.1362305e-04   3.0517578e-05  -1.8310547e-04   6.1035156e-05  -9.1552734e-05  -3.0517578e-05   3.0517578e-05  -9.1552734e-05   1.2207031e-04  -1.5258789e-04  -3.0517578e-05  -1.8310547e-04   0.0000000e+00   3.0517578e-05  -9.1552734e-05   3.0517578e-05   1.8310547e-04  -3.6621094e-04   3.0517578e-05  -6.1035156e-05  -3.0517578e-05  -6.1035156e-05  -1.5258789e-04   6.1035156e-05   1.8310547e-04  -6.1035156e-05   1.2207031e-04  -3.0517578e-05   0.0000000e+00  -2.7465820e-04   2.7465820e-04  -2.7465820e-04   1.2207031e-04   1.2207031e-04  -2.1362305e-04   0.0000000e+00  -6.1035156e-05   3.0517578e-05  -1.5258789e-04  -9.1552734e-05   6.1035156e-05   0.0000000e+00  -3.0517578e-05  -1.8310547e-04   1.5258789e-04  -2.7465820e-04  -3.0517578e-05   6.1035156e-05  -2.4414062e-04   9.1552734e-05  -1.5258789e-04  -9.1552734e-05   6.1035156e-05   6.1035156e-05  -1.5258789e-04   1.2207031e-04  -3.9672852e-04   3.0517578e-05  -3.0517578e-04   1.8310547e-04  -1.2207031e-04   6.1035156e-05  -2.4414062e-04  -2.1362305e-04   1.2207031e-04  -1.5258789e-04  -1.2207031e-04  -6.1035156e-05  -9.1552734e-05  -3.0517578e-04   3.0517578e-04  -1.5258789e-04  -2.4414062e-04   1.2207031e-04  -1.8310547e-04   1.2207031e-04  -1.5258789e-04  -9.1552734e-05  -9.1552734e-05   0.0000000e+00  -1.8310547e-04  -9.1552734e-05   2.4414062e-04  -2.1362305e-04   1.8310547e-04  -1.5258789e-04   1.2207031e-04  -3.0517578e-05  -6.1035156e-05   3.0517578e-05  -3.0517578e-04   1.2207031e-04  -1.2207031e-04   1.2207031e-04   0.0000000e+00   6.1035156e-05  -2.4414062e-04   9.1552734e-05  -6.1035156e-05   1.5258789e-04  -2.7465820e-04  -6.1035156e-05   3.0517578e-05  -6.1035156e-05  -3.0517578e-05  -2.1362305e-04   9.1552734e-05  -3.0517578e-05  -1.5258789e-04   9.1552734e-05  -1.5258789e-04  -3.0517578e-05   3.0517578e-05  -1.5258789e-04   3.0517578e-05  -6.1035156e-05  -1.2207031e-04   1.8310547e-04  -2.1362305e-04  -1.5258789e-04  -9.1552734e-05   0.0000000e+00   9.1552734e-05   1.5258789e-04  -1.2207031e-04  -1.5258789e-04  -6.1035156e-05  -2.1362305e-04   1.5258789e-04  -2.1362305e-04   3.0517578e-05  -1.5258789e-04   0.0000000e+00  -3.3569336e-04   3.0517578e-04  -1.2207031e-04   3.0517578e-05   2.1362305e-04  -3.6621094e-04   6.1035156e-05   6.1035156e-05   6.1035156e-05  -9.1552734e-05   1.8310547e-04  -2.1362305e-04   6.1035156e-05  -1.8310547e-04   3.3569336e-04  -2.4414062e-04   3.0517578e-04  -4.2724609e-04   1.8310547e-04  -6.1035156e-05   9.1552734e-05  -6.1035156e-05   0.0000000e+00  -6.1035156e-05   1.2207031e-04   9.1552734e-05  -1.5258789e-04   1.8310547e-04  -3.0517578e-05   1.2207031e-04  -1.8310547e-04   6.1035156e-05  -6.1035156e-05   0.0000000e+00   1.8310547e-04  -3.0517578e-04   1.2207031e-04  -1.5258789e-04   1.8310547e-04  -2.4414062e-04   3.0517578e-05  -3.0517578e-05   6.1035156e-05  -9.1552734e-05   3.0517578e-05   3.0517578e-05  -9.1552734e-05  -3.0517578e-05   1.8310547e-04  -2.4414062e-04   3.0517578e-05   1.2207031e-04  -1.2207031e-04   1.8310547e-04  -3.0517578e-05   3.0517578e-05   3.0517578e-05   9.1552734e-05  -3.0517578e-04   2.7465820e-04   9.1552734e-05   2.7465820e-04  -1.5258789e-04   0.0000000e+00   1.8310547e-04   0.0000000e+00  -6.1035156e-05   6.1035156e-05   3.0517578e-05   9.1552734e-05   1.2207031e-04  -9.1552734e-05   3.0517578e-04   0.0000000e+00  -1.5258789e-04   2.4414062e-04   3.0517578e-05   9.1552734e-05   9.1552734e-05  -3.0517578e-05   0.0000000e+00   3.0517578e-05  -2.1362305e-04   1.8310547e-04   0.0000000e+00  -3.0517578e-05   0.0000000e+00  -1.2207031e-04   2.1362305e-04   3.0517578e-05   1.5258789e-04  -6.1035156e-05  -3.0517578e-05   6.1035156e-05   9.1552734e-05   6.1035156e-05   3.0517578e-05   3.0517578e-05  -3.0517578e-05  -1.2207031e-04   1.5258789e-04  -2.7465820e-04   3.6621094e-04  -2.1362305e-04   2.4414062e-04  -3.0517578e-05   1.2207031e-04  -1.2207031e-04   1.8310547e-04   0.0000000e+00  -6.1035156e-05   1.5258789e-04  -3.0517578e-05   1.2207031e-04  -6.1035156e-05   1.5258789e-04   6.1035156e-05   0.0000000e+00   6.1035156e-05   3.0517578e-05  -1.2207031e-04   2.4414062e-04  -3.0517578e-05   0.0000000e+00  -3.0517578e-05   1.8310547e-04   6.1035156e-05   9.1552734e-05   2.1362305e-04   1.8310547e-04   0.0000000e+00   1.5258789e-04   3.0517578e-05   1.2207031e-04   1.2207031e-04  -6.1035156e-05   1.5258789e-04   6.1035156e-05   6.1035156e-05  -9.1552734e-05   1.5258789e-04   1.5258789e-04   9.1552734e-05  -3.0517578e-05   6.1035156e-05   6.1035156e-05  -3.0517578e-05   1.2207031e-04   9.1552734e-05  -6.1035156e-05   1.8310547e-04  -3.0517578e-04   3.0517578e-04  -9.1552734e-05   9.1552734e-05  -1.5258789e-04   1.2207031e-04   1.2207031e-04  -1.5258789e-04   1.8310547e-04  -2.4414062e-04   2.7465820e-04  -3.0517578e-05   6.1035156e-05  -1.5258789e-04   2.1362305e-04  -1.8310547e-04   2.1362305e-04  -9.1552734e-05  -6.1035156e-05  -3.0517578e-05   2.7465820e-04  -1.5258789e-04   1.8310547e-04  -9.1552734e-05   1.2207031e-04   9.1552734e-05  -1.8310547e-04   2.4414062e-04   3.0517578e-05   6.1035156e-05   0.0000000e+00  -1.8310547e-04   4.5776367e-04  -3.3569336e-04   2.7465820e-04   0.0000000e+00   0.0000000e+00   6.1035156e-05  -1.8310547e-04   9.1552734e-05   1.5258789e-04  -2.7465820e-04   3.0517578e-04  -1.8310547e-04  -1.2207031e-04   1.8310547e-04   9.1552734e-05   0.0000000e+00   9.1552734e-05  -1.8310547e-04   3.0517578e-05   0.0000000e+00   1.5258789e-04  -2.1362305e-04   2.7465820e-04  -3.9672852e-04   1.5258789e-04   3.0517578e-05   0.0000000e+00   9.1552734e-05   3.0517578e-05  -6.1035156e-05  -1.5258789e-04   0.0000000e+00   2.4414062e-04  -3.6621094e-04   1.8310547e-04  -2.4414062e-04   9.1552734e-05   3.0517578e-05   6.1035156e-05  -3.6621094e-04   2.1362305e-04  -3.0517578e-05  -6.1035156e-05  -9.1552734e-05   1.2207031e-04   3.0517578e-05  -1.5258789e-04   9.1552734e-05   3.0517578e-05  -3.0517578e-05   3.0517578e-05  -1.2207031e-04   0.0000000e+00   2.4414062e-04  -3.6621094e-04   9.1552734e-05  -9.1552734e-05  -3.0517578e-05   1.2207031e-04  -9.1552734e-05  -1.8310547e-04   3.0517578e-04  -3.0517578e-04   9.1552734e-05   6.1035156e-05  -3.0517578e-05  -6.1035156e-05   9.1552734e-05  -1.8310547e-04   1.2207031e-04  -1.8310547e-04  -3.0517578e-05   0.0000000e+00   0.0000000e+00  -6.1035156e-05  -1.2207031e-04  -3.0517578e-05  -2.1362305e-04   1.5258789e-04  -9.1552734e-05  -9.1552734e-05   6.1035156e-05  -1.5258789e-04   3.0517578e-05  -1.2207031e-04  -6.1035156e-05  -3.0517578e-05  -1.2207031e-04   0.0000000e+00  -2.1362305e-04   1.5258789e-04  -9.1552734e-05  -3.0517578e-05  -1.5258789e-04  -3.0517578e-05   1.2207031e-04  -2.7465820e-04   3.0517578e-05  -1.8310547e-04   6.1035156e-05   1.2207031e-04  -3.3569336e-04   1.2207031e-04   1.8310547e-04  -1.5258789e-04  -3.0517578e-05  -1.5258789e-04  -3.0517578e-05  -1.2207031e-04   1.2207031e-04  -9.1552734e-05  -1.8310547e-04   2.1362305e-04  -1.8310547e-04   1.2207031e-04  -1.8310547e-04   2.1362305e-04  -3.0517578e-05  -6.1035156e-05   1.5258789e-04  -2.1362305e-04  -9.1552734e-05   3.0517578e-04  -9.1552734e-05  -3.0517578e-05  -6.1035156e-05  -9.1552734e-05   2.1362305e-04  -3.6621094e-04   2.4414062e-04  -1.5258789e-04   6.1035156e-05  -9.1552734e-05  -6.1035156e-05  -1.5258789e-04   1.2207031e-04   1.2207031e-04  -3.0517578e-04   1.2207031e-04  -4.2724609e-04   4.5776367e-04  -3.3569336e-04   6.1035156e-05  -1.2207031e-04   6.1035156e-05  -3.0517578e-05  -2.1362305e-04  -1.8310547e-04   2.4414062e-04  -6.1035156e-05  -1.8310547e-04   1.2207031e-04  -3.0517578e-05  -1.2207031e-04   1.2207031e-04  -3.3569336e-04   6.1035156e-05  -6.1035156e-05  -6.1035156e-05  -6.1035156e-05   2.1362305e-04  -1.5258789e-04  -6.1035156e-05   1.8310547e-04  -1.5258789e-04  -1.5258789e-04   1.5258789e-04  -2.7465820e-04   3.0517578e-04  -1.5258789e-04   1.5258789e-04  -1.5258789e-04   3.0517578e-05  -3.0517578e-05   2.4414062e-04  -9.1552734e-05   6.1035156e-05   3.0517578e-05  -9.1552734e-05   0.0000000e+00   6.1035156e-05  -1.2207031e-04   6.1035156e-05   6.1035156e-05   0.0000000e+00  -9.1552734e-05   6.1035156e-05  -3.0517578e-05   1.5258789e-04  -6.1035156e-05   3.0517578e-05  -3.0517578e-04   3.9672852e-04  -1.5258789e-04  -6.1035156e-05  -6.1035156e-05   9.1552734e-05  -9.1552734e-05   1.8310547e-04   0.0000000e+00  -9.1552734e-05   6.1035156e-05   9.1552734e-05  -9.1552734e-05  -3.0517578e-05   1.5258789e-04  -2.4414062e-04  -3.0517578e-05   0.0000000e+00   2.7465820e-04  -1.5258789e-04   2.4414062e-04  -2.7465820e-04   9.1552734e-05  -9.1552734e-05   3.0517578e-05   6.1035156e-05   2.1362305e-04  -9.1552734e-05  -3.0517578e-05   3.0517578e-05   3.0517578e-04  -2.7465820e-04   1.2207031e-04   9.1552734e-05   1.5258789e-04  -1.2207031e-04   6.1035156e-05   9.1552734e-05  -6.1035156e-05  -1.2207031e-04   2.7465820e-04   6.1035156e-05  -9.1552734e-05  -1.2207031e-04   2.7465820e-04  -6.1035156e-05   6.1035156e-05  -1.8310547e-04   2.1362305e-04  -1.5258789e-04   1.8310547e-04  -3.0517578e-05   3.0517578e-05   2.1362305e-04   0.0000000e+00   6.1035156e-05   3.0517578e-05   0.0000000e+00   1.2207031e-04   0.0000000e+00   0.0000000e+00  -1.2207031e-04   2.4414062e-04   3.0517578e-05  -3.0517578e-05   0.0000000e+00  -3.0517578e-05   0.0000000e+00   3.0517578e-05   9.1552734e-05   6.1035156e-05  -1.2207031e-04  -3.0517578e-05   3.9672852e-04  -2.1362305e-04   1.5258789e-04   3.0517578e-05  -6.1035156e-05   0.0000000e+00   0.0000000e+00   6.1035156e-05   6.1035156e-05   9.1552734e-05  -3.0517578e-05   1.8310547e-04  -3.0517578e-05  -9.1552734e-05   1.8310547e-04   1.2207031e-04   6.1035156e-05   3.0517578e-05   2.4414062e-04  -1.5258789e-04   1.5258789e-04   0.0000000e+00   6.1035156e-05   6.1035156e-05   6.1035156e-05   3.0517578e-04  -2.1362305e-04   1.8310547e-04   0.0000000e+00  -6.1035156e-05   3.3569336e-04  -6.1035156e-05   1.2207031e-04  -6.1035156e-05   3.3569336e-04  -2.4414062e-04   1.5258789e-04   0.0000000e+00   3.0517578e-05   6.1035156e-05   3.0517578e-05   2.7465820e-04  -3.0517578e-05  -3.0517578e-05  -9.1552734e-05   2.1362305e-04  -3.0517578e-05  -1.2207031e-04   1.5258789e-04   1.2207031e-04  -6.1035156e-05   9.1552734e-05   1.8310547e-04  -9.1552734e-05  -6.1035156e-05  -6.1035156e-05   2.1362305e-04   9.1552734e-05  -3.0517578e-05  -1.2207031e-04   6.1035156e-05   0.0000000e+00  -1.2207031e-04   3.6621094e-04  -3.0517578e-05  -3.0517578e-05   6.1035156e-05   0.0000000e+00   3.0517578e-05   3.0517578e-05   1.5258789e-04  -3.0517578e-05   6.1035156e-05  -6.1035156e-05   2.7465820e-04  -3.0517578e-05  -1.2207031e-04   9.1552734e-05   0.0000000e+00   9.1552734e-05   6.1035156e-05   1.2207031e-04  -3.0517578e-04   3.9672852e-04  -3.0517578e-05   3.0517578e-05   2.7465820e-04  -6.1035156e-05   1.2207031e-04   3.0517578e-05   1.2207031e-04  -1.5258789e-04   3.0517578e-05   1.5258789e-04   1.2207031e-04  -1.5258789e-04   1.2207031e-04  -2.4414062e-04   2.1362305e-04  -2.4414062e-04   1.8310547e-04  -6.1035156e-05   2.1362305e-04  -1.2207031e-04  -9.1552734e-05   0.0000000e+00   3.3569336e-04  -3.0517578e-04   3.3569336e-04  -4.2724609e-04   1.8310547e-04  -1.5258789e-04   6.1035156e-05   6.1035156e-05  -9.1552734e-05  -6.1035156e-05   0.0000000e+00  -6.1035156e-05   1.5258789e-04   0.0000000e+00  -2.1362305e-04   0.0000000e+00  -9.1552734e-05   1.8310547e-04  -9.1552734e-05  -9.1552734e-05   0.0000000e+00   0.0000000e+00  -3.0517578e-05   0.0000000e+00   3.0517578e-05  -1.2207031e-04   1.5258789e-04  -3.0517578e-05  -2.4414062e-04   1.2207031e-04   2.4414062e-04  -3.6621094e-04   2.1362305e-04  -6.1035156e-05   1.2207031e-04  -6.1035156e-05   6.1035156e-05  -9.1552734e-05  -3.0517578e-05   3.0517578e-05   3.0517578e-05  -3.0517578e-05  -6.1035156e-05  -2.1362305e-04   1.2207031e-04  -1.5258789e-04   2.4414062e-04  -2.1362305e-04   3.0517578e-05   0.0000000e+00  -6.1035156e-05  -6.1035156e-05   6.1035156e-05  -9.1552734e-05   0.0000000e+00   1.2207031e-04  -2.1362305e-04   0.0000000e+00  -3.0517578e-05   3.0517578e-05  -9.1552734e-05   3.0517578e-05  -1.8310547e-04   3.0517578e-05   6.1035156e-05  -3.6621094e-04   2.4414062e-04  -1.5258789e-04   6.1035156e-05  -6.1035156e-05   3.0517578e-05  -1.8310547e-04   0.0000000e+00  -9.1552734e-05   1.8310547e-04  -9.1552734e-05  -1.5258789e-04   0.0000000e+00))

(defun radresp (n)
  (loop with rx = *radresp*
        for i from 0 below n
        for x = (car rx)
        do (setq rx (cdr rx))
        collect x))

; (radresp 5)

