
(in-package :bc)


;;; LispWorks support

;;; AUDIO

(defclass .pa_server () ;;; (basic-block)
  ((pa_indevice :initform nil :accessor pa_indevice)
   (pa_outdevice :initform nil :accessor pa_outdevice)
   (bufsize :initarg :bufsize :accessor bufsize)
   (maxin# :initform nil :accessor maxin#)
   (maxout# :initform nil :accessor maxout#)
   (srate :initarg :srate :accessor srate)
   (state :initform nil :accessor state)
   (patchcount :initarg :patchcount :accessor patchcount))
  (:default-initargs
    :srate *srate*
    :bufsize 128
    :patchcount 32))

#+MACOSX
(defmethod initialize-instance :after ((pa .pa_server) &key)
  (pa_devices)
  (let* ((indev (elt *pa_devinfo* (pa_getdefaultinputdevice)))
         (outdev (elt *pa_devinfo* (Pa_GetDefaultOutputDevice)))
         (maxin (maxinputchannels indev))
         (maxout (maxoutputchannels outdev)))
    (setf (pa_indevice pa) indev (pa_outdevice pa) outdev)
    (setf (maxin# pa) maxin (maxout# pa) maxout)
    (pa_Init (bufsize pa) (maxin# pa) (maxout# pa))))

; (maxinputchannels (indev (elt (pa_devices) (pa_getdefaultinputdevice))))
; (maxinputchannels (elt *pa_devinfo* (pa_getdefaultinputdevice)))

#+MSWINDOWS
(defmethod initialize-instance :after ((pa .pa_server) &key)
  (let* ()
    (setf ;;; (pa_device pa) nil
          (maxin# pa) 2
          (maxout# pa) 2)
    (pa_Init (bufsize pa) (maxin# pa) (maxout# pa))))


(defparameter *BC-lib* nil)
(defparameter *BC-patch-dir* nil)

(defclass pa_deviceinfo ()
  ((structversion :reader structversion)
   (name :reader name)
   (maxInputChannels :reader maxInputChannels)
   (maxOutputChannels :reader maxOutputChannels)
   (samplerates :reader samplerates)))

(defclass pa_device ()
  ((name :initarg :name :accessor name)
   (indev :initform nil :accessor indev)
   (inblock :initform nil :accessor inblock)
   (outdev :initform nil :accessor outdev)
   (outblock :initform nil :accessor outblock)))

#+MACOSX
(defun get_pa_devices ()
  (let* ((devicecount (pa_countdevices)))
    (unless (> devicecount 0)
      (error "Device count error"))
    (loop for i from 0 below devicecount
          for devptr = (pa_getdeviceinfo i)
          for svers = (fli:dereference devptr :type :long)
          for dp1 = (fli:incf-pointer devptr 1)
          for strp = (fli:dereference dp1 :type :pointer)
          for name = (fli:convert-from-foreign-string strp)
          for dp2 = (fli:incf-pointer dp1 2)
          for maxins = (fli:dereference dp2 :type :long)
          for dp3 = (fli:incf-pointer dp2 1)
          for maxouts = (fli:dereference dp3 :type :long)
      ;    for dp4 = (fli:incf-pointer dp3 5)
          for srate = 44100.0 ; (fli:dereference dp4 :type :double)
          ;
          for info = (make-instance 'pa_deviceinfo)
      ;    do (when (eql (search "Built-in" name) 0) (setq name "Built-in"))
          do (setf (slot-value info 'structversion) svers)
          do (setf (slot-value info 'name) name)
          do (setf (slot-value info 'maxInputChannels) maxins)
          do (setf (slot-value info 'maxOutputChannels) maxouts)
          do (setf (slot-value info 'samplerates) (list srate))
          collect info)))

#+MSWINDOWS
(defun get_pa_devices ()
  (let* ((devicecount (pa_countdevices)))
    (loop for i from 0 below devicecount
          for devptr = (pa_getdeviceinfo i)
          for svers = (fli:dereference devptr :type :long)
          for dp1 = (fli:incf-pointer devptr 1)
          for strp = (fli:dereference dp1 :type :pointer)
          for name = (fli:convert-from-foreign-string strp)
          for dp2 = (fli:incf-pointer dp1 1)
          for maxins = (fli:dereference dp2 :type :long)
          for dp3 = (fli:incf-pointer dp2 1)
          for maxouts = (fli:dereference dp3 :type :long)
          for dp4 = (fli:incf-pointer dp3 1)
          for srcount = (fli:dereference dp4 :type :long)
          for dp5 = (fli:incf-pointer dp4 1)
          for srates = (loop with ptr = (fli:dereference
                                         dp5 :type :pointer)
                             for i from 0 below srcount
                             for sr = (fli:dereference
                                       ptr :index i :type :double)
                             collect sr)
          for dp6 = (fli:incf-pointer dp5 1)
          ;
          for info = (make-instance 'pa_deviceinfo)
          do (when (eql (search "Built-in" name) 0) (setq name "Built-in"))
          do (setf (slot-value info 'structversion) svers)
          do (setf (slot-value info 'name) name)
          do (setf (slot-value info 'maxInputChannels) maxins)
          do (setf (slot-value info 'maxOutputChannels) maxouts)
          do (setf (slot-value info 'samplerates)
                   (if (< srcount 0) (list srates) srates))
          collect info)))


(defun parse_pa_devs (devinfos)
  (let (devs dx)
    (loop for dinfo in devinfos
          for n = (name dinfo)
          for in# = (maxinputchannels dinfo)
          for out# = (maxoutputchannels dinfo)
          do (setq dx nil)
          do (cond ((and (> in# 0) (> out# 0))
                    ;;; if name there already => error
                    (setq dx (make-instance 'pa_device))
                    (setf (indev dx) dinfo)
                    (setf (outdev dx) dinfo)
                    (setf (name dx) n)
                    (push dx devs))
                   ((> in# 0)
                    (setq dx (find dinfo devs 
                                   :test #'(lambda (x y) (string-equal (name x) y))
                                   :key #'name))
                    (when dx (setf (indev dx) dinfo))
                    (unless dx 
                      (setq dx (make-instance 'pa_device :name n))
                      (push dx devs))
                    (setf (indev dx) dinfo))
                   ((> out# 0)
                    (setq dx (find dinfo devs 
                                   :test #'(lambda (x y) (string-equal (name x) y))
                                   :key #'name))
                    (when dx (setf (outdev dx) dinfo))
                    (unless dx 
                      (setq dx (make-instance 'pa_device :name n))
                      (push dx devs)))))
    (nreverse devs)))

(defun updated_pa_devs ()
  (pa_termin) (pa_termin)
  (parse_pa_devs (get_pa_devices)))

(defparameter *pa_devices*  nil)
(defparameter *pa_devinfo*  nil)

; (describe (indev (elt (pa_devices) 0)))
; (describe (elt (get_pa_devices) 0))
; (get_pa_devices)
; (pa_getdeviceinfo 0)

(defun pa_devices ()
  (unless *pa_devices*
    (pa_initialize)
    (pa_termin)
    (pa_initialize)
    (setq *pa_devices*
          (parse_pa_devs
           (setq *pa_devinfo*
                 (get_pa_devices)))))
  *pa_devices*)

; (pa_devices)
; (dolist (x *pa_devinfo*) (describe x) (terpri))


(defun get-BC-lib ()
  (let* ((bclib cl-user::*BC3*)
         (bcmod #+MACOSX (format nil "~a/BC3/BC3.framework/BC3" bclib)
                #+MSWINDOWS (format nil "~a/BC3/BC3.dll" bclib)))
    (fli:register-module
     "BC"
     :real-name bcmod
     :connection-style :immediate)
    ;
    (fli:define-foreign-function 
      (Pa_CountDevices "Pa_CountDevices" :source)
      () :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (Pa_Initialize "Pa_Initialize" :source)
      () :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function
      (Pa_GetDeviceInfo "Pa_GetDeviceInfo")
      ((index :int)) :result-type (:pointer :long)
      :language :c)
    ;
    (fli:define-foreign-function 
      (Pa_GetDefaultInputDevice "Pa_GetDefaultInputDevice" :source)
      () :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (Pa_GetDefaultOutputDevice "Pa_GetDefaultOutputDevice" :source)
      () :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (Pa_GetSampleSize "Pa_GetSampleSize" :source)
      ((format :long)) :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (Pa_Init "pa_Init" :source)
      ((nframes :long)
       (adsize :long)
       (dasize :long))
      :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (pa_Open "pa_OpenStream" :source)
      ((srate :double)) :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (pa_Start "pa_StartStream" :source)
      () :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (pa_Stop "pa_StopStream" :source)
      () :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (pa_Close "pa_CloseStream" :source)
      () :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (pa_Termin "pa_Terminate" :source)
      () :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (get_link "get_link" :source)
      ((n :long)) :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (set_link "set_link" :source)
      ((n :long)
       (addr :long)) :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (get_ad "get_ad" :source)
      () :result-type :long
      :language :c)
    ;
    (fli:define-foreign-function 
      (get_da "get_da" :source)
      () :result-type :long
      :language :c)
    ;
    (setq *BC-patch-dir*
          #+MACOSX (format nil "~a/Patches/" cl-user::*BC3*)
          #+MSWINDOWS (format nil "~aPatches/" cl-user::*BC3*))
    nil))

(get-BC-lib)

#|
;;; (pa_Init 256 2 2 44100.0)
;;; (pa_Open)
;;; (pa_Start)
;;; (pa_Stop)
;;; (pa_Close)
;;; (pa_Termin)

extern long get_link(long n) {return(links[n]);}
extern void set_link(long n, long addr) {links[n]=addr;}
|#

(defun %syscall (string)
  (system::call-system string))

(defun write-patch% (p)
  (let* ((dirpath *BC-patch-dir*)
         (name (patchname p))
         (dst (format nil "~a~a/~a.c" dirpath name name)))
    (when (probe-file dst) (delete-file dst))
    (ensure-directories-exist dst)
    (with-open-file
      (str dst :direction :output
           :if-exists :overwrite
           :if-does-not-exist :create)
      (funcall 'c-code p str))))

(defun bc-compile% (p &optional (dir *BC-patch-dir*))
  (let* ((file (patchname p))
         (dirpath dir)
         (src (format nil "~a~a/~a.c" dirpath file file))
         (dst (format nil "~a~a/~a" dirpath file file))
         (str #+MACOSX (format nil "/usr/bin/cc -O3 -bundle \"~a\" -o \"~a\"" src dst)
              #+MSWINDOWS (format nil "~a -w -O3 -shared \"~a\" -o \"~a\".dll"
                                  *MinGWgcc* src dst)))
    (unless (= (%syscall str) 0)
      (print str t)
      (error "Cannot compile patch ~a" p))
    nil))

(defun link-main% (p) p nil)

(defparameter *type-mapper*
  '((.char . :char)
    (.short . :short)
    (.long . :long)
    (.float . :float)
    (.double . :double)))

(defun type.map (var)
  (cdr (assoc (datatype var) *type-mapper*)))

(defmethod c-address ((v terminal))
  (let* ((b (host-block v))
         (p (find-patch b))
         (r (runtime p)))
    (fli:pointer-address
     (fli:make-pointer :symbol-name (string (varname v))
                       :module (patchname p)))))

(defmethod reader-access ((b t)) nil)

(defmethod writer-access ((b t)) nil)

(defmethod reader-access ((b terminal))
  (when (creader b)
    (let* ((dim (datasize b))
           (type (type.map b))
           (name (varname b))
           (rname (format nil "get_~a" name))
           (funame (gensym))
           (p (find-patch (host-block b)))
           (pname (string (patchname p)))
           (args (cond ((equal dim '(1)) nil)
                       ((= (length dim) 1)
                        '((x :long)))
                       ((= (length dim) 2)
                        '((x :long) (y :long))))))
      (when (var-p b)
        (eval
         `(fli:define-foreign-function 
            (,funame ,rname :source)
            ,args :result-type ,type
            :module ',pname
            :language :c))
        (setf (creader b) funame)))))

(defmethod writer-access ((b terminal))
  (when (cwriter b)
    (let* ((dim (datasize b))
           (type (type.map b))
           (name (varname b))
           (rname (format nil "set_~a" name))
           (funame (gensym))
           (p (find-patch (host-block b)))
           (pname (string (patchname p)))
           (args (cond ((equal dim '(1)) nil)
                       ((= (length dim) 1)
                        '((x :long)))
                       ((= (length dim) 2)
                        '((x :long) (y :long))))))
      (push (list 'val type) args)
      (when (var-p b)
        (eval
         `(fli:define-foreign-function 
            (,funame ,rname :source)
            ,args :result-type nil
            :module ',pname
            :language :c))
        (setf (cwriter b) funame)))))


(defclass runtime ()
  ((patchfun :initarg :patchfun :accessor patchfun)
   (npatchfun :initarg :npatchfun :accessor npatchfun)
   (patchaddr :initarg :patchaddr :accessor patchaddr)
   (bundle :initarg :bundle :accessor bundle)
   (host-patch :initarg :patch :accessor host-patch))
  (:default-initargs
    :patch nil
    :patchfun nil
    :npatchfun nil
    :patchaddr nil
    :bundle nil))

(defmethod stop-patch ((r runtime))
  nil)

(defun make-runtime (p)
  (let* ((pname (string (patchname p)))
         (rname (format nil "~a~a/~a" *BC-patch-dir* pname pname))
         (bundle (fli:register-module
                  pname :real-name rname
                  :connection-style :immediate))
         (funame (gensym))
         (nfuname (gensym))
         (gpname (gensym)))
    (eval `(fli:define-foreign-function
             (,funame "patch") ()
             :result-type :int
             :module ',pname
             :language :ansi-c))
    (eval `(fli:define-foreign-function
             (,nfuname "npatch") 
             ((n :long))
             :result-type :void
             :module ',pname
             :language :ansi-c))
    (eval `(fli:define-foreign-function
             (,gpname "paddr") ()
             :result-type :long
             :module ',pname
             :language :ansi-c))
    (setf (runtime p)
          (make-instance 'runtime
            :bundle bundle :patchfun funame
            :npatchfun nfuname
            :patchaddr gpname :patch p))
    (loop for b in (used-variables p)
          do (reader-access b))
    (loop for b in (used-variables p)
          do (writer-access b))
    (runtime p)))

(defmethod dispose-runtime ((r runtime))
  (when (bundle r) (fli:disconnect-module (bundle r)))
  (let ((hostp (host-patch r)))
    (setf (bundle r) nil (patchaddr r) nil
          (patchfun r) nil (npatchfun r) nil
          (host-patch r) nil)
    (setf (runtime hostp) nil)))


(defun dispose-pointer (ptr)
  (fli:free-foreign-object ptr))

(defun pointer-address (ptr)
  (fli:pointer-address ptr))


(provide :BC-LW)