function [coeffs,ind,dx] = lgint5(x)
% function [coeffs,ind,dx] = lgint5(x)
% Lagrange interpolation 5st order

ind = floor(x-2);
dx = x-ind;
dx0 = dx;
dx1 = dx-1;
dx2 = dx-2;
dx3 = dx-3;
dx4 = dx-4;
dx5 = dx-5;
h0 = -0.00833333333333*dx1*dx2*dx3*dx4*dx5;
h1 = 0.04166666666667*dx0*dx2*dx3*dx4*dx5;
h2 = -0.08333333333333*dx0*dx1*dx3*dx4*dx5;
h3 = 0.08333333333333*dx0*dx1*dx2*dx4*dx5;
h4 = -0.04166666666667*dx0*dx1*dx2*dx3*dx5;
h5 = 0.00833333333333*dx0*dx1*dx2*dx3*dx4;
coeffs = [h0;h1;h2;h3;h4;h5];
