function [bias,devi,pwr,thrs]=biasdev_c0_N(cues,spow,ic,c0range,ffcues,N)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%       Compute bias and deviation for a range of 
%               selection thresholds c0
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  [bias,devi,pwr,thrs] = biasdev_c0_N(cues,spow,ic,c0range,N,ffcues)
%
%  Input parameters:
%    cues:      ITD or ILD as a function of time
%    spow:      signal power as a function of time
%    ic:        IC as a function of time
%    c0range:   range of ic0 considered [c0range,1]
%    ffcues:    free field cues
%    N:         resolution of function computed
%
%  Output parameters:
%    bias:      bias as a function of c0
%    devi:      deviation as a function of c0
%    pwr:       power as a function of c0
%    thrs:      vector with c0 values considered
%
%  Authors:
%    C. Faller and J. Merimaa 12-2003
%   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

M    = max(size(ffcues));
thrs = c0range + (0:(N-1)).*(1-c0range)./(N-1);

for i = 1:N,
  c0 = thrs(i);
  [bias2,devi2,pwr2]=biasdev_c0(cues, spow, ic, c0, ffcues);
  bias(i) = bias2(M+1);
  devi(i) = devi2(M+1);
  pwr(i)  = pwr2(M+1);
end
            
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
