function [c0,pw0,dev0]=c0_dev(cues,ic,pow,dev0,ffcues,prc,maxit)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%    Compute c0 such that deviation==dev0
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  [c0,pw0,dev0] = c0_dev(cues,ic,pow,dev0,ffcues,prc,maxit)
%
%  Input parameters:
%    cues:      ITD or ILD cues as a function of time
%    ic:        IC as a function of time
%    pow:       power as a function of time
%    dev0:      compute c0 such that E{dev|IC>c0}==dev0
%    ffcues:    free field cues
%    prc:       presision of computation (optional,
%               default: prc = 0.05)
%    maxit:     maximum number of iterations (optional,
%               default: maxit = 30)
%
%  Output parameters:
%    c0:        computed c0
%    pw0:       E{power|IC>c0}
%    dev0:      deviation for computed c0
%
%  Authors:
%    C. Faller and J. Merimaa 12-2003
%   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


if nargin < 6 | isempty(prc)
  prc          = .05;      %   precision for c0 computation (criterion = 1..3)
end
if nargin < 7 | isempty(maxit)
  maxit        = 30;       %   maximum number of iterations for c0 computation (criterion = 1..3)
end

M = max(size(ffcues));

lo_c0  = min(ic)+1e-10;
hi_c0  = max(ic)-1e-10;

[bias,devi,pwr]=biasdev_c0(cues,pow,ic,lo_c0,ffcues);
lo_dev = devi(M+1);
lo_pwr = pwr(M+1);
[bias,devi,pwr]=biasdev_c0(cues,pow,ic,hi_c0,ffcues);
hi_dev = devi(M+1);
hi_pwr = pwr(M+1);
it = 1;
while abs(lo_dev-dev0)/dev0 > prc & abs(hi_dev-dev0)/dev0 > prc & it <= maxit,
  mi_c0 = .5*(lo_c0+hi_c0);
  [bias,devi,pwr]=biasdev_c0(cues,pow,ic,mi_c0,ffcues);
  mi_dev = devi(M+1);
  mi_pwr = pwr(M+1);
  if mi_dev > dev0
      lo_c0  = mi_c0;
      lo_dev = mi_dev;
      lo_pwr = mi_pwr;
  else
      hi_c0  = mi_c0;
      hi_dev = mi_dev;
      hi_pwr = mi_pwr;
  end
  it = it + 1;
end
if abs(lo_dev-dev0)/dev0 < abs(hi_dev-dev0)/dev0
   c0  = lo_c0;
   pw0  = lo_pwr;
   dev0 = lo_dev;
else
   c0  = hi_c0;
   pw0  = hi_pwr;
   dev0 = hi_dev;
end
     
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
