function [c0,pw0]=c0_pwr(ic,pow,p0,prc,maxit)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%      Compute c0 such that relative power of
%          selected signal portion is p0
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  [c0,pw0] = c0_pwr(ic,pow,p0,prc,maxit)
%
%  Input parameters:
%    ic:        IC as a function of time
%    pow:       power as a function of time
%    p0:        compute c0 such that E{pow|IC>c0}==p0
%    prc:       presision of computation (optional,
%               default: prc = 0.05)
%    maxit:     maximum number of iterations (optional,
%               default: maxit = 30)
%
%  Output parameters:
%    c0:        computed c0
%    pw0:       p0 for computed c0
%
%  Authors:
%    C. Faller and J. Merimaa 12-2003
%   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


if nargin < 6 | isempty(prc)
  prc          = .05;      %   precision for c0 computation (criterion = 1..3)
end
if nargin < 7 | isempty(maxit)
  maxit        = 30;       %   maximum number of iterations for c0 computation (criterion = 1..3)
end

lo_c0  = min(ic)+1e-10;
hi_c0  = max(ic)-1e-10;
[lo_pwr]=pwr_c0(ic,pow,lo_c0);
[hi_pwr]=pwr_c0(ic,pow,hi_c0);
it = 1;
while abs(lo_pwr-p0)/p0 > prc & abs(hi_pwr-p0)/p0 > prc & it <= maxit,
  mi_c0 = .5*(lo_c0+hi_c0);
  [mi_pwr]=pwr_c0(ic,pow,mi_c0);
  if mi_pwr > p0
      lo_c0  = mi_c0;
      lo_pwr = mi_pwr;
  else
      hi_c0  = mi_c0;
      hi_pwr = mi_pwr;
  end
  it = it + 1;
end
if abs(lo_pwr-p0)/p0 < abs(hi_pwr-p0)/p0
   c0   = lo_c0;
   pw0  = lo_pwr;
else
   c0   = hi_c0;
   pw0  = hi_pwr;
end
     
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
