#include <stdio.h>
#include <math.h>

/*******************************************************************/

int main (int argc, const char * argv[])
{
  FILE  *fp;
  char  failed;
  char  *filein, *fileout;
  int   i, j, k, max_idx, idx, maxitds, sfreq, N, N2;
  int   nread;
  float a, b, ic_max, maxild, alpha, alpha2, alpha3;
  float *num, *den1, *den2, *num_, *den1_, *den2_;
  float *lev1, *lev2, *ic, *pw, *ild, *itd, *in1, *in2;
  
  /* parse command-line parameters */
    
  if(argc != 9) goto usage;
    
  sscanf(argv[1],"%d",&sfreq);
  sscanf(argv[2],"%f",&maxild);
  sscanf(argv[3],"%d",&maxitds);
  sscanf(argv[4],"%f",&alpha);
  sscanf(argv[5],"%f",&alpha2);
  sscanf(argv[6],"%f",&alpha3);
  filein  = argv[7];
  fileout = argv[8];
      
  /* find out how long input file is */
    
  fp = fopen(filein,"rb");
  if (fp == NULL) {
    printf("Could not open input file!\n");
    exit(0);
  }
  fseek(fp, 0 , SEEK_END);
  N = ftell(fp);
  fseek(fp, 0 , SEEK_SET);
  if (N % (sizeof(float)*2) != 0) {
    printf("Input file has not a correct length!\n");
    exit(0);
  }
  N /= 2 * sizeof(float);
       
  /* allocate memory */

  failed        = 0;
  num = (float*) malloc((2*maxitds+1)*sizeof(float));
  if (num == NULL) failed = 1;
  den1 = (float*) malloc((2*maxitds+1)*sizeof(float));
  if (den1 == NULL) failed = 1;
  den2 = (float*) malloc((2*maxitds+1)*sizeof(float));
  if (den2 == NULL) failed = 1;
  num_ = (float*) malloc((2*maxitds+1)*sizeof(float));
  if (num_ == NULL) failed = 1;
  den1_ = (float*) malloc((2*maxitds+1)*sizeof(float));
  if (den1_ == NULL) failed = 1;
  den2_ = (float*) malloc((2*maxitds+1)*sizeof(float));
  if (den2_ == NULL) failed = 1;
  lev1 = (float*) malloc((2*maxitds+1)*sizeof(float));
  if (lev1 == NULL) failed = 1;
  lev2 = (float*) malloc((2*maxitds+1)*sizeof(float));
  if (lev2 == NULL) failed = 1;

  in1 = (float*) malloc(N*sizeof(float));
  if (in1 == NULL) failed = 1;
  in2 = (float*) malloc(N*sizeof(float));
  if (in2 == NULL) failed = 1;
  
  N2 = N - 2*maxitds;
  ic = (float*) malloc(N2*sizeof(float));
  if (ic == NULL) failed = 1;
  pw = (float*) malloc(N2*sizeof(float));
  if (pw == NULL) failed = 1;
  ild = (float*) malloc(N2*sizeof(float));
  if (ild == NULL) failed = 1;
  itd = (float*) malloc(N2*sizeof(float));
  if (itd == NULL) failed = 1;
  
  if (failed == 1) {
    printf("Memory allocation problem!");
    exit(1);
  }
  
  /* load audio data from disk */
 
  nread = fread((char*)in1, sizeof(float),N,fp);   
  if (nread != N) {
    printf("Could not read all input data!\n");
    exit(1);
  }
    
  nread = fread((char*)in2, sizeof(float),N,fp);   
  if (nread != N) {
    printf("Could not read all input data!\n");
    exit(1);
  }
    
  fclose(fp);
  
  /* initialize state variables */
  
  for (i = 0; i < 2*maxitds+1; i++) {
    num[i]   = 1e-40;
    den1[i]  = 1e-40;
    den2[i]  = 1e-40;
    num_[i]  = 1e-40;
    den1_[i] = 1e-40;
    den2_[i] = 1e-40;
    lev1[i]  = 1e-40;
    lev2[i]  = 1e-40;
  }
  
  for (i = 0; i < N2; i++) {
    ic[i]   = .0;
    pw[i]  = .0;
    ild[i]  = .0;
    itd[i]  = .0;
  }
  
  /* compute cues */

  for (i = 0; i < N2; i++) {
    
    /* estimate ic */
    
    for (k = 0; k <= maxitds; k++) {
      num[k] = alpha*in1[i+maxitds]*in2[i+k] + (1.-alpha)*num[k];
      den1[k] = alpha*in1[i+maxitds]*in1[i+maxitds] + (1.-alpha)*den1[k];
      den2[k] = alpha*in2[i+k]*in2[i+k] + (1.-alpha)*den2[k];
    }
    for (; k < 2*maxitds+1; k++) {
      j = k-maxitds;
      num[k] = alpha*in2[i+maxitds]*in1[i+maxitds-j] + (1.-alpha)*num[k];
      den1[k] = alpha*in2[i+maxitds]*in2[i+maxitds] + (1.-alpha)*den1[k];
      den2[k] = alpha*in1[i+maxitds-j]*in1[i+maxitds-j] + (1.-alpha)*den2[k];
    }
    
    ic_max = -1;
    for (k = 0; k < 2*maxitds+1; k++) {
      a = num[k]/sqrt(den1[k]*den2[k] + 1e-20);
      if (a > ic_max) {
        ic_max = a;
        max_idx = k;
      }
    }
    
    ic[i] = ic_max;
            
    /* estimate itd */
    
    for (k = 0; k <= maxitds; k++) {
      num_[k] = alpha3*in1[i+maxitds]*in2[i+k] + (1.-alpha3)*num_[k];
      den1_[k] = alpha3*in1[i+maxitds]*in1[i+maxitds] + (1.-alpha3)*den1_[k];
      den2_[k] = alpha3*in2[i+k]*in2[i+k] + (1.-alpha3)*den2_[k];
    }
    for (; k < 2*maxitds+1; k++) {
      j = k-maxitds;
      num_[k] = alpha3*in2[i+maxitds]*in1[i+maxitds-j] + (1.-alpha3)*num_[k];
      den1_[k] = alpha3*in2[i+maxitds]*in2[i+maxitds] + (1.-alpha3)*den1_[k];
      den2_[k] = alpha3*in1[i+maxitds-j]*in1[i+maxitds-j] + (1.-alpha3)*den2_[k];
    }
    
    ic_max = -1;
    for (k = 0; k < 2*maxitds+1; k++) {
      a = num[k]/sqrt(den1[k]*den2[k] + 1e-20);
      if (a > ic_max) {
        ic_max = a;
        max_idx = k;
      }
    }
    
    itd[i] = (max_idx-maxitds)/((float)sfreq)*1000.;
    
    /* estimate ild and pow */
    
    for (k = 0; k <= maxitds; k++) {
      a = in1[i+maxitds];
      lev1[k] = alpha2*a*a + (1.-alpha2)*lev1[k];
      a = in2[i+k];
      lev2[k] = alpha2*a*a + (1.-alpha2)*lev2[k];
    }
    for (; k < 2*maxitds+1; k++) {
      j = k-maxitds;
      a = in1[i+maxitds-j];
      lev1[k] = alpha2*a*a + (1.-alpha2)*lev1[k];
      a = in2[i+maxitds];
      lev2[k] = alpha2*a*a + (1.-alpha2)*lev2[k];
    }

    idx = max_idx;
    //idx = maxitds;

    a = 10.*log10((lev1[idx]+1e-40)/(lev2[idx]+1e-40));
    if (a > maxild) a = maxild;
    if (a < -maxild) a = -maxild;
    ild[i] = a;
  
    a = lev1[idx];
    b = lev2[idx];
    pw[i] = a + b;
  }
  
  /* save results */
  
  fp = fopen(fileout,"wb");
  if (fp == NULL) {
    printf("Could not open file for saving results!\n");
    exit(0);
  }
    
  nread = fwrite((char*)ild, sizeof(float),N2,fp);   
  if (nread != N2) {
    printf("Could not write all data! (1)\n");
    exit(1);
  }
  
  nread = fwrite((char*)itd, sizeof(float),N2,fp);   
  if (nread != N2) {
    printf("Could not write all data! (1)\n");
    exit(1);
  }
  
  nread = fwrite((char*)ic, sizeof(float),N2,fp);   
  if (nread != N2) {
    printf("Could not write all data! (1)\n");
    exit(1);
  }
  
  nread = fwrite((char*)pw, sizeof(float),N2,fp);   
  if (nread != N2) {
    printf("Could not write all data! (1)\n");
    exit(1);
  }
  
  fclose(fp);
  return 0;
usage:
    printf("Usage:\n");  
    printf("  ilditdic <fs> <maxild> <maxitds> <a> <a1> <a2> <fIn> <fOut>\n");  
    printf("    fs      = sampling frequency [Hz]\n");  
    printf("    maxild  = range of ild [dB]\n");  
    printf("    maxitds = range of itd [samples]\n");  
    printf("    a       = smoothing constant for ic computation\n");  
    printf("    a1      = smoothing constant for ild computation\n");  
    printf("    a2      = smoothing constant for itd computation\n");  
    printf("    fIn     = input data file\n");  
    printf("    fOut    = output data file\n");  
    printf("\n");
    return 0;
}


/*******************************************************************/
