function [g] = plot_pdf(psize,pos,ild_itd_pdf,ild_pdf,itd_pdf,axis_ild,axis_itd,ild_ff,itd_ff,ildrange,itdrange,maxval)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%     Plot ILD-ITD probability density functions:
%           p(ILD,ITD), p(ILD), p(ITD)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  [g] = plot_pdf(size,pos,ild_itd_pdf,ild_pdf,itd_pdf,axis_ild,axis_itd,ild_ff,itd_ff,range,maxval)
%
%  Input parameters:
%    psize:       PDF panels [rows,columns] fit in window (supported values:
%                 rows = 1...2, columns = 1...3)
%    pos:         PDF plot position (the positions are counted along the top
%                 row and then the possible second row, 1 = top left)
%    ild_itd_pdf: p(ILD,ITD|IC>c0)
%    ild_pdf:     p(ILD|IC>c0)
%    itd_pdf:     p(ITD|IC>c0)
%    axis_ild:    ild values
%    axis_itd:    itd values
%    ild_ff:      free field ILDs (optional)
%    itd_ff:      free field ITDs (optional)
%    ildrange:    plot range for ILD [dB] (optional,
%                 default: ildrange = max(abs(axis_ild)))
%    itdrange:    plot range for ITD [ms] (optional,
%                 default: itdrange = max(abs(axis_itd)))
%    maxval:      value corresponding to black in 2D PDF (optional,
%                 default: maxval = 1)
%
%  Output parameters:
%    g:         handle to axis
%
%
%  Authors:
%    C. Faller and J. Merimaa 12-2003
%   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


if nargin < 8
  ild_ff = [];
end
if nargin < 9
  itd_ff = [];
end
if nargin < 10 | isempty(ildrange)
  ildrange = max(abs(axis_ild));
end
if nargin < 11 | isempty(itdrange)
  itdrange = max(abs(axis_itd));
end
if nargin < 12 | isempty(maxval)
  maxval = 1;
end

clim     = [0 maxval];

if psize(1) == 1
  % one row
  if psize(2) == 1
    % one column
    box_ild_itd = [0.27 0.27 .65 0.6];
    box_itd     = [0.27 0.1 .65 0.15];
    box_ild     = [0.1 0.27 .15 0.6];
    % two columns
  elseif psize(2) == 2
    box_ild_itd = [0.225+(pos-1)*.425 0.5 .22 0.22];
    box_itd     = [0.225+(pos-1)*.425 0.4 .22 0.08];
    box_ild     = [0.13+(pos-1)*.425  0.5 .08 0.22];
    % three columns
  elseif psize(2) == 3
    box_ild_itd = [0.17+(pos-1)*.30  0.5 .18 0.22];
    box_itd     = [0.17+(pos-1)*.30  0.4 .18 0.08];
    box_ild     = [0.075+(pos-1)*.30 0.5 .08 0.22];
  end
elseif psize(1) == 2
  % two rows
  if pos > psize(2)
    xpos = pos - psize(2);
    ypos = 2;
  else
    xpos = pos;
    ypos = 1;
  end
  if psize(2) == 1
    % one column
    box_ild_itd = [0.44  0.7-(ypos-1)*.47 .22 0.22];
    box_itd     = [0.44  0.6-(ypos-1)*.47 .22 0.08];
    box_ild     = [0.345 0.7-(ypos-1)*.47 .08 0.22];
  elseif psize(2) == 2
    % two columns
    box_ild_itd = [0.225+(xpos-1)*.425 0.7-(ypos-1)*.47 .22 0.22];
    box_itd     = [0.225+(xpos-1)*.425 0.6-(ypos-1)*.47 .22 0.08];
    box_ild     = [0.13+(xpos-1)*.425  0.7-(ypos-1)*.47 .08 0.22];
  elseif psize(2) == 3
    % three columns
    box_ild_itd = [0.17+(xpos-1)*.30  0.7-(ypos-1)*.47 .18 0.22];
    box_itd     = [0.17+(xpos-1)*.30  0.6-(ypos-1)*.47 .18 0.08];
    box_ild     = [0.075+(xpos-1)*.30 0.7-(ypos-1)*.47 .08 0.22];
  end
end
if ~exist('box_ild_itd')
  error(['psize = [' int2str(psize(1)) ' ' int2str(psize(2)) '] not supported']);
end

% joint pdf
g(1)=axes('Position',box_ild_itd);
imagesc(axis_itd,axis_ild,ild_itd_pdf,clim)
colormap(flipud(gray));
set(g(1),'XTickLabel',[])
set(g(1),'YTickLabel',[])
axis([-itdrange itdrange -ildrange ildrange])
% itd pdf
g(2)=axes('Position',box_itd);
plot(axis_itd, itd_pdf, 'k');
hold on
for j = 1:max(size(itd_ff)),
  plot([itd_ff(j) itd_ff(j)], [0 1], 'k:','linewidth',2);
end
hold off
xlabel('\tau [ms]')
set(g(2),'YTickLabel',[])
ylabel('p(\tau)')
axis([-itdrange itdrange 0 1])
% ild pdf
g(3)=axes('Position',box_ild);
plot(ild_pdf, fliplr(axis_ild), 'k')
hold on
for j = 1:max(size(ild_ff)),
  plot([0 1], [-ild_ff(j) -ild_ff(j)], 'k:','linewidth',2);
end
hold off
axis([0 1 -ildrange ildrange])
if psize == 1 & pos(1) > 0
  set(g(3),'YTickLabel',[])
else
  ylabel('\DeltaL [dB]')
end
xlabel('p(\DeltaL)')
set(g(3),'XTickLabel',[])
set(g(3),'XAxisLocation','Top')
      
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
