function [pwr]=pwr_c0(ic,pow,c0)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%       Compute relative power of signal portion
%                    with IC > c0
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Input parameters:
%    ic:        IC as a function of time
%    pow:       power as a function of time
%    c0:        specific IC for which to compute average BCM
%
%  Output parameters:
%    pwr:    fraction of signal power with IC>c0
%
%  Authors:
%    C. Faller and J. Merimaa 07-2003
%   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pwr = sum((ic > c0).*pow)/sum(pow);
            
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
