function [v,norm]=decay2_fit(data,expf,w,figno)

% fit decay_model to dB-scaled energy-time decay curve
% data(:,1) = decay data (dB scaled)
% data(:,2) = optional time sample points
% expf = optional weighting factor
% w = weighting vector, default equal weights
% figno = optional figure number, 0=no figure

sizd=size(data);                      % data dimensionality
sn=sizd(1); sn2=ceil(sn/2);           % size, size/2
sn10=ceil(sn/10);                     % size/10
if (nargin<4) figno = 0; end          % figure to draw to or none=0
if (nargin<3)|(isempty(w))
	w=ones(sn,1); end                 % weight vector
if (nargin<2) expf=0.4; end           % expf for model function
if isempty(expf) expf=0.4; end        % expf for model function
%
y=data(:,1);                          % dB scaled magnitudes
if (sizd(2)<2) x=(1:sizd(1))';        % time value vector default
else x=data(:,2);                     % optionally given time points
end
ydata=(10.^(y./20)).^expf;            % magnitude data scaled
nz=find(w); bi=nz(1);                 % start index (bi) of nonzero weight
y1=mean(ydata(bi:sn10+bi));           % average of first 10% (after bi)
yn=mean(ydata(sn-sn10+1:sn));         % average of last 10%
tmat = [ones(sn2,1) x(bi:sn2+bi-1)];
p=tmat\y(bi:sn2+bi-1);                % regression line 50% after bi
tau0=p(2)/8.7;                        % decay parameter initial value
%p2_tau0=[p(2) tau0]
v0=[y1 tau0 yn];                      % vector of variables initial value
%v0=[y1 -20 yn];
ydata=w.*ydata;                       % ydata weighted
%
[v,norm]=curvefit('decay_model',v0,x,ydata,[],[],expf,w); % optimize
%                                     % v = model coefficients
if (figno>0) plot(x,y); hold on; end  % plot target data if figno~=0
z=20*log10(decay_model(v,x,1));
if (figno>0) plot(x,z,'r'); hold off; end  % plot fitted data if figno~=0

% Call this way: decay2_fit(vp(:,40),[],[],1)
