function S=compkautz(a,N,X) 

% S=compkautz(a,N,X): Tap-output signals of a complex Kautz filter, 
% defined by pole vector a, excited by X. N is the desired length 
% of the output, if N > length(X). Tap-output signals are the columns 
% of S. S is real valued only in the case of real poles.
%
% Examples:	
%
%* G=compkautz(a,N,1) are the (length N) impulse responses of Kautz 
%	functions defined by a.
%
%* Orthonormatity could be tested by S'*S=I (for sufficient N)
%
%* y=S*w, S=compkautz(a,N,x), is the Kautz filter response to input x 
%	with coefficient vector w.
%
%* c=S(N,:), N=length(X), are the Fourier coefficients produced by 
% 	feeding invX=X(N:-1:1) to S=compkautz(a,N,invX) and reading the 
%	tap-outputs at N. These are the LS optimal coefficients for 
%	approximating x with y=G*c.

if length(X)<N,
	X=[X;zeros(N-length(X),1)]; 	% zero-padding of X to length N
end
a=a(:);
p=length(a);
% The first block is an normalized all-pole filter
S(:,1)=filter([sqrt(1-a(1)*a(1)') 0],[1 -a(1)],X);	
Y=X;
for i=2:p,
	Y=filter([-a(i-1)' 1],[1 -a(i-1)],Y);					% AP filtering
	S(:,i)=filter([sqrt(1-a(i)*a(i)') 0],[1 -a(i)],Y);	% Normalization
end

% Revised November 7, 2000, Tuomas Paatero
