function [c,E,h]=kautzapprx1(a,x)

% [c,E,h]=kautzapprx1(a,x): Approximates (in the LS sense) x with a  
% real Kautz  filter, defined by pole vector a, using mixkautz1.m. 
%
% Note that a is replaced by a=a(find(imag(a)>=0)) to avoid duplication 
% produced by complex conjugate poles, so check the resulting filter order. 
%
% c are the Fourier coefficients produced by feeding the time-inverted
% x to the Kautz filter and reading tap-outputs at time N. These are 
% the LS optimal coefficients for approximating x with the Kautz model
% h=G*c, where G=mixkautz1(a,length(X),1) are the impulse responses.
%
% E is the normalized RMS error of the approximation. Note that this is 
% the "true" LS estimate in [1,infty], not e.g. in [1,length(x)]. 

N=length(x);
invx=x(N:-1:1); 				% time-inverse of x
S=mixkautz1(a,N,invx);		% response to invx
G=mixkautz1(a,N,1);			% impulse response
c=S(N,:);					% calculation of Fourier/LS coefficients
c=c(:);
X2=x'*x;						% energy of x
C2=c'*c;						% energy of h
E2=X2-C2;					% approximation error energy in [1,inty]
E=sqrt(E2/X2);				% normalized RMSE
h=G*c;						% approximation in [1,N]

% Revised November 7, 2000, Tuomas Paatero
