function kautzdemo1

load kautzdemo;
hi=impresp(41:1064); 	% delay elimination and truncating
ih=invtarget;				% to speed up the convolutions
H=abs(fft(hi,4096));
H=H(1:2048);
IH=abs(fft(ih,4096));
IH=IH(1:2048);
E=abs(fft(conv(hi,ih),4096));
E=E(1:2048);
disp('   ')
disp('Hello, this is a demonstration of the included Kautz filter design')
disp('tools braun1.m and kautzapprox1.m. To get more information about the')
disp('scripts use MATLAB help. The actual operations are also commented so')
disp('you may want to inspect directly the m-files.')
disp('  ')
disp('This case example concerns loudspeaker equalization. Here we use a')
disp('pre-designed target response to model the Kautz equalizers so this')
disp('is pure magnitude equalization. The measured loudspeaker impulse')
disp('response and the target equalized and equalizer responses are')
disp('displayed in the figure.')
disp(' ')
disp('.... press any key to continue ...')
%pause
clf
semilogx(f,20*log10([H*4 E IH/4]))
axis([40 25000 -40 30])
title('The target, equalized and measured responses')
xlabel('Frequency / Hz')
ylabel('Magnitude / dB')
pause
disp('  ')
disp('A straightforward FIR equalizer would give equalization results')
disp('depicted in the figure as a function of the filter order.')
%
semilogx(f,20*log10(H*4))
axis([40 25000 -40 60])
title('FIR equalization results  for orders 50,100,150, .., 500')
xlabel('Frequency / Hz')
ylabel('Magnitude / dB')
for i=51:50:501
   hold on;
   A=abs(fft(conv(hi,ih(1:i)),4096));
   A=A(1:2048);
   if i==201
      F200=A;
   end
   semilogx(f,20*log10(A*2^((i-51)/50)))
end
hold off;
disp(' ')
disp('.... press any key to continue ...')
pause
%)
disp(' ')
disp('For example, the FIR equalizer of order 150 is sufficient for high')
disp('frequencies but to really flatten the 1 kHz region would require')
pause(1)
disp('a very high filter order.')
disp('  ')
pause(1)
disp('Warped FIR filters or Laguerre filters release some of the modeling') 
disp('resolution to the lower frequencies. In the figure we have applied') 
pause(1)
disp('[c,e,h]=kautzapprx1(.73*ones(N,1),target) to produce Laguerre')
disp('equalizer responses h of order N, and plotted the corresponding')
pause(1)
disp('equalized magnitude responses. This will take a while...')
%
semilogx(f,20*log10(H*4))
axis([40 25000 -40 50])
title('Laguerre equalization for orders 25, 50, 75,..., 150')
xlabel('Frequency / Hz')
ylabel('Magnitude / dB')
text(130,-2,'Laguerre, order 25')
for i=25:25:150
   pause(1)
   hold on;
   [c,e,h]=kautzapprx1(.73*ones(i,1),ih);
   A=abs(fft(conv(hi,h),4096));
   if i==100
      L100=A(1:2048);
   end
   A=A(1:2048).*2^(i/25);
   semilogx(f,20*log10(A))
end
text(130,43,'Laguerre, order 150')
hold off;
disp(' ')
disp('.... press any key to continue...')
pause
disp('  ')
disp('A Kautz filter defined by a pole pair corresponding to the 1 kHz')
pause(1)
disp('region, e.g. with pole vector .7*exp(j*.13)*ones(N/2,1), will give')
pause(1)
disp('quite similar results. Notice that a complex pole vector z, with')
pause(1)
disp('imag(z)>0, produces an real Kautz equalizer of order 2*length(z).')
pause(1)
disp('This should take about the same time ...')
%
semilogx(f,20*log10(H*4))
axis([40 25000 -40 50])
title('Two-pole Kautz equalization for orders 24, 48, 72, 96, 120 and 144')
xlabel('Frequency / Hz')
ylabel('Magnitude / dB')
text(130,-2,'Order 24 (2 x 12)')
for i=12:12:72
   pause(1)
   hold on;
   [c,e,h]=kautzapprx1(.7*exp(j*.13)*ones(i,1),ih);
   A=abs(fft(conv(hi,h),4096));
   A=A(1:2048).*2^(i/12);
   semilogx(f,20*log10(A))
end
text(130,43,'Order 144 (2 x 72)')
hold off;
disp(' ')
disp('.... press any key to continue ...')
pause
disp(' ')
disp('We proceed to more complicated but lower order Kautz models.')
disp('  ')
disp('Function [E,Q]=braun1(N,I,x) uses I iterations to search for an Nth')
disp('order Kautz structure to approximate x. E(i) is the NRMS error and') 
disp('Q(i,:) are the AP (numerator) polynomial coefficients, for i=1:I.')
disp('  ')
disp('We use roots(Q(k,:)), corresponding to minimum E, from [m,k]=min(E),') 
disp('as the Kautz filter poles. The figure displays pre-calculated pole')
disp('sets for some filter orders and I=40.')
%
subplot(3,3,1)
zplane(P(1:4,4))
title('orders 4, 19, 34')
subplot(3,3,2)
zplane(P(1:7,7))
title('orders 7, 22, 37')
subplot(3,3,3)
zplane(P(1:15,15))
title('orders 15, 28, 40')
subplot(3,3,4)
zplane(P(1:19,19))
%title('order 19')
subplot(3,3,5)
zplane(P(1:22,22))
%title('order 22')
subplot(3,3,6)
zplane(P(1:28,28))
%title('order 28')
subplot(3,3,7)
zplane(P(1:34,34))
%title('order 34')
subplot(3,3,8)
zplane(P(1:37,37))
%title('order 37')
subplot(3,3,9)
zplane(P(1:40,40))
%title('order 40')
%
disp('  ')
disp('.... press any key to continue ...')
pause

disp('  ')
disp('Next figure contains the Kautz equalizers and equalization results')
pause(1)
disp('for Kautz filter orders 9, 15, 30 and 38 from the previous pole sets.')
pause(1)
semilogx(f,20*log10([H*4 IH*8]))
axis([40 25000 -35 90])
%title('Kautz equalizers and equalization results for orders 9, 15, 30 and 38')
xlabel('Frequency / Hz')
ylabel('Magnitude / dB')
text(130,85,'Kautz equalizers, orders 38, 30, 15 and 9')
text(130,35,'The target')
text(130,-2,'Equalization results, orders 9,15,30 and 38')
text(130,-22,'The measured response')

ind=[9 15 30 38];
for i=1:4
   pause(1)
   hold on;
   [c,e,h]=kautzapprx1(P(1:ind(i),ind(i)),ih);
   K=abs(fft(h));
   K=K(1:2048)*2^(i+4);
   A=abs(fft(conv(hi,h),4096));
   A=A(1:2048).*2^(i);
   semilogx(f,20*log10([A K]))
end
hold off;
disp('  ')
disp('.... press any key to continue ...')
pause
disp(' ')
disp('For higher orders, braun1.m produces poles really close to z=1')
disp('because of the low frequency boost in the target. Omitting some of')
%pause(1)
disp('these poles tranquilize the low frequency behavior. We have used pole')
disp('sets 30 and 38 to produce Kautz equalizers of orders 28 and 34.')
%
[c,e,h]=kautzapprx1(P([1:26,29:30],30),ih);
K=abs(fft(h));
K=K(1:2048)*2;
A=abs(fft(conv(hi,h),4096));
A=A(1:2048)*2;
[c,e,h]=kautzapprx1(P([1:33,36],38),ih);
K2=abs(fft(h));
K2=K2(1:2048)*4;
A2=abs(fft(conv(hi,h),4096));
A2=A2(1:2048)*4;
semilogx(f,20*log10([H*4 IH A A2 K K2]))
axis([40 25000 -35 52])
%title('Kautz equalizers and equalization results for orders 28 and 34')
xlabel('Frequency / Hz')
ylabel('Magnitude / dB')
text(130,47,'Kautz equalizers, orders 34 and 28')
text(130,20,'The target')
text(130,-3,'Equalization results, orders 28 and 34')
text(130,-22,'The measured response')
disp('  ')
disp('.... press any key to continue ...')
pause
disp('   ')
disp('To flatten the 1 kHz region, we tune manually 3 to 4 pole pairs')
disp('corresponding to the resonances. We use the 15 and 30 order pole')
pause(1)
disp('sets, omitting 3 pole pairs in the latter case, as the starting')
disp('point. The results for final orders 23, 32 and 34 are presented')
pause(1)
disp('in the figure...')

b=P([1:2:23,29],30);
a=exp(j*pi*[62 85 107 121.5]/2048);

[c,e,h]=kautzapprx1([P(1:15,15);.97*a(1);.999*a(2);.998*a(3);.997*a(4)],ih);
K=abs(fft(h));
K=K(1:2048)*4;
A=abs(fft(conv(hi,h),4096));
A=A(1:2048)*2;
[c,e,h]=kautzapprx1([b;.999*a(2);.997*a(3);.995*a(4)],ih);
K1=abs(fft(h));
K1=K1(1:2048)*8;
A1=abs(fft(conv(hi,h),4096));
A1=A1(1:2048)*4;
[c,e,h]=kautzapprx1([b;.99*a(1);.999*a(2);.997*a(3);.995*a(4)],ih);
K2=abs(fft(h));
K2=K2(1:2048)*16;
A2=abs(fft(conv(hi,h),4096));
A2=A2(1:2048)*8;

semilogx(f,20*log10([H*4 IH*2 A A1 A2 K K1 K2]))
axis([40 25000 -35 65])
%title('Kautz equalizers and equalization results for orders 28 and 34')
xlabel('Frequency / Hz')
ylabel('Magnitude / dB')
text(100,60,'Kautz equalizers, orders 34, 32 and 23')
text(100,25,'The target')
text(100,-3,'Equalization results, orders 23, 32 and 34')
text(100,-22,'The measured response')
disp('  ')
disp('.... press any key to continue ...')
pause
disp('  ')
disp('Finally, we abandon completely the poles proposed by braun1.m and')
disp('try to tune 10 pole pairs to the target response resonances. This is')
disp('of course somewhat arbitrary but it works! Along with the equalized')
disp('and equalizer responses for the composed 20th order Kautz filter')
disp('are vertical lines indicating pole pair positions. ')

a=exp(j*pi*[62 85 107 121 370 548 590 724 965 1980]'/2048); % pole angles
r=[.94 .9985 .997 .994 .87 .985 .985 .95 .84 .9]';				% pole radii

[c,e,h]=kautzapprx1(r.*a,ih);
K=abs(fft(h));
K=K(1:2048);
A20=abs(fft(conv(hi,h),4096));
A20=A20(1:2048);

semilogx(f,20*log10([H*2 IH/2 A20 K]))
axis([40 25000 -45 50])
%title('Kautz equalizers and equalization results for orders 28 and 34')
xlabel('Frequency / Hz')
ylabel('Magnitude / dB')
text(100,43,'Manually tuned 20th order Kautz equalizer')
text(100,12,'The target')
text(100,-5,'The equalized response')
text(100,-28,'The measured response')
p=angle(a)/pi*24000;						% adding lines to the figure
L=[10;38]*ones(1,10);					% to indicate pole pair positions
line([p';p'],L);
disp('  ')
disp('.... press any key to continue ...')
pause
disp('  ')
disp('The last figure compares Kautz equalization results to FIR and Laguerre')
disp('of orders 200 and 100, respectively. If we are only interested in the')
disp('computational load at runtime, we should actually compare Laguerre and')
disp('Kautz at same filter orders. The "disadvantage factor" compared to the')
disp('FIR implementation would then be 2 to 5 (i.e. in filter order ratio).')
%
semilogx(f,20*log10([H*2 A20 A*2 A2*2 L100*64 F200*256]))
axis([40 25000 -40 60])
title('Comparison of FIR,Laguerre and Kautz equalization results')
xlabel('Frequency / Hz')
ylabel('Magnitude / dB')
text(100,43,'FIR filter, order 200')
text(100,31,'Laguerre filter, order 100')
text(100,19,'Partly manually tuned, order 34 (26+8)')
text(100,7,'Partly manually tuned, order 23 (15+8)')
text(100,-5,'Manually tuned 20th order')
text(100,-28,'The measured response')
disp(' ')
disp('.... That''s all, thank you for your interest, to exit  ...')
disp('  ')
pause

% Revised November 29, 2000, Tuomas Paatero
