% This is an example how to simulate spatial cues generated by a real and
% a virtual sound sources. 

% (C) Ville Pulkki 1999
% Helsinki University of Technology
% Laboratory of Acoustics and Audio Signal Processing
% Ville.Pulkki@hut.fi

% Auditory toolbox
path(path,'/work/matlab5/toolbox/AuditoryToolbox')

% Measured HRTFs of a KEMAR dummy head, available at
% http://sound.media.mit.edu/KEMAR.html

path(path,'/work/people/ville/tyo/kemar/matlab_scripts')

%First, we calculate cues for virtual source at azi 15 ele 0

srate = 44100
 
% White noise, duration 1/2 sec. Pink noise would maybe be better.
signal= (rand(1,srate/2)-0.5)*10000;
% Filtering the signal with inverse filter of the loudspeaker
% used in KEMAR measurements to take the loudspeakers acoustic effect away.

invfilt=readraw('/work/people/ville/tyo/kemar/full/headphones+spkr/Opti-inverse.dat');
signal=filter(invfilt,[1],signal);

%Calculating the signals arriving to listener's ears
tmp=readhrtf(0,15,'L');
hrirr=tmp(1,:);
hrirl=tmp(2,:);
signall=filter(hrirl,[1],signal);
signalr=filter(hrirr,[1],signal);

% Cue simulation
[ILD_real, ITD_real, Xcorr_real, CLL_real, freqs] = simuspatcues(signall,signalr,srate);

% Then, a amplitude panned virtual source in standard stereophonic
% listening, loudspeakers at +-30 degr and virtual source at 15 degr
%
% Gain factors have been calculated with sine law

g(2)=0.7588;
g(1)=0.2412;
tmp=readhrtf(0,30,'L');
hrir1l=tmp(1,:);
hrir1r=tmp(2,:);
hrir2l=tmp(2,:);
hrir2r=tmp(1,:);

%summing localization
signall=g(1)*filter(hrir1l,[1],signal) + g(2)*filter(hrir2l,[1],signal);
signalr=g(1)*filter(hrir1r,[1],signal)+ g(2)*filter(hrir2r,[1],signal);

%cues
[ILD_virt, ITD_virt, Xcorr_virt, CLL_virt, freqs] = simuspatcues(signall,signalr,srate);

%plotting the data

plot(freqs,ILD_real,'--',freqs,ILD_virt,'-')
title('ILDs, solid virtual, dashed real')
pause
plot(freqs,ITD_real,'--',freqs,ITD_virt,'-')
title('ITDs, solid virtual, dashed real')